/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.completion;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.debugger.jpda.ui.completion.ClassCompletionProvider;
import org.netbeans.modules.debugger.jpda.ui.completion.ClassSearchScopeType;
import org.netbeans.modules.debugger.jpda.ui.completion.ElementCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;

public class ExceptionCompletionProvider
implements CompletionProvider {
    private static final Set<? extends ClassIndex.SearchScopeType> scopeAll = Collections.singleton(new ClassSearchScopeType());

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                String text;
                if (caretOffset < 0) {
                    caretOffset = 0;
                }
                try {
                    text = doc.getText(0, caretOffset);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    text = "";
                }
                Set<ClassSearchScopeType> scope = Collections.singleton(new ClassSearchScopeType(text));
                int n = text.length();
                ClasspathInfo cpi = ClassCompletionProvider.getClassPathInfo();
                ClassIndex classIndex = cpi.getClassIndex();
                Set packageNames = classIndex.getPackageNames(text, false, scope);
                HashSet<String> resultPackages = new HashSet<String>();
                int lastTextDot = text.lastIndexOf(46);
                for (String pn : packageNames) {
                    int dot = pn.indexOf(46, n);
                    if (dot > 0) {
                        pn = pn.substring(0, dot);
                    }
                    if (lastTextDot > 0) {
                        pn = pn.substring(lastTextDot + 1);
                    }
                    if (resultPackages.contains(pn)) continue;
                    resultSet.addItem((CompletionItem)new ElementCompletionItem(pn, ElementKind.PACKAGE, caretOffset));
                    resultPackages.add(pn);
                }
                String classFilter = lastTextDot > 0 ? text.substring(lastTextDot + 1) : text;
                ElementHandle throwable = null;
                Set throwableTypes = classIndex.getDeclaredTypes(Throwable.class.getSimpleName(), ClassIndex.NameKind.PREFIX, Collections.singleton(new ClassSearchScopeType(Throwable.class.getPackage().getName() + ".")));
                for (ElementHandle type : throwableTypes) {
                    String className = type.getQualifiedName();
                    if (!className.equals(Throwable.class.getName())) continue;
                    throwable = type;
                    break;
                }
                if (throwable != null) {
                    Set throwables = ExceptionCompletionProvider.getAllImplementors(classIndex, (ElementHandle<TypeElement>)throwable, scope);
                    HashSet<String> resultClasses = new HashSet<String>();
                    for (ElementHandle type : throwables) {
                        int dot;
                        String className = type.getQualifiedName();
                        int packageDotIndex = -1;
                        if (lastTextDot > 0) {
                            if (!(className = className.substring(lastTextDot + 1)).startsWith(classFilter)) {
                                continue;
                            }
                        } else {
                            packageDotIndex = type.getBinaryName().lastIndexOf(46);
                            if (packageDotIndex > 0) {
                                className = className.substring(packageDotIndex + 1);
                            }
                        }
                        if ((dot = className.indexOf(46)) > 0) {
                            className = className.substring(0, dot);
                        }
                        if (resultClasses.contains(className)) continue;
                        ElementCompletionItem eci = new ElementCompletionItem(className, type.getKind(), caretOffset);
                        if (packageDotIndex > 0 && lastTextDot < 0) {
                            eci.setInsertPrefix(type.getQualifiedName().substring(0, packageDotIndex + 1));
                        }
                        resultSet.addItem((CompletionItem)eci);
                        resultClasses.add(className);
                    }
                }
                resultSet.finish();
            }
        }, component);
    }

    private static Set<ElementHandle<TypeElement>> getAllImplementors(ClassIndex classIndex, ElementHandle<TypeElement> elm, Set<? extends ClassIndex.SearchScopeType> scope) {
        HashSet<ElementHandle<TypeElement>> impls = new HashSet<ElementHandle<TypeElement>>();
        ExceptionCompletionProvider.fillAllImplementors(classIndex, elm, scope, impls);
        return impls;
    }

    private static void fillAllImplementors(ClassIndex classIndex, ElementHandle<TypeElement> elm, Set<? extends ClassIndex.SearchScopeType> scope, Set<ElementHandle<TypeElement>> impls) {
        Set impl = classIndex.getElements(elm, Collections.singleton(ClassIndex.SearchKind.IMPLEMENTORS), scope);
        impls.addAll(impl);
        Set allImpl = classIndex.getElements(elm, Collections.singleton(ClassIndex.SearchKind.IMPLEMENTORS), scopeAll);
        for (ElementHandle eh : allImpl) {
            ExceptionCompletionProvider.fillAllImplementors(classIndex, (ElementHandle<TypeElement>)eh, scope, impls);
        }
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 1;
    }
}

