/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;

class ElementCompletionItem
implements CompletionItem {
    private static final String ICON_PACKAGE = "org/netbeans/modules/debugger/jpda/resources/completion_package.gif";
    private static final String ICON_CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
    private static final String ICON_INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png";
    private static final String ICON_ENUM = "org/netbeans/modules/editor/resources/completion/enum.png";
    private static final String ICON_ANNOTATION = "org/netbeans/modules/editor/resources/completion/annotation_type.png";
    private static final String ICON_FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png";
    private static final String ICON_FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png";
    private static final String ICON_FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png";
    private static final String ICON_FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png";
    private static final String ICON_FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
    private static final String ICON_FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
    private static final String ICON_FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
    private static final String ICON_FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
    private static final String ICON_CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png";
    private static final String ICON_CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png";
    private static final String ICON_CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png";
    private static final String ICON_CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png";
    private static final String ICON_METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
    private static final String ICON_METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
    private static final String ICON_METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
    private static final String ICON_METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
    private static final String ICON_METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
    private static final String ICON_METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
    private static final String ICON_METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
    private static final String ICON_METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
    private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
    private static final String BOLD = "<b>";
    private static final String BOLD_END = "</b>";
    private String htmlName;
    private String rightHtmlName;
    private String elementName;
    private ElementKind elementKind;
    private Set<Modifier> modifiers;
    private ExecutableElement executableElement;
    private String prefix;
    private int caretOffset;
    private ImageIcon icon;

    public ElementCompletionItem(String elementName, ElementKind elementKind, int caretOffset) {
        this(elementName, elementKind, null, caretOffset);
    }

    public ElementCompletionItem(String elementName, ElementKind elementKind, Set<Modifier> modifiers, int caretOffset) {
        String color;
        this.elementName = elementName;
        this.elementKind = elementKind;
        this.modifiers = modifiers;
        this.caretOffset = caretOffset;
        switch (elementKind) {
            case PACKAGE: {
                color = "#005600";
                break;
            }
            case ANNOTATION_TYPE: 
            case ENUM: 
            case CLASS: {
                color = "#560000";
                break;
            }
            case INTERFACE: {
                color = "#404040";
                break;
            }
            case FIELD: {
                color = "#008618";
                break;
            }
            case CONSTRUCTOR: {
                color = "#b28b00";
                break;
            }
            case METHOD: {
                color = "#000000";
                break;
            }
            default: {
                color = null;
            }
        }
        this.htmlName = color != null ? "<font color=" + color + ">" + ElementCompletionItem.escape(elementName) + "</font>" : elementName;
    }

    void setInsertPrefix(String prefix) {
        this.prefix = prefix;
    }

    void setExecutableElement(ExecutableElement executableElement) {
        this.executableElement = executableElement;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(BOLD);
        nameBuilder.append(this.htmlName);
        nameBuilder.append(BOLD_END);
        nameBuilder.append('(');
        List<? extends VariableElement> parameters = executableElement.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                nameBuilder.append(", ");
            }
            nameBuilder.append(ElementCompletionItem.escape(ElementCompletionItem.getTypeSimpleName(parameters.get(i).asType())));
            nameBuilder.append(' ');
            nameBuilder.append(PARAMETER_NAME_COLOR);
            nameBuilder.append(parameters.get(i).getSimpleName());
            nameBuilder.append("</font>");
        }
        nameBuilder.append(')');
        this.htmlName = nameBuilder.toString();
        TypeMirror returnType = executableElement.getReturnType();
        this.rightHtmlName = ElementCompletionItem.getTypeSimpleName(returnType);
    }

    void setElementType(TypeMirror tm) {
        this.rightHtmlName = ElementCompletionItem.getTypeSimpleName(tm);
    }

    private static String getTypeSimpleName(TypeMirror tm) {
        String name = ((Object)tm).toString();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    private ImageIcon getIcon() {
        if (this.icon == null) {
            String iconPath;
            switch (this.elementKind) {
                case PACKAGE: {
                    iconPath = ICON_PACKAGE;
                    break;
                }
                case CLASS: {
                    iconPath = ICON_CLASS;
                    break;
                }
                case INTERFACE: {
                    iconPath = ICON_INTERFACE;
                    break;
                }
                case ENUM: {
                    iconPath = ICON_ENUM;
                    break;
                }
                case ANNOTATION_TYPE: {
                    iconPath = ICON_ANNOTATION;
                    break;
                }
                case FIELD: {
                    if (this.modifiers != null) {
                        if (this.modifiers.contains((Object)Modifier.STATIC)) {
                            if (this.modifiers.contains((Object)Modifier.PRIVATE)) {
                                iconPath = ICON_FIELD_ST_PRIVATE;
                                break;
                            }
                            if (this.modifiers.contains((Object)Modifier.PROTECTED)) {
                                iconPath = ICON_FIELD_ST_PROTECTED;
                                break;
                            }
                            if (this.modifiers.contains((Object)Modifier.PUBLIC)) {
                                iconPath = ICON_FIELD_ST_PUBLIC;
                                break;
                            }
                            iconPath = ICON_FIELD_ST_PACKAGE;
                            break;
                        }
                        if (this.modifiers.contains((Object)Modifier.PRIVATE)) {
                            iconPath = ICON_FIELD_PRIVATE;
                            break;
                        }
                        if (this.modifiers.contains((Object)Modifier.PROTECTED)) {
                            iconPath = ICON_FIELD_PROTECTED;
                            break;
                        }
                        if (this.modifiers.contains((Object)Modifier.PUBLIC)) {
                            iconPath = ICON_FIELD_PUBLIC;
                            break;
                        }
                        iconPath = ICON_FIELD_PACKAGE;
                        break;
                    }
                    iconPath = ICON_FIELD_PACKAGE;
                    break;
                }
                case CONSTRUCTOR: {
                    iconPath = this.modifiers.contains((Object)Modifier.PRIVATE) ? ICON_CONSTRUCTOR_PRIVATE : (this.modifiers.contains((Object)Modifier.PROTECTED) ? ICON_CONSTRUCTOR_PROTECTED : (this.modifiers.contains((Object)Modifier.PUBLIC) ? ICON_CONSTRUCTOR_PUBLIC : ICON_CONSTRUCTOR_PACKAGE));
                }
                case METHOD: {
                    if (this.modifiers != null) {
                        if (this.modifiers.contains((Object)Modifier.STATIC)) {
                            if (this.modifiers.contains((Object)Modifier.PRIVATE)) {
                                iconPath = ICON_METHOD_ST_PRIVATE;
                                break;
                            }
                            if (this.modifiers.contains((Object)Modifier.PROTECTED)) {
                                iconPath = ICON_METHOD_ST_PROTECTED;
                                break;
                            }
                            if (this.modifiers.contains((Object)Modifier.PUBLIC)) {
                                iconPath = ICON_METHOD_ST_PUBLIC;
                                break;
                            }
                            iconPath = ICON_METHOD_ST_PACKAGE;
                            break;
                        }
                        if (this.modifiers.contains((Object)Modifier.PRIVATE)) {
                            iconPath = ICON_METHOD_PRIVATE;
                            break;
                        }
                        if (this.modifiers.contains((Object)Modifier.PROTECTED)) {
                            iconPath = ICON_METHOD_PROTECTED;
                            break;
                        }
                        if (this.modifiers.contains((Object)Modifier.PUBLIC)) {
                            iconPath = ICON_METHOD_PUBLIC;
                            break;
                        }
                        iconPath = ICON_METHOD_PACKAGE;
                        break;
                    }
                    iconPath = ICON_METHOD_PACKAGE;
                    break;
                }
                default: {
                    iconPath = null;
                }
            }
            if (iconPath != null) {
                this.icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
            }
        }
        return this.icon;
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public void defaultAction(JTextComponent component) {
        Document doc = component.getDocument();
        try {
            String text = doc.getText(0, this.caretOffset);
            int dot = text.lastIndexOf(46);
            dot = dot < 0 ? 0 : ++dot;
            doc.remove(dot, this.caretOffset - dot);
            this.caretOffset = dot;
            String insertStr = (this.prefix != null ? this.prefix : "") + this.elementName;
            doc.insertString(this.caretOffset, insertStr, null);
            if (this.elementKind == ElementKind.PACKAGE) {
                doc.insertString(this.caretOffset + insertStr.length(), ".", null);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.elementKind != ElementKind.PACKAGE) {
            Completion.get().hideAll();
        }
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.htmlName, (String)this.rightHtmlName, (Graphics)g, (Font)font);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.htmlName, (String)this.rightHtmlName, (Graphics)g, (Font)defaultFont, (Color)Color.black, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return 0;
    }

    public CharSequence getSortText() {
        return this.elementName;
    }

    public CharSequence getInsertPrefix() {
        return this.elementName;
    }
}

