/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.completion;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.debugger.jpda.ui.completion.ClassSearchScopeType;
import org.netbeans.modules.debugger.jpda.ui.completion.ElementCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Exceptions;

public class ClassCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                String text;
                if (caretOffset < 0) {
                    caretOffset = 0;
                }
                try {
                    text = doc.getText(0, caretOffset);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    text = "";
                }
                Set<ClassSearchScopeType> scope = Collections.singleton(new ClassSearchScopeType(text));
                int n = text.length();
                ClasspathInfo cpi = ClassCompletionProvider.getClassPathInfo();
                ClassIndex classIndex = cpi.getClassIndex();
                Set packageNames = classIndex.getPackageNames(text, false, scope);
                HashSet<String> resultPackages = new HashSet<String>();
                int lastTextDot = text.lastIndexOf(46);
                for (String pn : packageNames) {
                    int dot = pn.indexOf(46, n);
                    if (dot > 0) {
                        pn = pn.substring(0, dot);
                    }
                    if (lastTextDot > 0) {
                        pn = pn.substring(lastTextDot + 1);
                    }
                    if (resultPackages.contains(pn)) continue;
                    resultSet.addItem((CompletionItem)new ElementCompletionItem(pn, ElementKind.PACKAGE, caretOffset));
                    resultPackages.add(pn);
                }
                String classFilter = lastTextDot > 0 ? text.substring(lastTextDot + 1) : text;
                Set declaredTypes = classIndex.getDeclaredTypes(classFilter, ClassIndex.NameKind.PREFIX, scope);
                HashSet<String> resultClasses = new HashSet<String>();
                for (ElementHandle type : declaredTypes) {
                    int dot;
                    String className = type.getQualifiedName();
                    int packageDotIndex = -1;
                    if (lastTextDot > 0) {
                        if (!(className = className.substring(lastTextDot + 1)).startsWith(classFilter)) {
                            continue;
                        }
                    } else {
                        packageDotIndex = type.getBinaryName().lastIndexOf(46);
                        if (packageDotIndex > 0) {
                            className = className.substring(packageDotIndex + 1);
                        }
                    }
                    if ((dot = className.indexOf(46)) > 0) {
                        className = className.substring(0, dot);
                    }
                    if (resultClasses.contains(className)) continue;
                    ElementCompletionItem eci = new ElementCompletionItem(className, type.getKind(), caretOffset);
                    if (packageDotIndex > 0 && lastTextDot < 0) {
                        eci.setInsertPrefix(type.getQualifiedName().substring(0, packageDotIndex + 1));
                    }
                    resultSet.addItem((CompletionItem)eci);
                    resultClasses.add(className);
                }
                resultSet.finish();
            }
        }, component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 1;
    }

    static ClasspathInfo getClassPathInfo() {
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Set bootPaths = GlobalPathRegistry.getDefault().getPaths("classpath/boot");
        Set classPaths = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])classPaths.toArray(new ClassPath[0]));
        return ClasspathInfo.create((ClassPath)ClassPathSupport.createProxyClassPath((ClassPath[])bootPaths.toArray(new ClassPath[0])), (ClassPath)cp, (ClassPath)cp);
    }
}

