/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmClassifierBasedTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmExpressionBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModule;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProgram;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariadicSpecializationParameter;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;

public class CsmKindUtilities {
    private CsmKindUtilities() {
    }

    public static boolean isProject(Object obj) {
        return obj instanceof CsmProject;
    }

    public static boolean isCsmObject(Object obj) {
        return obj instanceof CsmObject;
    }

    public static boolean isValidable(CsmObject obj) {
        return obj instanceof CsmValidable;
    }

    public static boolean isQualified(CsmObject obj) {
        return obj instanceof CsmQualifiedNamedElement;
    }

    public static boolean isDeclaration(CsmObject obj) {
        return obj instanceof CsmDeclaration;
    }

    public static boolean isBuiltIn(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            return ((CsmDeclaration)obj).getKind() == CsmDeclaration.Kind.BUILT_IN;
        }
        return false;
    }

    public static boolean isInstantiation(CsmObject obj) {
        return obj instanceof CsmInstantiation;
    }

    public static boolean isSpecialization(CsmObject obj) {
        return obj instanceof CsmTemplate && ((CsmTemplate)obj).isSpecialization();
    }

    public static boolean isTemplateInstantiation(CsmObject obj) {
        return obj instanceof CsmInstantiation;
    }

    public static boolean isTemplateParameterType(CsmObject obj) {
        return obj instanceof CsmTemplateParameterType;
    }

    public static boolean isTemplate(CsmObject obj) {
        return obj instanceof CsmTemplate && ((CsmTemplate)obj).isTemplate();
    }

    public static boolean isTemplateParameter(CsmObject obj) {
        return obj instanceof CsmTemplateParameter;
    }

    public static boolean isClassifierBasedTemplateParameter(CsmObject obj) {
        return obj instanceof CsmClassifierBasedTemplateParameter;
    }

    public static boolean isSpecalizationParameter(CsmObject obj) {
        return obj instanceof CsmSpecializationParameter;
    }

    public static boolean isTypeBasedSpecalizationParameter(CsmObject obj) {
        return obj instanceof CsmTypeBasedSpecializationParameter;
    }

    public static boolean isExpressionBasedSpecalizationParameter(CsmObject obj) {
        return obj instanceof CsmExpressionBasedSpecializationParameter;
    }

    public static boolean isVariadicSpecalizationParameter(CsmObject obj) {
        return obj instanceof CsmVariadicSpecializationParameter;
    }

    public static boolean isFunctionExplicitInstantiation(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            return ((CsmDeclaration)obj).getKind() == CsmDeclaration.Kind.FUNCTION_INSTANTIATION;
        }
        return false;
    }

    public static boolean isFunctionPointerType(CsmObject obj) {
        return obj instanceof CsmFunctionPointerType;
    }

    public static boolean isType(CsmObject obj) {
        return obj instanceof CsmType;
    }

    public static boolean isTypedef(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            return ((CsmDeclaration)obj).getKind() == CsmDeclaration.Kind.TYPEDEF;
        }
        return false;
    }

    public static boolean isStatement(CsmObject obj) {
        return obj instanceof CsmStatement;
    }

    public static boolean isDeclarationStatement(CsmObject obj) {
        return obj instanceof CsmDeclarationStatement;
    }

    public static boolean isCompoundStatement(CsmObject obj) {
        if (CsmKindUtilities.isStatement(obj)) {
            return ((CsmStatement)obj).getKind() == CsmStatement.Kind.COMPOUND;
        }
        return false;
    }

    public static boolean isTryCatchStatement(CsmObject obj) {
        if (CsmKindUtilities.isStatement(obj)) {
            return ((CsmStatement)obj).getKind() == CsmStatement.Kind.TRY_CATCH;
        }
        return false;
    }

    public static boolean isGotoStatement(CsmObject obj) {
        return obj instanceof CsmGotoStatement;
    }

    public static boolean isLabel(CsmObject obj) {
        return obj instanceof CsmLabel;
    }

    public static boolean isOffsetable(Object obj) {
        return obj instanceof CsmOffsetable;
    }

    public static boolean isOffsetableDeclaration(Object obj) {
        return obj instanceof CsmOffsetableDeclaration;
    }

    public static boolean isNamedElement(CsmObject obj) {
        return obj instanceof CsmNamedElement;
    }

    public static boolean isNamedElement(Object obj) {
        return obj instanceof CsmNamedElement;
    }

    public static boolean isEnum(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.ENUM;
        }
        return false;
    }

    public static boolean isEnumerator(Object obj) {
        return obj instanceof CsmEnumerator;
    }

    public static boolean isClassifier(CsmObject obj) {
        return obj instanceof CsmClassifier;
    }

    public static boolean isCompoundClassifier(CsmObject obj) {
        return obj instanceof CsmCompoundClassifier;
    }

    public static boolean isClass(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.CLASS || kind == CsmDeclaration.Kind.STRUCT || kind == CsmDeclaration.Kind.UNION;
        }
        return false;
    }

    public static boolean isUnion(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.UNION;
        }
        return false;
    }

    public static boolean isClassForwardDeclaration(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION;
        }
        return false;
    }

    public static boolean isEnumForwardDeclaration(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION;
        }
        return false;
    }

    public static boolean isScope(CsmObject obj) {
        return obj instanceof CsmScope;
    }

    public static boolean isScopeElement(CsmObject obj) {
        return obj instanceof CsmScopeElement;
    }

    public static boolean isFunction(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION || kind == CsmDeclaration.Kind.FUNCTION_DEFINITION || kind == CsmDeclaration.Kind.FUNCTION_LAMBDA || kind == CsmDeclaration.Kind.FUNCTION_FRIEND || kind == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION;
        }
        return false;
    }

    public static boolean isLambda(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION_LAMBDA;
        }
        return false;
    }

    public static boolean isParameter(CsmObject obj) {
        return obj instanceof CsmParameter;
    }

    public static boolean isOperator(CsmObject obj) {
        if (CsmKindUtilities.isFunction(obj)) {
            return ((CsmFunction)obj).isOperator();
        }
        return false;
    }

    public static boolean isFunctionDeclaration(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION || kind == CsmDeclaration.Kind.FUNCTION_FRIEND;
        }
        return false;
    }

    public static boolean isFunctionDefinition(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.FUNCTION_DEFINITION || kind == CsmDeclaration.Kind.FUNCTION_LAMBDA || kind == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION;
        }
        return false;
    }

    public static boolean isFile(CsmObject obj) {
        return obj instanceof CsmFile;
    }

    public static boolean isInheritance(CsmObject obj) {
        return obj instanceof CsmInheritance;
    }

    public static boolean isNamespace(Object obj) {
        return obj instanceof CsmNamespace;
    }

    public static boolean isNamespaceDefinition(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION;
        }
        return false;
    }

    public static boolean isClassMember(CsmObject obj) {
        if (obj instanceof CsmMember) {
            if (CsmKindUtilities.isClass(obj)) {
                return CsmKindUtilities.isClass(((CsmClass)obj).getScope());
            }
            return true;
        }
        return false;
    }

    public static boolean isVariable(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE || kind == CsmDeclaration.Kind.VARIABLE_DEFINITION;
        }
        return false;
    }

    public static boolean isVariableDeclaration(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE;
        }
        return false;
    }

    public static boolean isVariableDefinition(CsmObject obj) {
        if (CsmKindUtilities.isDeclaration(obj)) {
            CsmDeclaration.Kind kind = ((CsmDeclaration)obj).getKind();
            return kind == CsmDeclaration.Kind.VARIABLE_DEFINITION;
        }
        return false;
    }

    public static boolean isLocalVariable(CsmObject obj) {
        if (CsmKindUtilities.isVariable(obj)) {
            if (CsmKindUtilities.isClassMember(obj)) {
                return false;
            }
            CsmScope scope = ((CsmVariable)obj).getScope();
            return !CsmKindUtilities.isFile(scope) && !CsmKindUtilities.isNamespace(scope);
        }
        return false;
    }

    public static boolean isFileLocalVariable(CsmObject obj) {
        if (CsmKindUtilities.isVariable(obj)) {
            return CsmKindUtilities.isFile(((CsmVariable)obj).getScope());
        }
        return false;
    }

    public static boolean isFileLocalFunction(CsmObject obj) {
        if (CsmKindUtilities.isFunction(obj)) {
            return CsmKindUtilities.isFile(((CsmFunction)obj).getScope());
        }
        return false;
    }

    public static boolean isGlobalVariable(CsmObject obj) {
        if (CsmKindUtilities.isVariable(obj)) {
            return CsmKindUtilities.isNamespace(((CsmVariable)obj).getScope());
        }
        return false;
    }

    public static boolean isParamVariable(CsmObject obj) {
        if (CsmKindUtilities.isVariable(obj)) {
            assert (!(obj instanceof CsmParameter) || !CsmKindUtilities.isClassMember(obj)) : "parameter is not class member";
            return obj instanceof CsmParameter;
        }
        return false;
    }

    public static boolean isField(CsmObject obj) {
        if (CsmKindUtilities.isVariable(obj)) {
            return CsmKindUtilities.isClassMember(obj);
        }
        return false;
    }

    public static boolean isGlobalFunction(CsmObject obj) {
        if (CsmKindUtilities.isFunction(obj)) {
            return !CsmKindUtilities.isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj));
        }
        return false;
    }

    public static boolean isMethod(CsmObject obj) {
        if (CsmKindUtilities.isFunction(obj)) {
            return CsmKindUtilities.isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj));
        }
        return false;
    }

    public static boolean isMethodDeclaration(CsmObject obj) {
        if (CsmKindUtilities.isFunction(obj)) {
            return CsmKindUtilities.isClassMember(obj);
        }
        return false;
    }

    public static boolean isMethodDefinition(CsmObject obj) {
        if (CsmKindUtilities.isFunctionDefinition(obj)) {
            return CsmKindUtilities.isClassMember(CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj));
        }
        return false;
    }

    public static boolean isConstructor(CsmObject obj) {
        return obj instanceof CsmInitializerListContainer;
    }

    public static boolean isDestructor(CsmObject obj) {
        CsmFunction fun;
        if (CsmKindUtilities.isMethod(obj)) {
            CsmFunction funDecl = CsmBaseUtilities.getFunctionDeclaration((CsmFunction)obj);
            if (funDecl != null && funDecl.getName().length() > 0) {
                return funDecl.getName().charAt(0) == '~';
            }
        } else if (CsmKindUtilities.isFunctionDefinition(obj) && (fun = (CsmFunction)obj).getName().length() > 0) {
            return fun.getName().charAt(0) == '~';
        }
        return false;
    }

    public static boolean isExpression(CsmObject obj) {
        return obj instanceof CsmExpression;
    }

    public static boolean isMacro(CsmObject obj) {
        return obj instanceof CsmMacro;
    }

    public static boolean isInclude(CsmObject obj) {
        return obj instanceof CsmInclude;
    }

    public static boolean isUsing(CsmObject obj) {
        return obj instanceof CsmUsingDeclaration || obj instanceof CsmUsingDirective;
    }

    public static boolean isNamespaceAlias(CsmObject obj) {
        return obj instanceof CsmNamespaceAlias;
    }

    public static boolean isUsingDirective(CsmObject obj) {
        return obj instanceof CsmUsingDirective;
    }

    public static boolean isUsingDeclaration(CsmObject obj) {
        return obj instanceof CsmUsingDeclaration;
    }

    public static boolean isFriend(CsmObject obj) {
        return obj instanceof CsmFriend;
    }

    public static boolean isFriendClass(CsmObject obj) {
        return obj instanceof CsmFriendClass;
    }

    public static boolean isFriendMethod(CsmObject obj) {
        return obj instanceof CsmFriendFunction;
    }

    public static boolean isExternVariable(CsmDeclaration decl) {
        if (CsmKindUtilities.isVariable(decl)) {
            return ((CsmVariable)decl).isExtern();
        }
        return false;
    }

    public static boolean isProgram(CsmObject obj) {
        return obj instanceof CsmProgram;
    }

    public static boolean isModule(CsmObject obj) {
        return obj instanceof CsmModule;
    }
}

