/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.UIManager;
import org.netbeans.modules.gsf.testrunner.api.OutputLine;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TestsuiteNode
extends AbstractNode {
    private static final int MAX_TOOLTIP_LINES = Integer.getInteger("testrunner.max.tooltip.lines", 4);
    private static final int MAX_TOOLTIP_LINE_LENGTH = Integer.getInteger("testrunner.max.tooltip.line.length", 80);
    static final boolean DISPLAY_TOOLTIPS = Boolean.valueOf(System.getProperty("testrunner.display.tooltips", "true"));
    static final int MAX_MSG_LINE_LENGTH = Integer.getInteger("testrunner.max.msg.line.length", TestsuiteNode.isGTK() ? 120 : Integer.MAX_VALUE);
    protected String suiteName;
    protected TestSuite suite;
    protected Report report;
    protected int filterMask = 0;

    public TestsuiteNode(String suiteName, boolean filtered) {
        this(null, suiteName, filtered, null);
    }

    public TestsuiteNode(Report report, boolean filtered) {
        this(report, null, filtered, null);
    }

    protected TestsuiteNode(Report report, String suiteName, boolean filtered, Lookup lookup) {
        super((Children)(report != null ? new TestsuiteNodeChildren(report, 0) : Children.LEAF), lookup);
        this.report = report;
        String string = this.suiteName = report != null ? report.getSuiteClassName() : suiteName;
        assert (this.suiteName != null);
        this.setDisplayName();
    }

    static String toTooltipText(List<OutputLine> lines) {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        if (lines.isEmpty()) {
            result.append("<i>" + NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_NoOutput") + "</i>");
        } else {
            for (int i = 0; i < lines.size(); ++i) {
                if (i >= MAX_TOOLTIP_LINES) {
                    result.append("<br><i>" + NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_MoreOutput", (Object)(lines.size() - i)) + "</i>");
                    break;
                }
                String line = lines.get(i).getLine();
                line = TestsuiteNode.cutLine(line, MAX_TOOLTIP_LINE_LENGTH, true);
                result.append(line);
                if (i >= lines.size()) continue;
                result.append("<br>");
            }
        }
        result.append("</html>");
        return result.toString();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Image getIcon(int type) {
        if (this.report != null) {
            Status status = this.report.getStatus();
            if (!this.report.completed) {
                switch (status) {
                    case FAILED: 
                    case ERROR: {
                        return ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/run.gif"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error-badge.gif"), (int)8, (int)8);
                    }
                }
            } else {
                switch (status) {
                    case PASSED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_16.png");
                    }
                    case PASSEDWITHERRORS: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_withErrors_16.png");
                    }
                    case FAILED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning_16.png");
                    }
                    case ERROR: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error_16.png");
                    }
                    case SKIPPED: {
                        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/skipped_16.png");
                    }
                }
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning2_16.png");
            }
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/run.gif");
    }

    public void displayReport(Report report) {
        assert (report != null);
        assert (report.getSuiteClassName().equals(this.suiteName) || this.suiteName == TestSuite.ANONYMOUS_SUITE);
        this.report = report;
        this.suiteName = report.getSuiteClassName();
        this.setDisplayName();
        Children ch = this.getChildren();
        if (ch instanceof TestsuiteNodeChildren) {
            ((TestsuiteNodeChildren)ch).addNotify();
        } else {
            this.setChildren((Children)new TestsuiteNodeChildren(report, this.filterMask));
        }
        if (DISPLAY_TOOLTIPS) {
            this.setShortDescription(TestsuiteNode.toTooltipText(this.getOutput()));
        }
        this.fireIconChange();
    }

    public Report getReport() {
        return this.report;
    }

    private void setDisplayName() {
        String displayName;
        if (this.report == null) {
            displayName = this.suiteName != TestSuite.ANONYMOUS_SUITE ? NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunning", (Object)this.suiteName) : NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunningNoname");
        } else if (this.report.isAborted()) {
            displayName = NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteAborted", (Object)this.suiteName);
        } else if (this.report.getSkipped() > 0) {
            displayName = NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteSkipped", (Object)this.suiteName);
        } else if (!this.report.completed) {
            boolean containsFailed = this.containsFailed();
            displayName = containsFailed ? NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteFailed", (Object)this.suiteName) : this.suiteName;
            displayName = NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunning", (Object)displayName);
        } else {
            boolean containsFailed = this.containsFailed();
            displayName = containsFailed ? NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteFailed", (Object)this.suiteName) : this.suiteName;
        }
        this.setDisplayName(displayName);
    }

    public String getHtmlDisplayName() {
        assert (this.suiteName != null);
        StringBuffer buf = new StringBuffer(60);
        if (this.suiteName != TestSuite.ANONYMOUS_SUITE) {
            buf.append(this.suiteName);
        } else {
            buf.append(NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteNoname"));
        }
        if (this.report != null) {
            Status status = this.report.getStatus();
            buf.append("&nbsp;&nbsp;");
            buf.append("<font color='#");
            buf.append(status.getHtmlDisplayColor() + "'>");
            buf.append(TestsuiteNode.suiteStatusToMsg(status, true));
            buf.append("</font>");
        }
        if (this.report == null || !this.report.completed) {
            buf.append("&nbsp;&nbsp;");
            buf.append(NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_TestsuiteRunning_HTML"));
        }
        return buf.toString();
    }

    static String suiteStatusToMsg(Status status, boolean html) {
        String result = null;
        result = Status.ABORTED == status ? "MSG_TestsuiteAborted" : (Status.ERROR == status || Status.FAILED == status ? "MSG_TestsuiteFailed" : (Status.PENDING == status ? "MSG_TestsuitePending" : (Status.SKIPPED == status ? "MSG_TestsuiteSkipped" : (Status.PASSEDWITHERRORS == status ? "MSG_TestsuitePassedWithErrors" : "MSG_TestsuitePassed"))));
        result = html ? result + "_HTML" : result;
        return NbBundle.getMessage(TestsuiteNode.class, (String)result);
    }

    void setSuite(TestSuite suite) {
        this.suite = suite;
    }

    public TestSuite getSuite() {
        return this.suite;
    }

    void setFilterMask(int filterMask) {
        if (filterMask == this.filterMask) {
            return;
        }
        this.filterMask = filterMask;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((TestsuiteNodeChildren)children).setFilterMask(filterMask);
        }
    }

    private boolean containsFailed() {
        return this.report != null && this.report.getFailures() + this.report.getErrors() != 0;
    }

    public Action getPreferredAction() {
        return null;
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    private List<OutputLine> getOutput() {
        ArrayList<OutputLine> result = new ArrayList<OutputLine>();
        for (Testcase testcase : this.report.getTests()) {
            result.addAll(testcase.getOutput());
        }
        return result;
    }

    public static String cutLine(String line, int maxLength, boolean isHTML) throws MissingResourceException {
        String cutMsg;
        int tailLength;
        int length = line.length();
        if (length > maxLength && (tailLength = length - maxLength) > (cutMsg = NbBundle.getMessage(TestsuiteNode.class, (String)"MSG_CharsOmitted", (Object)tailLength)).length()) {
            line = line.substring(0, maxLength);
            String startMsg = isHTML ? "<i> " : "";
            String endMsg = isHTML ? "</i>" : "";
            line = line.concat(startMsg + cutMsg + endMsg);
        }
        return line;
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }
}

