/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.util.Arrays;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Mutex;
import org.openide.util.lookup.Lookups;

public abstract class TestMethodRunnerProvider {
    private final String command = "run.single.method";

    public abstract boolean canHandle(Node var1);

    public abstract SingleMethod getTestMethod(Document var1, int var2);

    public final void runTestMethod(Node activatedNode) {
        int caret;
        Document doc;
        final Node activeNode = activatedNode;
        EditorCookie ec = (EditorCookie)activeNode.getLookup().lookup(EditorCookie.class);
        if (ec != null) {
            JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
            if (pane != null) {
                doc = pane.getDocument();
                caret = pane.getCaret().getDot();
            } else {
                doc = null;
                caret = -1;
            }
        } else {
            doc = null;
            caret = -1;
        }
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                ActionProvider ap;
                SingleMethod sm = (SingleMethod)activeNode.getLookup().lookup(SingleMethod.class);
                if (sm == null) {
                    sm = TestMethodRunnerProvider.this.getTestMethod(doc, caret);
                }
                if (sm != null && (ap = TestMethodRunnerProvider.getActionProvider(sm.getFile())) != null && Arrays.asList(ap.getSupportedActions()).contains("run.single.method") && ap.isActionEnabled("run.single.method", Lookups.singleton((Object)sm))) {
                    ap.invokeAction("run.single.method", Lookups.singleton((Object)sm));
                }
            }
        });
    }

    static ActionProvider getActionProvider(FileObject fileObject) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (owner == null) {
            return null;
        }
        return (ActionProvider)owner.getLookup().lookup(ActionProvider.class);
    }
}

