/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.api.ResultPanelTree;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.openide.awt.ToolbarWithOverflow;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class StatisticsPanel
extends JPanel {
    private final ResultPanelTree treePanel;
    private JToggleButton btnShowPassed;
    private JToggleButton btnShowFailed;
    private JToggleButton btnShowError;
    private JToggleButton btnShowPassedWithErrors;
    private JToggleButton btnShowIgnored;
    private JToggleButton btnShowSkipped;
    private JButton rerunButton;
    private JButton rerunFailedButton;
    private JButton nextFailure;
    private JButton previousFailure;
    private final ResultDisplayHandler displayHandler;
    private static final String KEY_FILTER_MASK = "filterMask";
    private int filterMask = NbPreferences.forModule(StatisticsPanel.class).getInt("filterMask", Status.PASSED.getBitMask());
    private static final Icon rerunIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/rerun.png", (boolean)true);
    private static final Icon rerunFailedIcon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/rerun.png"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error-badge.gif"), (int)8, (int)8));
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");

    public StatisticsPanel(ResultDisplayHandler displayHandler) {
        super(new BorderLayout(0, 0));
        this.displayHandler = displayHandler;
        JComponent toolbar = this.createToolbar();
        this.treePanel = new ResultPanelTree(displayHandler, this);
        this.treePanel.setFilterMask(this.filterMask);
        this.add((Component)toolbar, "West");
        this.add((Component)this.treePanel, "Center");
        if (isMacLaf) {
            toolbar.setBackground(macBackground);
            this.treePanel.setBackground(macBackground);
        }
    }

    public ResultPanelTree getTreePanel() {
        return this.treePanel;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treePanel.requestFocusInWindow();
    }

    private JComponent createToolbar() {
        this.createShowButtons();
        this.createRerunButtons();
        this.createNextPrevFailureButtons();
        String testingFramework = Manager.getInstance().getTestingFramework();
        ToolbarWithOverflow toolbar = new ToolbarWithOverflow(1);
        toolbar.add(this.rerunButton);
        toolbar.add(this.rerunFailedButton);
        toolbar.add(new JToolBar.Separator());
        toolbar.add(this.btnShowPassed);
        if (testingFramework.equals("testng")) {
            toolbar.add(this.btnShowPassedWithErrors);
        }
        toolbar.add(this.btnShowFailed);
        toolbar.add(this.btnShowError);
        if (testingFramework.equals("testng")) {
            toolbar.add(this.btnShowSkipped);
        }
        toolbar.add(new JToolBar.Separator());
        toolbar.add(this.previousFailure);
        toolbar.add(this.nextFailure);
        toolbar.setFocusable(false);
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        return toolbar;
    }

    private void createRerunButtons() {
        this.rerunButton = new JButton(rerunIcon);
        this.rerunButton.setEnabled(false);
        this.rerunButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_RerunButton"));
        this.rerunButton.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MultiviewPanel.rerunButton.tooltip"));
        this.rerunFailedButton = new JButton(rerunFailedIcon);
        this.rerunFailedButton.setEnabled(false);
        this.rerunFailedButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_RerunFailedButton"));
        this.rerunFailedButton.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MultiviewPanel.rerunFailedButton.tooltip"));
        final RerunHandler rerunHandler = this.displayHandler.getSession().getRerunHandler();
        if (rerunHandler != null) {
            this.rerunButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    rerunHandler.rerun();
                }
            });
            this.rerunFailedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    rerunHandler.rerun(StatisticsPanel.this.treePanel.getFailedTests());
                }
            });
            rerunHandler.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    StatisticsPanel.this.updateButtons();
                }
            });
            this.updateButtons();
        }
    }

    void updateButtons() {
        RerunHandler rerunHandler = this.displayHandler.getSession().getRerunHandler();
        if (rerunHandler == null) {
            return;
        }
        this.rerunButton.setEnabled(this.displayHandler.sessionFinished && rerunHandler.enabled(RerunType.ALL));
        this.rerunFailedButton.setEnabled(this.displayHandler.sessionFinished && rerunHandler.enabled(RerunType.CUSTOM) && !this.treePanel.getFailedTests().isEmpty());
    }

    private void createShowButtons() {
        this.btnShowPassed = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/ok_16.png", "StatisticsPanel.btnShowPassed", "ACSN_ShowPassedButton", Status.PASSED);
        this.btnShowPassedWithErrors = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/ok_withErrors_16.png", "StatisticsPanel.btnShowPassedWithErrors", "ACSN_ShowPassedWithErrorsButton", Status.PASSEDWITHERRORS);
        this.btnShowFailed = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/warning_16.png", "StatisticsPanel.btnShowFailed", "ACSN_ShowFailedButton", Status.FAILED);
        this.btnShowError = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/error_16.png", "StatisticsPanel.btnShowError", "ACSN_ShowErrorButton", Status.ERROR);
        this.btnShowIgnored = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/ignored_16.png", "StatisticsPanel.btnShowIgnored", "ACSN_ShowIgnoredButton", Status.IGNORED);
        this.btnShowSkipped = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/skipped_16.png", "StatisticsPanel.btnShowSkipped", "ACSN_ShowSkippedButton", Status.SKIPPED);
    }

    private JToggleButton newShowButton(String iconId, String tooltipId, String accessibleNameId, Status status) {
        JToggleButton btn = new JToggleButton(ImageUtilities.loadImageIcon((String)iconId, (boolean)true));
        btn.setToolTipText(NbBundle.getMessage(this.getClass(), (String)tooltipId));
        String acsn = NbBundle.getMessage(this.getClass(), (String)accessibleNameId);
        btn.getAccessibleContext().setAccessibleName(acsn);
        btn.setSelected((this.filterMask & status.getBitMask()) == 0);
        btn.addItemListener(new FilterItemListener(status));
        return btn;
    }

    void copyFilterMask(StatisticsPanel sp) {
        this.filterMask = sp.filterMask;
        this.updateShowButtons();
    }

    private void updateShowButtons() {
        this.btnShowPassed.setSelected((this.filterMask & Status.PASSED.getBitMask()) == 0);
        this.btnShowPassedWithErrors.setSelected((this.filterMask & Status.PASSEDWITHERRORS.getBitMask()) == 0);
        this.btnShowFailed.setSelected((this.filterMask & Status.FAILED.getBitMask()) == 0);
        this.btnShowError.setSelected((this.filterMask & Status.ERROR.getBitMask()) == 0);
        this.btnShowIgnored.setSelected((this.filterMask & Status.IGNORED.getBitMask()) == 0);
        this.btnShowSkipped.setSelected((this.filterMask & Status.SKIPPED.getBitMask()) == 0);
    }

    private void createNextPrevFailureButtons() {
        this.nextFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/nextmatch.png", (boolean)true));
        this.nextFailure.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MSG_NextFailure"));
        this.nextFailure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsPanel.this.selectNextFailure();
            }
        });
        this.previousFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/prevmatch.png", (boolean)true));
        this.previousFailure.setToolTipText(NbBundle.getMessage(StatisticsPanel.class, (String)"MSG_PreviousFailure"));
        this.previousFailure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsPanel.this.selectPreviousFailure();
            }
        });
    }

    void selectPreviousFailure() {
        this.treePanel.selectPreviousFailure();
    }

    void selectNextFailure() {
        this.treePanel.selectNextFailure();
    }

    void displayReport(Report report) {
        this.treePanel.displayReport(report);
    }

    void displayReports(List<Report> reports) {
        if (reports.isEmpty()) {
            return;
        }
        this.treePanel.displayReports(reports);
    }

    void displaySuiteRunning(String suiteName) {
        this.treePanel.displaySuiteRunning(suiteName);
    }

    void displayMsg(String msg) {
        this.treePanel.displayMsg(msg);
    }

    private class FilterItemListener
    implements ItemListener {
        private int itemMask;

        public FilterItemListener(Status status) {
            this.itemMask = status.getBitMask();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    StatisticsPanel.this.filterMask &= ~this.itemMask;
                    break;
                }
                case 2: {
                    StatisticsPanel.this.filterMask |= this.itemMask;
                    break;
                }
                default: {
                    return;
                }
            }
            StatisticsPanel.this.treePanel.setFilterMask(StatisticsPanel.this.filterMask);
            NbPreferences.forModule(StatisticsPanel.class).putInt(StatisticsPanel.KEY_FILTER_MASK, StatisticsPanel.this.filterMask);
        }
    }
}

