/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.Component;
import java.awt.EventQueue;
import javax.accessibility.AccessibleContext;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.gsf.testrunner.api.CallstackFrameNode;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class ResultTreeView
extends BeanTreeView
implements Runnable {
    private final TreeCellRenderer defaultTreeCellRenderer;
    private final TreeCellRenderer noIconTreeCellRenderer;

    ResultTreeView() {
        this.defaultTreeCellRenderer = this.tree.getCellRenderer();
        this.noIconTreeCellRenderer = this.createNoIconTreeCellRenderer();
        this.tree.setCellRenderer(new DelegatingTreeCellRenderer());
        this.tree.setDragEnabled(false);
        this.initAccessibility();
    }

    private void initAccessibility() {
        AccessibleContext accessibleContext = this.tree.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_ResultPanelTree"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ResultPanelTree"));
    }

    private TreeCellRenderer createNoIconTreeCellRenderer() {
        HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();
        renderer.setHtml(false);
        renderer.setIcon(null);
        renderer.setIconTextGap(0);
        renderer.setIndent(2);
        return renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expandReportNode(TestsuiteNode node) {
        boolean wasScrollsOnExpand = this.tree.getScrollsOnExpand();
        this.tree.setScrollsOnExpand(false);
        try {
            this.expandNode((Node)node);
        }
        finally {
            if (wasScrollsOnExpand) {
                EventQueue.invokeLater(this);
            }
        }
    }

    @Override
    public void run() {
        this.tree.setScrollsOnExpand(true);
    }

    private final class DelegatingTreeCellRenderer
    implements TreeCellRenderer {
        private DelegatingTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean isResultRootNode = value instanceof TreeNode && ((TreeNode)value).getParent() == null;
            boolean isCallstackFrame = false;
            if (null != value) {
                isCallstackFrame = Visualizer.findNode((Object)value) instanceof CallstackFrameNode;
            }
            TreeCellRenderer renderer = isResultRootNode || isCallstackFrame ? ResultTreeView.this.noIconTreeCellRenderer : ResultTreeView.this.defaultTreeCellRenderer;
            return renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

