/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.Testcase;

public final class Report {
    private String suiteClassName;
    private int totalTests;
    private int passed;
    private int passedWithErrors;
    private int failures;
    private int errors;
    private int pending;
    private int skippedNum;
    private long elapsedTimeMillis;
    private int detectedPassedTests;
    private Collection<Testcase> tests;
    private LineConvertors.FileLocator fileLocator;
    private WeakReference<Project> project;
    private final URI projectURI;
    private boolean aborted;
    private boolean skipped;
    protected boolean completed;

    public Report(String suiteClassName, Project project) {
        this.suiteClassName = suiteClassName;
        this.project = new WeakReference<Project>(project);
        this.projectURI = project.getProjectDirectory().toURI();
        this.fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        this.tests = new ArrayList<Testcase>(10);
        this.completed = true;
        this.aborted = false;
        this.skipped = false;
    }

    public LineConvertors.FileLocator getFileLocator() {
        return this.fileLocator;
    }

    public Project getProject() {
        Project prj = (Project)this.project.get();
        if (prj == null) {
            prj = FileOwnerQuery.getOwner((URI)this.projectURI);
            assert (prj != null) : "Project was null for projectURI: " + this.projectURI;
            this.project = new WeakReference<Project>(prj);
        }
        return prj;
    }

    public void reportTest(Testcase test) {
        this.tests.add(test);
        if (!Status.isFailureOrError(test.getStatus()) && !Status.isSkipped(test.getStatus())) {
            ++this.detectedPassedTests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Report report) {
        Report report2 = this;
        synchronized (report2) {
            this.suiteClassName = report.suiteClassName;
            this.totalTests = report.totalTests;
            this.passed = report.passed;
            this.passedWithErrors = report.passedWithErrors;
            this.failures = report.failures;
            this.errors = report.errors;
            this.pending = report.pending;
            this.elapsedTimeMillis = report.elapsedTimeMillis;
            this.detectedPassedTests = report.detectedPassedTests;
            this.tests = report.tests;
            this.completed = report.completed;
            this.skipped = report.skipped;
            this.skippedNum = report.skippedNum;
        }
    }

    public Status getStatus() {
        if (this.aborted) {
            return Status.ABORTED;
        }
        if (this.skippedNum > 0) {
            return Status.SKIPPED;
        }
        if (this.errors > 0) {
            return Status.ERROR;
        }
        if (this.failures > 0) {
            return Status.FAILED;
        }
        if (this.pending > 0) {
            return Status.PENDING;
        }
        if (this.passedWithErrors > 0) {
            return Status.PASSEDWITHERRORS;
        }
        return Status.PASSED;
    }

    public Collection<Testcase> getTests() {
        if (this.tests.isEmpty()) {
            List<Testcase> emptyList = Collections.emptyList();
            return emptyList;
        }
        return new ArrayList<Testcase>(this.tests);
    }

    public boolean containsFailed() {
        assert (EventQueue.isDispatchThread());
        return this.failures + this.errors != 0;
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String suiteClassName) {
        this.suiteClassName = suiteClassName;
    }

    public int getTotalTests() {
        return this.totalTests;
    }

    public void setTotalTests(int totalTests) {
        this.totalTests = totalTests;
    }

    public int getPassed() {
        return this.passed;
    }

    public void setPassed(int passed) {
        this.passed = passed;
    }

    public int getPassedWithErrors() {
        return this.passedWithErrors;
    }

    public void setPassedWithErrors(int passedWithErrors) {
        this.passedWithErrors = passedWithErrors;
    }

    public int getSkipped() {
        return this.skippedNum;
    }

    public void setSkipped(int skipped) {
        this.skippedNum = skipped;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public int getPending() {
        return this.pending;
    }

    public void setPending(int pending) {
        this.pending = pending;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public void setElapsedTimeMillis(long elapsedTimeMillis) {
        this.elapsedTimeMillis = elapsedTimeMillis;
    }

    public int getDetectedPassedTests() {
        return this.detectedPassedTests;
    }

    public void setDetectedPassedTests(int detectedPassedTests) {
        this.detectedPassedTests = detectedPassedTests;
    }

    public void setTests(Collection<Testcase> tests) {
        this.tests = tests;
    }

    public void setFileLocator(LineConvertors.FileLocator fileLocator) {
        this.fileLocator = fileLocator;
    }

    public void setProject(Project project) {
        this.project = new WeakReference<Project>(project);
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    int getStatusMask() {
        int statusMask = 0;
        statusMask |= this.getPassed() > 0 ? Status.PASSED.getBitMask() : 0;
        statusMask |= this.getPassedWithErrors() > 0 ? Status.PASSEDWITHERRORS.getBitMask() : 0;
        statusMask |= this.getFailures() > 0 ? Status.FAILED.getBitMask() : 0;
        statusMask |= this.getErrors() > 0 ? Status.ERROR.getBitMask() : 0;
        return statusMask |= this.getSkipped() > 0 ? Status.SKIPPED.getBitMask() : 0;
    }
}

