/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.gsf.testrunner.ClassNameTextField;
import org.netbeans.modules.gsf.testrunner.MessageStack;
import org.netbeans.modules.gsf.testrunner.api.SelfResizingPanel;
import org.netbeans.modules.gsf.testrunner.plugin.CommonSettingsProvider;
import org.netbeans.modules.gsf.testrunner.plugin.CommonTestUtilProvider;
import org.netbeans.modules.gsf.testrunner.plugin.GuiUtilsProvider;
import org.netbeans.modules.gsf.testrunner.plugin.RootsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CommonTestsCfgOfCreate
extends SelfResizingPanel
implements ChangeListener {
    private static final String TEST_CLASS_SUFFIX = "Test";
    private Node[] nodes;
    private boolean multipleClasses;
    private boolean singlePackage;
    private boolean singleClass;
    private String testClassName;
    private List<ChangeListener> changeListeners;
    private String initialMessage;
    private List<String> testingFrameworks;
    private String selectedTestingFramework = null;
    private boolean hasTargetFolders = false;
    private boolean classNameValid;
    private boolean isAcceptable;
    private static final int MSG_TYPE_NO_TARGET_FOLDERS = 0;
    private static final int MSG_TYPE_CLASSNAME_INVALID = 1;
    private static final int MSG_TYPE_CLASSNAME_NOT_DEFAULT = 2;
    private static final int MSG_TYPE_MODIFIED_FILES = 3;
    private MessageStack msgStack = new MessageStack(4);
    public ResourceBundle bundle;
    private JLabel lblClassToTestValue;
    private ClassNameTextField tfClassName;
    private JTextComponent txtAreaMessage;
    private JComboBox cboxLocation;
    private JComboBox cboxFramework;
    private JCheckBox chkAbstractImpl;
    private JCheckBox chkComments;
    private JCheckBox chkContent;
    private JCheckBox chkExceptions;
    private JCheckBox chkGenerateSuites;
    private JCheckBox chkJavaDoc;
    private JCheckBox chkPackage;
    private JCheckBox chkPackagePrivateClasses;
    private JCheckBox chkProtected;
    private JCheckBox chkPublic;
    private JCheckBox chkSetUp;
    private JCheckBox chkTearDown;
    private JCheckBox chkBeforeClass;
    private JCheckBox chkAfterClass;

    public CommonTestsCfgOfCreate(Node[] nodes) {
        assert (nodes != null && nodes.length != 0);
        this.nodes = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCfgPanel(boolean isShowMsgFilesWillBeSaved) {
        this.multipleClasses = this.checkMultipleClasses();
        this.initBundle();
        try {
            this.initComponents();
            if (isShowMsgFilesWillBeSaved) {
                String msg = this.bundle.getString("MSG_MODIFIED_FILES");
                this.setMessage(msg, 3);
            }
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
            this.addAccessibleDescriptions();
            this.initializeCheckBoxStates();
            this.fillFormData();
            this.checkAcceptability();
            this.setupUserInteraction();
        }
        finally {
            this.unlinkBundle();
        }
    }

    private void addAccessibleDescriptions() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.AD"));
        if (this.tfClassName != null) {
            this.tfClassName.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.clsName.toolTip"));
            this.tfClassName.getAccessibleContext().setAccessibleName(this.bundle.getString("CommonTestsCfgOfCreate.clsName.AN"));
            this.tfClassName.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.clsName.AD"));
        }
        this.cboxLocation.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.location.toolTip"));
        this.cboxLocation.getAccessibleContext().setAccessibleName(this.bundle.getString("CommonTestsCfgOfCreate.location.AN"));
        this.cboxLocation.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.location.AD"));
        this.cboxLocation.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.framework.toolTip"));
        this.cboxLocation.getAccessibleContext().setAccessibleName(this.bundle.getString("CommonTestsCfgOfCreate.framework.AN"));
        this.cboxLocation.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.framework.AD"));
        this.chkPublic.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkPublic.toolTip"));
        this.chkPublic.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkPublic.AD"));
        this.chkProtected.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkProtected.toolTip"));
        this.chkProtected.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkProtected.AD"));
        this.chkPackage.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkPackage.toolTip"));
        this.chkPackage.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkPackage.AD"));
        this.chkComments.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkComments.toolTip"));
        this.chkComments.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkComments.AD"));
        this.chkContent.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkContent.toolTip"));
        this.chkContent.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkContent.AD"));
        this.chkJavaDoc.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkJavaDoc.toolTip"));
        this.chkJavaDoc.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkJavaDoc.AD"));
        if (this.multipleClasses) {
            this.chkExceptions.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkExceptions.toolTip"));
            this.chkExceptions.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkExceptions.AD"));
            this.chkAbstractImpl.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkAbstractImpl.toolTip"));
            this.chkAbstractImpl.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkAbstractImpl.AD"));
            this.chkPackagePrivateClasses.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkPackagePrivateClasses.toolTip"));
            this.chkPackagePrivateClasses.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkPackagePrivateClasses.AD"));
            this.chkGenerateSuites.setToolTipText(this.bundle.getString("CommonTestsCfgOfCreate.chkGenerateSuites.toolTip"));
            this.chkGenerateSuites.getAccessibleContext().setAccessibleDescription(this.bundle.getString("CommonTestsCfgOfCreate.chkGenerateSuites.AD"));
        }
    }

    private boolean checkMultipleClasses() {
        if (this.nodes.length > 1) {
            return true;
        }
        Lookup nodeLookup = this.nodes[0].getLookup();
        if (nodeLookup.lookup(DataObject.Container.class) != null) {
            this.singlePackage = nodeLookup.lookup(DataFolder.class) != null;
            return true;
        }
        this.singleClass = false;
        DataObject dataObj = (DataObject)nodeLookup.lookup(DataObject.class);
        if (dataObj == null) {
            return true;
        }
        this.singleClass = dataObj.getPrimaryFile().isData();
        return !this.singleClass;
    }

    public boolean configure() {
        String title = "";
        String btnTxt = "";
        String btnAN = "";
        String btnAD = "";
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator i$ = providers.iterator();
        if (i$.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)i$.next();
            title = provider.getMessageFor("CommonTestsCfgOfCreate.Title");
            btnTxt = provider.getMessageFor("LBL_OK");
            btnAN = provider.getMessageFor("AN_OK");
            btnAD = provider.getMessageFor("AD_OK");
        }
        final JButton btnOK = new JButton(btnTxt);
        btnOK.getAccessibleContext().setAccessibleName(btnAN);
        btnOK.getAccessibleContext().setAccessibleDescription(btnAD);
        btnOK.setEnabled(this.isAcceptable());
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                btnOK.setEnabled(CommonTestsCfgOfCreate.this.isAcceptable());
            }
        };
        this.addChangeListener(changeListener);
        Object returned = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)this, title, true, new Object[]{btnOK, DialogDescriptor.CANCEL_OPTION}, (Object)btnOK, 0, new HelpCtx(CommonTestsCfgOfCreate.class), (ActionListener)null));
        this.removeChangeListener(changeListener);
        if (returned == btnOK) {
            this.rememberCheckBoxStates();
            this.testClassName = this.tfClassName != null ? this.tfClassName.getText() : null;
            return true;
        }
        return false;
    }

    public boolean isSingleClass() {
        return this.singleClass;
    }

    public boolean isSinglePackage() {
        return this.singlePackage;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    private void initializeCheckBoxStates() {
        boolean chkPublicB = true;
        boolean chkProtectedB = true;
        boolean chkPackageB = true;
        boolean chkCommentsB = true;
        boolean chkContentB = true;
        boolean chkJavaDocB = true;
        boolean chkGenerateSuitesB = true;
        boolean chkPackagePrivateClassesB = true;
        boolean chkAbstractImplB = true;
        boolean chkExceptionsB = true;
        boolean chkSetUpB = true;
        boolean chkTearDownB = true;
        boolean chkBeforeClassB = true;
        boolean chkAfterClassB = true;
        Collection providers = Lookup.getDefault().lookupAll(CommonSettingsProvider.class);
        Iterator i$ = providers.iterator();
        if (i$.hasNext()) {
            CommonSettingsProvider provider = (CommonSettingsProvider)i$.next();
            chkPublicB = provider.isMembersPublic();
            chkProtectedB = provider.isMembersProtected();
            chkPackageB = provider.isMembersPackage();
            chkCommentsB = provider.isBodyComments();
            chkContentB = provider.isBodyContent();
            chkJavaDocB = provider.isJavaDoc();
            chkGenerateSuitesB = provider.isGenerateSuiteClasses();
            chkPackagePrivateClassesB = provider.isIncludePackagePrivateClasses();
            chkAbstractImplB = provider.isGenerateAbstractImpl();
            chkExceptionsB = provider.isGenerateExceptionClasses();
            chkSetUpB = provider.isGenerateSetUp();
            chkTearDownB = provider.isGenerateTearDown();
            chkBeforeClassB = provider.isGenerateClassSetUp();
            chkAfterClassB = provider.isGenerateClassTearDown();
        }
        this.chkPublic.setSelected(chkPublicB);
        this.chkProtected.setSelected(chkProtectedB);
        this.chkPackage.setSelected(chkPackageB);
        this.chkComments.setSelected(chkCommentsB);
        this.chkContent.setSelected(chkContentB);
        this.chkJavaDoc.setSelected(chkJavaDocB);
        if (this.multipleClasses) {
            this.chkGenerateSuites.setSelected(chkGenerateSuitesB);
            this.chkPackagePrivateClasses.setSelected(chkPackagePrivateClassesB);
            this.chkAbstractImpl.setSelected(chkAbstractImplB);
            this.chkExceptions.setSelected(chkExceptionsB);
        }
        this.chkSetUp.setSelected(chkSetUpB);
        this.chkTearDown.setSelected(chkTearDownB);
        this.chkBeforeClass.setSelected(chkBeforeClassB);
        this.chkAfterClass.setSelected(chkAfterClassB);
    }

    private void rememberCheckBoxStates() {
        block1: {
            Collection providers = Lookup.getDefault().lookupAll(CommonSettingsProvider.class);
            Iterator i$ = providers.iterator();
            if (!i$.hasNext()) break block1;
            CommonSettingsProvider provider = (CommonSettingsProvider)i$.next();
            provider.setMembersPublic(this.chkPublic.isSelected());
            provider.setMembersProtected(this.chkProtected.isSelected());
            provider.setMembersPackage(this.chkPackage.isSelected());
            provider.setBodyComments(this.chkComments.isSelected());
            provider.setBodyContent(this.chkContent.isSelected());
            provider.setJavaDoc(this.chkJavaDoc.isSelected());
            if (this.multipleClasses) {
                provider.setGenerateSuiteClasses(this.chkGenerateSuites.isSelected());
                provider.setIncludePackagePrivateClasses(this.chkPackagePrivateClasses.isSelected());
                provider.setGenerateAbstractImpl(this.chkAbstractImpl.isSelected());
                provider.setGenerateExceptionClasses(this.chkExceptions.isSelected());
            }
            provider.setGenerateSetUp(this.chkSetUp.isSelected());
            provider.setGenerateTearDown(this.chkTearDown.isSelected());
            provider.setGenerateClassSetUp(this.chkBeforeClass.isSelected());
            provider.setGenerateClassTearDown(this.chkAfterClass.isSelected());
        }
    }

    private void initBundle() {
        block0: {
            Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
            Iterator i$ = providers.iterator();
            if (!i$.hasNext()) break block0;
            GuiUtilsProvider provider = (GuiUtilsProvider)i$.next();
            this.bundle = provider.getBundle();
        }
    }

    private void unlinkBundle() {
        this.bundle = null;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 12));
        jPanel.add(this.createNameAndLocationPanel(), "North");
        jPanel.add(this.createMessagePanel(), "Center");
        jPanel.add(this.createCodeGenPanel(), "South");
        this.add(jPanel);
    }

    private void setupUserInteraction() {
        CheckBoxListener listener = new CheckBoxListener();
        this.chkPublic.addItemListener(listener);
        this.chkProtected.addItemListener(listener);
        this.chkPackage.addItemListener(listener);
    }

    private String getTestingFrameworkSuffix() {
        Object tf = this.cboxFramework.getSelectedItem();
        if (tf == null) {
            return "";
        }
        String testngFramework = "";
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator i$ = providers.iterator();
        if (i$.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)i$.next();
            testngFramework = provider.getTestngFramework();
        }
        return tf.toString().equals(testngFramework) ? "NG" : "";
    }

    private void fireFrameworkChanged() {
        if (this.tfClassName != null) {
            DataObject dataObj = (DataObject)this.nodes[0].getLookup().lookup(DataObject.class);
            FileObject fileObj = dataObj.getPrimaryFile();
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
            String className = cp.getResourceName(fileObj, '.', false);
            String prefilledName = className + this.getTestingFrameworkSuffix() + TEST_CLASS_SUFFIX;
            this.tfClassName.setText(prefilledName);
            this.tfClassName.setDefaultText(prefilledName);
            this.tfClassName.setCaretPosition(prefilledName.length());
        }
        this.setSelectedTestingFramework();
    }

    private void setSelectedTestingFramework() {
        Object tf = this.cboxFramework.getSelectedItem();
        if (tf != null) {
            this.selectedTestingFramework = tf.toString();
        }
    }

    public String getSelectedTestingFramework() {
        return this.selectedTestingFramework;
    }

    public void addTestingFrameworks(ArrayList<String> testingFrameworksToAdd) {
        for (String testingFramework : testingFrameworksToAdd) {
            this.testingFrameworks.add(testingFramework);
        }
        this.cboxFramework.setModel(new DefaultComboBoxModel<Object>(this.testingFrameworks.toArray()));
        this.fireFrameworkChanged();
    }

    private Component createNameAndLocationPanel() {
        Font labelFont;
        JPanel panel = new JPanel();
        boolean askForClassName = this.singleClass;
        JLabel lblClassToTest = new JLabel();
        JLabel lblClassName = askForClassName ? new JLabel() : null;
        JLabel lblLocation = new JLabel();
        JLabel lblFramework = new JLabel();
        String classToTestKey = this.singlePackage ? "LBL_PackageToTest" : (this.singleClass ? "LBL_ClassToTest" : "LBL_MultipleClassesSelected");
        String classToTest = "";
        String classname = "";
        String location = "";
        String framework = "";
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator i$ = providers.iterator();
        if (i$.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)i$.next();
            classToTest = provider.getMessageFor(classToTestKey);
            classname = provider.getMessageFor("LBL_ClassName");
            location = provider.getMessageFor("LBL_Location");
            framework = provider.getMessageFor("LBL_Framework");
        }
        Mnemonics.setLocalizedText((JLabel)lblClassToTest, (String)classToTest);
        if (askForClassName) {
            Mnemonics.setLocalizedText((JLabel)lblClassName, (String)classname);
        }
        Mnemonics.setLocalizedText((JLabel)lblLocation, (String)location);
        Mnemonics.setLocalizedText((JLabel)lblFramework, (String)framework);
        if (this.singlePackage || this.singleClass) {
            this.lblClassToTestValue = new JLabel();
        }
        if (askForClassName) {
            this.tfClassName = new ClassNameTextField();
            this.tfClassName.setChangeListener(this);
        }
        this.cboxLocation = new JComboBox();
        this.cboxFramework = new JComboBox();
        this.testingFrameworks = new ArrayList<String>();
        this.cboxFramework.setModel(new DefaultComboBoxModel<Object>(this.testingFrameworks.toArray()));
        this.cboxFramework.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CommonTestsCfgOfCreate.this.fireFrameworkChanged();
            }
        });
        if (askForClassName) {
            lblClassName.setLabelFor(this.tfClassName);
        }
        lblLocation.setLabelFor(this.cboxLocation);
        lblFramework.setLabelFor(this.cboxFramework);
        if (this.lblClassToTestValue != null && (labelFont = UIManager.getDefaults().getFont("TextField.font")) != null) {
            this.lblClassToTestValue.setFont(labelFont);
        }
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcLeft = new GridBagConstraints();
        gbcLeft.anchor = 17;
        gbcLeft.insets.bottom = 12;
        gbcLeft.insets.right = 6;
        GridBagConstraints gbcRight = new GridBagConstraints();
        gbcRight.anchor = 17;
        gbcRight.insets.bottom = 12;
        gbcRight.weightx = 1.0;
        gbcRight.fill = 1;
        gbcRight.gridwidth = 0;
        if (this.lblClassToTestValue != null) {
            panel.add((Component)lblClassToTest, gbcLeft);
            panel.add((Component)this.lblClassToTestValue, gbcRight);
        } else {
            panel.add((Component)lblClassToTest, gbcRight);
        }
        if (askForClassName) {
            panel.add((Component)lblClassName, gbcLeft);
            panel.add((Component)this.tfClassName, gbcRight);
        }
        panel.add((Component)lblLocation, gbcLeft);
        panel.add((Component)this.cboxLocation, gbcRight);
        gbcLeft.insets.bottom = 0;
        gbcRight.insets.bottom = 0;
        panel.add((Component)lblFramework, gbcLeft);
        panel.add((Component)this.cboxFramework, gbcRight);
        return panel;
    }

    private void checkClassNameValidity() {
        Collection providers;
        Iterator i$;
        if (this.tfClassName == null) {
            this.classNameValid = true;
            return;
        }
        String key = null;
        int state = this.tfClassName.getStatus();
        switch (state) {
            case 1: {
                key = "MSG_ClassnameMustNotBeEmpty";
                break;
            }
            case 2: {
                key = "MSG_InvalidClassName";
                break;
            }
            case 3: {
                key = "MSG_ClassNameNotDefault";
                break;
            }
            case 4: {
                key = "MSG_ClassNameEndNotTest";
            }
        }
        if (state != 3) {
            this.setMessage(null, 2);
        }
        String message = "";
        if (key != null && (i$ = (providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class)).iterator()).hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)i$.next();
            message = provider.getMessageFor(key);
        }
        this.setMessage(key != null ? message : null, 1);
        this.classNameValid = state == 0 || state == 3;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.checkClassNameValidity();
        this.checkAcceptability();
    }

    private void checkAcceptability() {
        boolean wasAcceptable = this.isAcceptable;
        boolean bl = this.isAcceptable = this.hasTargetFolders && this.classNameValid;
        if (this.isAcceptable != wasAcceptable) {
            this.fireStateChange();
        }
    }

    private boolean isAcceptable() {
        return this.isAcceptable;
    }

    @Override
    protected void paintedFirstTime(Graphics g) {
        if (this.initialMessage != null) {
            this.displayMessage(this.initialMessage);
            this.initialMessage = null;
        }
    }

    private void setMessage(String message, int msgType) {
        String msgToDisplay = this.msgStack.setMessage(msgType, message);
        if (msgToDisplay == null) {
            return;
        }
        if (!this.isPainted()) {
            this.initialMessage = msgToDisplay;
        } else {
            this.displayMessage(msgToDisplay);
        }
    }

    private void displayMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.txtAreaMessage.setText(message);
        this.adjustWindowSize();
    }

    private Component createMessagePanel() {
        block1: {
            Collection providers;
            Iterator i$;
            Color color = UIManager.getColor("nb.errorForeground");
            if (color == null) {
                color = new Color(89, 79, 191);
            }
            if (!(i$ = (providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class)).iterator()).hasNext()) break block1;
            GuiUtilsProvider provider = (GuiUtilsProvider)i$.next();
            this.txtAreaMessage = provider.createMultilineLabel("", color);
        }
        return this.txtAreaMessage;
    }

    private Component createCodeGenPanel() {
        Iterator i$;
        GuiUtilsProvider provider;
        Iterator i$2;
        String[] chkBoxIDs = new String[14];
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        if (this.multipleClasses) {
            i$2 = providers.iterator();
            if (i$2.hasNext()) {
                provider = (GuiUtilsProvider)i$2.next();
                chkBoxIDs = new String[]{provider.getCheckboxText("CHK_PUBLIC"), provider.getCheckboxText("CHK_PROTECTED"), provider.getCheckboxText("CHK_PACKAGE"), provider.getCheckboxText("CHK_PACKAGE_PRIVATE_CLASSES"), provider.getCheckboxText("CHK_ABSTRACT_CLASSES"), provider.getCheckboxText("CHK_EXCEPTION_CLASSES"), provider.getCheckboxText("CHK_SUITES"), provider.getCheckboxText("CHK_SETUP"), provider.getCheckboxText("CHK_TEARDOWN"), provider.getCheckboxText("CHK_BEFORE_CLASS"), provider.getCheckboxText("CHK_AFTER_CLASS"), provider.getCheckboxText("CHK_METHOD_BODIES"), provider.getCheckboxText("CHK_JAVADOC"), provider.getCheckboxText("CHK_HINTS")};
            }
        } else {
            i$2 = providers.iterator();
            if (i$2.hasNext()) {
                provider = (GuiUtilsProvider)i$2.next();
                chkBoxIDs = new String[]{provider.getCheckboxText("CHK_PUBLIC"), provider.getCheckboxText("CHK_PROTECTED"), provider.getCheckboxText("CHK_PACKAGE"), null, null, null, null, provider.getCheckboxText("CHK_SETUP"), provider.getCheckboxText("CHK_TEARDOWN"), provider.getCheckboxText("CHK_BEFORE_CLASS"), provider.getCheckboxText("CHK_AFTER_CLASS"), provider.getCheckboxText("CHK_METHOD_BODIES"), provider.getCheckboxText("CHK_JAVADOC"), provider.getCheckboxText("CHK_HINTS")};
            }
        }
        JCheckBox[] chkBoxes = new JCheckBox[chkBoxIDs.length];
        i$2 = providers.iterator();
        if (i$2.hasNext()) {
            provider = (GuiUtilsProvider)i$2.next();
            chkBoxes = provider.createCheckBoxes(chkBoxIDs);
        }
        int i = 0;
        this.chkPublic = chkBoxes[i++];
        this.chkProtected = chkBoxes[i++];
        this.chkPackage = chkBoxes[i++];
        this.chkPackagePrivateClasses = chkBoxes[i++];
        this.chkAbstractImpl = chkBoxes[i++];
        this.chkExceptions = chkBoxes[i++];
        this.chkGenerateSuites = chkBoxes[i++];
        this.chkSetUp = chkBoxes[i++];
        this.chkTearDown = chkBoxes[i++];
        this.chkBeforeClass = chkBoxes[i++];
        this.chkAfterClass = chkBoxes[i++];
        this.chkContent = chkBoxes[i++];
        this.chkJavaDoc = chkBoxes[i++];
        this.chkComments = chkBoxes[i++];
        JComponent methodAccessLevels = null;
        Iterator i$3 = providers.iterator();
        if (i$3.hasNext()) {
            GuiUtilsProvider provider2 = (GuiUtilsProvider)i$3.next();
            methodAccessLevels = provider2.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupAccessLevels"), new JCheckBox[]{this.chkPublic, this.chkProtected, this.chkPackage});
        }
        JComponent classTypes = null;
        JComponent optionalClasses = null;
        if (this.multipleClasses && (i$ = providers.iterator()).hasNext()) {
            GuiUtilsProvider provider3 = (GuiUtilsProvider)i$.next();
            classTypes = provider3.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupClassTypes"), new JCheckBox[]{this.chkPackagePrivateClasses, this.chkAbstractImpl, this.chkExceptions});
            optionalClasses = provider3.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupOptClasses"), new JCheckBox[]{this.chkGenerateSuites});
        }
        JComponent optionalCode = null;
        JComponent optionalComments = null;
        Iterator i$4 = providers.iterator();
        if (i$4.hasNext()) {
            GuiUtilsProvider provider4 = (GuiUtilsProvider)i$4.next();
            optionalCode = provider4.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupOptCode"), new JCheckBox[]{this.chkSetUp, this.chkTearDown, this.chkBeforeClass, this.chkAfterClass, this.chkContent});
            optionalComments = provider4.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupOptComments"), new JCheckBox[]{this.chkJavaDoc, this.chkComments});
        }
        Box leftColumn = Box.createVerticalBox();
        leftColumn.add(methodAccessLevels);
        if (this.multipleClasses) {
            leftColumn.add(Box.createVerticalStrut(11));
            leftColumn.add(classTypes);
        } else {
            leftColumn.add(Box.createVerticalStrut(0));
        }
        leftColumn.add(Box.createVerticalGlue());
        Box rightColumn = Box.createVerticalBox();
        if (this.multipleClasses) {
            rightColumn.add(optionalClasses);
            rightColumn.add(Box.createVerticalStrut(11));
        }
        rightColumn.add(optionalCode);
        rightColumn.add(Box.createVerticalStrut(11));
        rightColumn.add(optionalComments);
        rightColumn.add(Box.createVerticalGlue());
        JPanel jpCodeGen = new JPanel();
        jpCodeGen.setLayout(new BoxLayout(jpCodeGen, 0));
        jpCodeGen.add(leftColumn);
        jpCodeGen.add(Box.createHorizontalStrut(24));
        jpCodeGen.add(rightColumn);
        CommonTestsCfgOfCreate.addTitledBorder(jpCodeGen, new Insets(12, 12, 11, 12), this.bundle.getString("CommonTestsCfgOfCreate.jpCodeGen.title"));
        methodAccessLevels.setAlignmentX(0.0f);
        if (this.multipleClasses) {
            classTypes.setAlignmentX(0.0f);
            optionalClasses.setAlignmentX(0.0f);
        }
        optionalCode.setAlignmentX(0.0f);
        optionalComments.setAlignmentX(0.0f);
        return jpCodeGen;
    }

    private static void addTitledBorder(JComponent component, Insets insets, String title) {
        Border insideBorder = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        TitledBorder outsideBorder = new TitledBorder(BorderFactory.createEtchedBorder(), title);
        component.setBorder(new CompoundBorder(outsideBorder, insideBorder));
    }

    public FileObject getTargetFolder() {
        Object selectedLocation = this.cboxLocation.getSelectedItem();
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return ((SourceGroup)selectedLocation).getRootFolder();
        }
        assert (selectedLocation instanceof FileObject);
        return (FileObject)selectedLocation;
    }

    private void fillFormData() {
        DataObject dataObj = (DataObject)this.nodes[0].getLookup().lookup(DataObject.class);
        FileObject fileObj = dataObj.getPrimaryFile();
        if (this.singleClass) {
            assert (this.nodes.length == 1);
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
            String className = cp.getResourceName(fileObj, '.', false);
            this.lblClassToTestValue.setText(className);
            if (this.tfClassName != null) {
                String prefilledName = className + this.getTestingFrameworkSuffix() + TEST_CLASS_SUFFIX;
                this.tfClassName.setText(prefilledName);
                this.tfClassName.setDefaultText(prefilledName);
                this.tfClassName.setCaretPosition(prefilledName.length());
            }
        } else if (this.singlePackage) {
            Collection providers;
            Iterator i$;
            String packageName;
            assert (this.nodes.length == 1);
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
            String string = packageName = cp == null ? "" : cp.getResourceName(fileObj, '.', true);
            if (packageName.length() == 0 && (i$ = (providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class)).iterator()).hasNext()) {
                GuiUtilsProvider provider = (GuiUtilsProvider)i$.next();
                packageName = provider.getMessageFor("DefaultPackageName");
            }
            this.lblClassToTestValue.setText(packageName);
        }
        this.setupLocationChooser(fileObj);
        this.checkClassNameValidity();
    }

    private void setupLocationChooser(FileObject refFileObject) {
        Project owner;
        Collection providers = Lookup.getDefault().lookupAll(CommonTestUtilProvider.class);
        Object[] targetFolders = null;
        Iterator i$ = providers.iterator();
        if (i$.hasNext()) {
            CommonTestUtilProvider provider = (CommonTestUtilProvider)i$.next();
            targetFolders = provider.getTestTargets(refFileObject);
        }
        if (targetFolders.length == 0 && (owner = FileOwnerQuery.getOwner((FileObject)refFileObject)) != null) {
            String type = "";
            String hint = "";
            Collection rootProviders = Lookup.getDefault().lookupAll(RootsProvider.class);
            Iterator i$2 = rootProviders.iterator();
            if (i$2.hasNext()) {
                RootsProvider rootProvider = (RootsProvider)i$2.next();
                type = rootProvider.getSourceRootType();
                hint = rootProvider.getProjectTestsHint();
            }
            if (SourceGroupModifier.createSourceGroup((Project)owner, (String)type, (String)hint) != null && (i$2 = (providers = Lookup.getDefault().lookupAll(CommonTestUtilProvider.class)).iterator()).hasNext()) {
                CommonTestUtilProvider provider = (CommonTestUtilProvider)i$2.next();
                targetFolders = provider.getTestTargets(refFileObject);
            }
        }
        if (targetFolders.length != 0) {
            this.hasTargetFolders = true;
            this.cboxLocation.setModel(new DefaultComboBoxModel<Object>(targetFolders));
            this.cboxLocation.setRenderer(new LocationChooserRenderer());
        } else {
            this.hasTargetFolders = false;
            String msgNoTargetsFound = NbBundle.getMessage(this.getClass(), (String)(refFileObject.isFolder() ? "MSG_NoTestTarget_Fo" : "MSG_NoTestTarget_Fi"), (Object)refFileObject.getNameExt());
            this.setMessage(msgNoTargetsFound, 0);
            this.disableComponents();
        }
    }

    private void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(3);
        }
        this.changeListeners.add(l);
    }

    private void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.remove(l) && this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }

    private void fireStateChange() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            Iterator<ChangeListener> i = this.changeListeners.iterator();
            while (i.hasNext()) {
                i.next().stateChanged(e);
            }
        }
    }

    private void disableComponents() {
        Stack<Container> stack = new Stack<Container>();
        stack.push(this);
        while (!stack.empty()) {
            Container container = (Container)stack.pop();
            Component[] comps = container.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Container nestedCont;
                Component comp = comps[i];
                if (comp == this.txtAreaMessage) continue;
                if (comp instanceof JPanel) {
                    JPanel panel = (JPanel)comp;
                    stack.push(panel);
                    Border border = panel.getBorder();
                    if (border == null) continue;
                    CommonTestsCfgOfCreate.disableBorderTitles(border);
                    continue;
                }
                comp.setEnabled(false);
                if (!(comp instanceof Container) || (nestedCont = (Container)comp).getComponentCount() == 0) continue;
                stack.push(nestedCont);
            }
        }
    }

    private static void disableBorderTitles(Border border) {
        if (border instanceof TitledBorder) {
            CommonTestsCfgOfCreate.disableBorderTitle((TitledBorder)border);
            return;
        }
        if (!(border instanceof CompoundBorder)) {
            return;
        }
        Stack<CompoundBorder> stack = new Stack<CompoundBorder>();
        stack.push((CompoundBorder)border);
        while (!stack.empty()) {
            CompoundBorder cb = (CompoundBorder)stack.pop();
            Border b = cb.getOutsideBorder();
            if (b instanceof CompoundBorder) {
                stack.push((CompoundBorder)b);
            } else if (b instanceof TitledBorder) {
                CommonTestsCfgOfCreate.disableBorderTitle((TitledBorder)b);
            }
            b = cb.getInsideBorder();
            if (b instanceof CompoundBorder) {
                stack.push((CompoundBorder)b);
                continue;
            }
            if (!(b instanceof TitledBorder)) continue;
            CommonTestsCfgOfCreate.disableBorderTitle((TitledBorder)b);
        }
    }

    private static void disableBorderTitle(TitledBorder border) {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color != null) {
            border.setTitleColor(color);
        }
    }

    private final class LocationChooserRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public LocationChooserRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String text = value instanceof SourceGroup ? ((SourceGroup)value).getDisplayName() : (value instanceof FileObject ? FileUtil.getFileDisplayName((FileObject)((FileObject)value)) : value.toString());
            this.setText(text);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private final class CheckBoxListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            assert (source == CommonTestsCfgOfCreate.this.chkPublic || source == CommonTestsCfgOfCreate.this.chkProtected || source == CommonTestsCfgOfCreate.this.chkPackage);
            CommonTestsCfgOfCreate.this.checkAcceptability();
        }
    }
}

