/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class RunCheckerImpl
implements LateBoundPrerequisitesChecker {
    private static final Logger LOG = Logger.getLogger(RunCheckerImpl.class.getName());
    private static final String PROFILER_ARGS = "${profiler.args}";
    private static final String PROFILER_ARGS_PREFIXED = "${profiler.args.prefixed}";
    private static final String PROFILER_JAVA = "${profiler.java}";
    private static final String PROFILER_JDKHOME_OPT = "${profiler.jdkhome.opt}";
    private final Project project;

    public RunCheckerImpl(Project prj) {
        this.project = prj;
    }

    public boolean checkRunConfig(RunConfig config, ExecutionContext context) {
        Map configProperties = config.getProperties();
        if ("profile".equals(config.getActionName()) || "profile.test.single".equals(config.getActionName()) || config.getActionName() != null && config.getActionName().startsWith("profile.single")) {
            HashMap props = new HashMap();
            props.putAll(configProperties);
            ProfilerLauncher.Session session = ProfilerLauncher.getLastSession();
            if (session == null) {
                this.closeInputOuptut(context);
                return false;
            }
            Map sProps = session.getProperties();
            if (sProps == null) {
                this.closeInputOuptut(context);
                return false;
            }
            props.putAll(sProps);
            session.setAttribute("mvn-run-checker.config", (Object)config);
            final ProfilerLauncher.Session s = session;
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    Profiler.getDefault().connectToStartedApp(s.getProfilingSettings(), s.getSessionSettings());
                }
            });
        }
        return true;
    }

    private void closeInputOuptut(ExecutionContext context) {
        InputOutput ioput = context.getInputOutput();
        if (ioput != null) {
            ioput.closeInputOutput();
        }
    }

    public static final class MavenLauncherFactory
    implements ProfilerLauncher.LauncherFactory {
        public ProfilerLauncher.Launcher createLauncher(final ProfilerLauncher.Session session) {
            return new ProfilerLauncher.Launcher(){

                public void launch(boolean rerun) {
                    if (rerun) {
                        RunConfig config = (RunConfig)session.getAttribute("mvn-run-checker.config");
                        if (config != null) {
                            RunUtils.executeMaven((RunConfig)config);
                        }
                    } else {
                        ActionProvider ap;
                        FileObject f;
                        Project p = session.getProject();
                        if (p == null && (f = session.getFile()) != null) {
                            p = FileOwnerQuery.getOwner((FileObject)f);
                        }
                        if (p != null && (ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class)) != null) {
                            ap.invokeAction(session.getCommand(), session.getContext());
                        }
                    }
                }
            };
        }
    }
}

