/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory;

import java.io.File;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.util.NbBundle;

public class LocalHistoryVCS
extends VersioningSystem {
    public LocalHistoryVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(LocalHistoryVCS.class, (String)"CTL_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(LocalHistoryVCS.class, (String)"CTL_MainMenuItem"));
        this.putProperty("Boolean VCS.LocalHistory", Boolean.TRUE);
        LocalHistory.getInstance().addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent event) {
                if (event.getId().equals(LocalHistory.EVENT_PROJECTS_CHANGED)) {
                    LocalHistoryVCS.this.fireVersionedFilesChanged();
                }
            }
        });
    }

    public File getTopmostManagedAncestor(File file) {
        if (file == null) {
            return null;
        }
        LocalHistory lh = LocalHistory.getInstance();
        if (lh.isOpenedOrTouched(file)) {
            return file;
        }
        File a = lh.isManagedByParent(file);
        if (a != null) {
            return a;
        }
        return null;
    }

    public VCSAnnotator getVCSAnnotator() {
        return LocalHistory.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return LocalHistory.getInstance().getVCSInterceptor();
    }

    public VCSHistoryProvider getVCSHistoryProvider() {
        return LocalHistory.getInstance().getVCSHistoryProvider();
    }

    void managedFilesChanged() {
        this.fireVersionedFilesChanged();
    }
}

