/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.spi.ApplicationConfigPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class WebRestSupport
extends RestSupport {
    private static final String POJO_MAPPING_FEATURE = "com.sun.jersey.api.json.POJOMappingFeature";
    private static final String JACKSON_JSON_PROVIDER = "org.codehaus.jackson.jaxrs.JacksonJsonProvider";
    private static final String GET_REST_RESOURCE_CLASSES = "getRestResourceClasses";
    private static final String GET_CLASSES = "getClasses";
    public static final String PROP_REST_RESOURCES_PATH = "rest.resources.path";
    public static final String PROP_REST_CONFIG_TYPE = "rest.config.type";
    public static final String PROP_REST_JERSEY = "rest.jersey.type";
    public static final String CONFIG_TYPE_IDE = "ide";
    public static final String CONFIG_TYPE_USER = "user";
    public static final String CONFIG_TYPE_DD = "dd";
    public static final String JERSEY_CONFIG_IDE = "ide";
    public static final String JERSEY_CONFIG_SERVER = "server";
    public static final String CONTAINER_RESPONSE_FILTER = "com.sun.jersey.spi.container.ContainerResponseFilters";
    public static final String REST_CONFIG_TARGET = "generate-rest-config";
    protected static final String JERSEY_SPRING_JAR_PATTERN = "jersey-spring.*\\.jar";
    protected static final String JERSEY_PROP_PACKAGES = "com.sun.jersey.config.property.packages";
    protected static final String JERSEY_PROP_PACKAGES_DESC = "Multiple packages, separated by semicolon(;), can be specified in param-value";
    private volatile PropertyChangeListener restModelListener;
    private RequestProcessor REST_APP_MODIFICATION_RP = new RequestProcessor(WebRestSupport.class);

    public WebRestSupport(Project project) {
        super(project);
    }

    @Override
    public boolean isRestSupportOn() {
        if (this.getAntProjectHelper() == null) {
            return false;
        }
        return this.getProjectProperty(PROP_REST_CONFIG_TYPE) != null;
    }

    public void enableRestSupport(RestConfig config) {
        String type = null;
        if (config == null) {
            return;
        }
        switch (config) {
            case IDE: {
                type = "ide";
                break;
            }
            case DD: {
                type = CONFIG_TYPE_DD;
                JaxRsStackSupport support = this.getJaxRsStackSupport();
                boolean added = false;
                if (support != null) {
                    added = support.extendsJerseyProjectClasspath(this.project);
                }
                if (added) break;
                JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.project);
                break;
            }
        }
        if (type != null) {
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, type);
        }
    }

    @Override
    public FileObject getPersistenceXml() {
        PersistenceScope ps = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (ps != null) {
            return ps.getPersistenceXml();
        }
        return null;
    }

    public WebApp getWebApp() throws IOException {
        FileObject fo = this.getWebXml();
        if (fo != null) {
            return DDProvider.getDefault().getDDRoot(fo);
        }
        return null;
    }

    protected WebApp findWebApp() throws IOException {
        FileObject ddFo;
        WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (wm != null && (ddFo = wm.getDeploymentDescriptor()) != null) {
            return DDProvider.getDefault().getDDRoot(ddFo);
        }
        return null;
    }

    public String getApplicationPathFromDD() throws IOException {
        ServletMapping sm;
        WebApp webApp = this.findWebApp();
        if (webApp != null && (sm = this.getRestServletMapping(webApp)) != null) {
            String urlPattern = null;
            if (sm instanceof ServletMapping25) {
                String[] urlPatterns = ((ServletMapping25)sm).getUrlPatterns();
                if (urlPatterns.length > 0) {
                    urlPattern = urlPatterns[0];
                }
            } else {
                urlPattern = sm.getUrlPattern();
            }
            if (urlPattern != null) {
                if (urlPattern.endsWith("*")) {
                    urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
                }
                if (urlPattern.endsWith("/")) {
                    urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
                }
                if (urlPattern.startsWith("/")) {
                    urlPattern = urlPattern.substring(1);
                }
                return urlPattern;
            }
        }
        return null;
    }

    @Override
    public void upgrade() {
        if (!this.isRestSupportOn()) {
            return;
        }
        try {
            FileObject ddFO = this.getDeploymentDescriptor();
            if (ddFO == null) {
                return;
            }
            WebApp webApp = this.findWebApp();
            if (webApp == null) {
                return;
            }
            Servlet adaptorServlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
            if (adaptorServlet != null && "com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(adaptorServlet.getServletClass())) {
                boolean isSpring = this.hasSpringSupport();
                if (isSpring) {
                    adaptorServlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    InitParam initParam = (InitParam)adaptorServlet.findBeanByName("InitParam", "ParamName", JERSEY_PROP_PACKAGES);
                    if (initParam == null) {
                        try {
                            initParam = (InitParam)adaptorServlet.createBean("InitParam");
                            initParam.setParamName(JERSEY_PROP_PACKAGES);
                            initParam.setParamValue(".");
                            initParam.setDescription(JERSEY_PROP_PACKAGES_DESC);
                            adaptorServlet.addInitParam(initParam);
                        }
                        catch (ClassNotFoundException ex) {}
                    }
                } else {
                    adaptorServlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                webApp.write(ddFO);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    public void addInitParam(String paramName, String value) {
        try {
            FileObject ddFO = this.getWebXml();
            WebApp webApp = this.findWebApp();
            if (ddFO == null || webApp == null) {
                return;
            }
            Servlet adaptorServlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
            InitParam initParam = (InitParam)adaptorServlet.findBeanByName("InitParam", "ParamName", paramName);
            if (initParam == null) {
                try {
                    initParam = (InitParam)adaptorServlet.createBean("InitParam");
                    adaptorServlet.addInitParam(initParam);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            initParam.setParamName(paramName);
            initParam.setParamValue(value);
            webApp.write(ddFO);
        }
        catch (IOException e) {
            Logger.getLogger(WebRestSupport.class.getName()).log(Level.WARNING, null, e);
        }
    }

    public FileObject getDeploymentDescriptor() {
        WebModuleProvider wmp = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (wmp != null) {
            return wmp.findWebModule(this.project.getProjectDirectory()).getDeploymentDescriptor();
        }
        return null;
    }

    public FileObject getWebXml() throws IOException {
        WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (wm != null) {
            FileObject ddFo = wm.getDeploymentDescriptor();
            if (ddFo == null) {
                FileObject docBase;
                FileObject webInf = wm.getWebInf();
                if (webInf == null && (docBase = wm.getDocumentBase()) != null) {
                    webInf = docBase.createFolder("WEB-INF");
                }
                if (webInf != null) {
                    ddFo = DDHelper.createWebXml((Profile)wm.getJ2eeProfile(), (FileObject)webInf);
                }
            }
            return ddFo;
        }
        return null;
    }

    public ServletMapping getRestServletMapping(WebApp webApp) {
        String servletName = null;
        for (Servlet servlet : webApp.getServlet()) {
            String servletClass = servlet.getServletClass();
            if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(servletClass) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(servletClass)) continue;
            servletName = servlet.getServletName();
            break;
        }
        if (servletName != null) {
            for (Servlet servlet : webApp.getServletMapping()) {
                if (!servletName.equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    public boolean hasApplicationResourceClass(final String fqn) {
        List<RestApplication> applications = this.getRestApplications();
        if (applications.isEmpty()) {
            return false;
        }
        final String clazz = applications.get(0).getApplicationClass();
        final boolean[] has = new boolean[1];
        try {
            JavaSource javaSource = this.getJavaSourceFromClassName(clazz);
            if (javaSource == null) {
                return false;
            }
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(final CompilationController controller) throws Exception {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = controller.getElements().getTypeElement(clazz);
                    if (typeElement == null) {
                        return;
                    }
                    TypeElement restResource = controller.getElements().getTypeElement(fqn);
                    if (restResource == null) {
                        return;
                    }
                    List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                    ExecutableElement getClasses = null;
                    for (ExecutableElement method : methods) {
                        if (!method.getSimpleName().contentEquals(WebRestSupport.GET_REST_RESOURCE_CLASSES) || !method.getParameters().isEmpty()) continue;
                        getClasses = method;
                        break;
                    }
                    if (getClasses == null) {
                        return;
                    }
                    final String className = restResource.getQualifiedName().toString() + ".class";
                    final MethodTree tree = controller.getTrees().getTree(getClasses);
                    final Document doc = controller.getDocument();
                    if (doc == null) {
                        return;
                    }
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                SourcePositions srcPos = controller.getTrees().getSourcePositions();
                                int start = (int)srcPos.getStartPosition(controller.getCompilationUnit(), tree);
                                int end = (int)srcPos.getEndPosition(controller.getCompilationUnit(), tree);
                                try {
                                    String text = doc.getText(start, end - start + 1);
                                    if (text.contains(className)) {
                                        has[0] = true;
                                    }
                                }
                                catch (BadLocationException e) {
                                    if ($assertionsDisabled) break block3;
                                    throw new AssertionError();
                                }
                            }
                        }
                    });
                }
            }, true);
        }
        catch (IOException e) {
            Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
        }
        return has[0];
    }

    protected boolean hasRestServletAdaptor() {
        try {
            return this.getRestServletAdaptor(this.getWebApp()) != null;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return false;
        }
    }

    public boolean hasServerJerseyLibrary() {
        return this.getJaxRsStackSupport() != null;
    }

    public JaxRsStackSupport getJaxRsStackSupport() {
        return JaxRsStackSupport.getInstance((Project)this.project);
    }

    public boolean hasJaxRsApi() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        boolean isJee6 = Profile.JAVA_EE_6_WEB.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile) || Profile.JAVA_EE_7_WEB.equals(profile) || Profile.JAVA_EE_7_FULL.equals(profile);
        return isJee6 && this.supportsTargetProfile(Profile.JAVA_EE_6_FULL);
    }

    public boolean supportsTargetProfile(Profile profile) {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null) {
            return false;
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            Set profiles = serverInstance.getJ2eePlatform().getSupportedProfiles();
            return profiles.contains(profile);
        }
        catch (InstanceRemovedException e) {
            return false;
        }
    }

    public Servlet getRestServletAdaptor(WebApp webApp) {
        if (webApp != null) {
            for (Servlet s : webApp.getServlet()) {
                String servletClass = s.getServletClass();
                if (!"com.sun.jersey.spi.container.servlet.ServletContainer".equals(servletClass) && !"com.sun.jersey.spi.spring.container.servlet.SpringServlet".equals(servletClass) && !"com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(servletClass)) continue;
                return s;
            }
        }
        return null;
    }

    protected Servlet getRestServletAdaptorByName(WebApp webApp, String servletName) {
        if (webApp != null) {
            for (Servlet s : webApp.getServlet()) {
                if (!servletName.equals(s.getServletName())) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public void configure(String ... packages) throws IOException {
        RestApplicationModel restAppModel;
        String configType = this.getProjectProperty(PROP_REST_CONFIG_TYPE);
        if (CONFIG_TYPE_DD.equals(configType)) {
            this.configRestPackages(packages);
        } else if ("ide".equals(configType) && (restAppModel = this.getRestApplicationsModel()) != null) {
            try {
                restAppModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<RestApplications, Void>(){

                    public Void run(RestApplications metadata) throws IOException {
                        List<RestApplication> applications = metadata.getRestApplications();
                        if (applications != null && !applications.isEmpty()) {
                            RestApplication application = applications.get(0);
                            String clazz = application.getApplicationClass();
                            WebRestSupport.this.reconfigApplicationClass(clazz);
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException ex) {
                Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    public void addResourceConfigToWebApp(String resourcePath) throws IOException {
        FileObject ddFO = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        if (webApp.getStatus() == 2 || webApp.getStatus() == 3) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebRestSupport.class, (String)"MSG_InvalidDD", (Object)webApp.getError()), 0));
            return;
        }
        boolean needsSave = false;
        try {
            Servlet adaptorServlet = this.getRestServletAdaptor(webApp);
            if (adaptorServlet == null) {
                adaptorServlet = (Servlet)webApp.createBean("Servlet");
                adaptorServlet.setServletName("ServletAdaptor");
                boolean isSpring = this.hasSpringSupport();
                if (isSpring) {
                    adaptorServlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    InitParam initParam = (InitParam)adaptorServlet.createBean("InitParam");
                    initParam.setParamName(JERSEY_PROP_PACKAGES);
                    initParam.setParamValue(".");
                    initParam.setDescription(JERSEY_PROP_PACKAGES_DESC);
                    adaptorServlet.addInitParam(initParam);
                } else {
                    adaptorServlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                adaptorServlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(adaptorServlet);
                needsSave = true;
            }
            String resourcesUrl = resourcePath;
            if (!resourcePath.startsWith("/")) {
                resourcesUrl = "/" + resourcePath;
            }
            if (resourcesUrl.endsWith("/")) {
                resourcesUrl = resourcesUrl + "*";
            } else if (!resourcesUrl.endsWith("*")) {
                resourcesUrl = resourcesUrl + "/*";
            }
            ServletMapping sm = this.getRestServletMapping(webApp);
            if (sm == null) {
                sm = (ServletMapping)webApp.createBean("ServletMapping");
                sm.setServletName(adaptorServlet.getServletName());
                if (sm instanceof ServletMapping25) {
                    ((ServletMapping25)sm).addUrlPattern(resourcesUrl);
                } else {
                    sm.setUrlPattern(resourcesUrl);
                }
                webApp.addServletMapping(sm);
                needsSave = true;
            } else {
                String[] urlPatterns;
                boolean urlPatternChanged = false;
                if (sm instanceof ServletMapping25) {
                    urlPatterns = ((ServletMapping25)sm).getUrlPatterns();
                    if (urlPatterns.length == 0 || !resourcesUrl.equals(urlPatterns[0])) {
                        urlPatternChanged = true;
                    }
                } else if (!resourcesUrl.equals(sm.getUrlPattern())) {
                    urlPatternChanged = true;
                }
                if (urlPatternChanged) {
                    if (sm instanceof ServletMapping25) {
                        urlPatterns = ((ServletMapping25)sm).getUrlPatterns();
                        if (urlPatterns.length > 0) {
                            ((ServletMapping25)sm).setUrlPattern(0, resourcesUrl);
                        } else {
                            ((ServletMapping25)sm).addUrlPattern(resourcesUrl);
                        }
                    } else {
                        sm.setUrlPattern(resourcesUrl);
                    }
                    needsSave = true;
                }
            }
            if (needsSave) {
                webApp.write(ddFO);
                this.logResourceCreation(this.project);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String getApplicationPath() throws IOException {
        String pathFromDD = this.getApplicationPathFromDD();
        String applPath = this.getApplicationPathFromAnnotations(pathFromDD);
        return applPath == null ? super.getApplicationPath() : applPath;
    }

    protected String getApplicationPathFromAnnotations(String applPathFromDD) {
        List<RestApplication> restApplications = this.getRestApplications();
        if (applPathFromDD == null) {
            if (restApplications.size() == 0) {
                return null;
            }
            return restApplications.get(0).getApplicationPath();
        }
        if (restApplications.size() == 0) {
            return applPathFromDD;
        }
        for (RestApplication appl : restApplications) {
            if (!applPathFromDD.equals(appl.getApplicationPath())) continue;
            return applPathFromDD;
        }
        return restApplications.get(0).getApplicationPath();
    }

    protected void removeResourceConfigFromWebApp() throws IOException {
        FileObject ddFO = this.getWebXml();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean needsSave = false;
        Servlet restServlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
        if (restServlet != null) {
            webApp.removeServlet(restServlet);
            needsSave = true;
        }
        for (ServletMapping sm : webApp.getServletMapping()) {
            if (!"ServletAdaptor".equals(sm.getServletName())) continue;
            webApp.removeServletMapping(sm);
            needsSave = true;
            break;
        }
        if (needsSave) {
            webApp.write(ddFO);
        }
    }

    protected void logResourceCreation(Project prj) {
    }

    public List<RestApplication> getRestApplications() {
        RestApplicationModel applicationModel = this.getRestApplicationsModel();
        if (applicationModel != null) {
            try {
                Future future = applicationModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<RestApplications, List<RestApplication>>(){

                    public List<RestApplication> run(RestApplications metadata) throws IOException {
                        return metadata.getRestApplications();
                    }
                });
                return (List)future.get();
            }
            catch (IOException ex) {
                return Collections.emptyList();
            }
            catch (InterruptedException ex) {
                return Collections.emptyList();
            }
            catch (ExecutionException ex) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    protected RestConfig setApplicationConfigProperty(boolean annotationConfigAvailable) {
        ApplicationConfigPanel configPanel = new ApplicationConfigPanel(annotationConfigAvailable, this.hasServerJerseyLibrary());
        DialogDescriptor desc = new DialogDescriptor((Object)configPanel, NbBundle.getMessage(WebRestSupport.class, (String)"TTL_ApplicationConfigPanel"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (NotifyDescriptor.OK_OPTION.equals(desc.getValue())) {
            String configType = configPanel.getConfigType();
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, configType);
            RestConfig rc = null;
            if ("ide".equals(configType)) {
                String applicationPath = configPanel.getApplicationPath();
                if (applicationPath.startsWith("/")) {
                    applicationPath = applicationPath.substring(1);
                }
                this.setProjectProperty(PROP_REST_RESOURCES_PATH, applicationPath);
                rc = RestConfig.IDE;
                rc.setResourcePath(applicationPath);
            } else if (CONFIG_TYPE_DD.equals(configType)) {
                rc = RestConfig.DD;
                rc.setResourcePath(configPanel.getApplicationPath());
            }
            if (rc != null) {
                rc.setJerseyLibSelected(configPanel.isJerseyLibSelected());
                rc.setServerJerseyLibSelected(configPanel.isServerJerseyLibSelected());
                if (configPanel.isServerJerseyLibSelected()) {
                    this.setProjectProperty(PROP_REST_JERSEY, JERSEY_CONFIG_SERVER);
                } else if (configPanel.isJerseyLibSelected()) {
                    this.setProjectProperty(PROP_REST_JERSEY, "ide");
                }
                return rc;
            }
        } else {
            this.setProjectProperty(PROP_REST_CONFIG_TYPE, CONFIG_TYPE_USER);
            RestConfig rc = RestConfig.USER;
            rc.setJerseyLibSelected(false);
            rc.setServerJerseyLibSelected(false);
            return rc;
        }
        return RestConfig.USER;
    }

    protected void addJerseySpringJar() throws IOException {
        File[] jerseyJars;
        File jerseyRoot;
        ClassPath cp;
        FileObject srcRoot = this.findSourceRoot();
        if (srcRoot != null && ((cp = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/compile")) == null || cp.findResource("com/sun/jersey/api/spring/Autowire.class") == null) && (jerseyRoot = InstalledFileLocator.getDefault().locate("modules/ext/rest", null, false)) != null && jerseyRoot.isDirectory() && (jerseyJars = jerseyRoot.listFiles(new RestSupport.JerseyFilter(JERSEY_SPRING_JAR_PATTERN))) != null && jerseyJars.length > 0) {
            URL url = FileUtil.getArchiveRoot((URL)jerseyJars[0].toURI().toURL());
            ProjectClassPathModifier.addRoots((URL[])new URL[]{url}, (FileObject)srcRoot, (String)"classpath/compile");
        }
    }

    @Override
    public int getProjectType() {
        return 1;
    }

    private String getPackagesList(Iterable<String> packs) {
        StringBuilder builder = new StringBuilder();
        for (String pack : packs) {
            builder.append(pack);
            builder.append(';');
        }
        String packages = builder.length() > 0 ? builder.substring(0, builder.length() - 1) : builder.toString();
        return packages;
    }

    private String getPackagesList(String[] packs) {
        return this.getPackagesList(Arrays.asList(packs));
    }

    private InitParam createJerseyPackagesInitParam(Servlet adaptorServlet, String ... packs) throws ClassNotFoundException {
        return this.createInitParam(adaptorServlet, JERSEY_PROP_PACKAGES, this.getPackagesList(packs), JERSEY_PROP_PACKAGES_DESC);
    }

    private InitParam createInitParam(Servlet adaptorServlet, String name, String value, String description) throws ClassNotFoundException {
        InitParam initParam = (InitParam)adaptorServlet.createBean("InitParam");
        initParam.setParamName(name);
        initParam.setParamValue(value);
        if (description != null) {
            initParam.setDescription(description);
        }
        return initParam;
    }

    protected void reconfigApplicationClass(final String appClassFqn) {
        this.scheduleReconfigAppClass(appClassFqn);
        if (this.restModelListener == null) {
            this.restModelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    WebRestSupport.this.scheduleReconfigAppClass(appClassFqn);
                }
            };
            this.addModelListener(this.restModelListener);
        }
    }

    private void scheduleReconfigAppClass(final String fqn) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    WebRestSupport.this.doReconfigApplicationClass(fqn);
                }
                catch (IOException e) {
                    Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
                }
            }
        };
        this.REST_APP_MODIFICATION_RP.post(runnable);
    }

    protected void doReconfigApplicationClass(String appClassFqn) throws IOException {
        SaveCookie cookie;
        JavaSource javaSource = this.getJavaSourceFromClassName(appClassFqn);
        if (javaSource == null) {
            return;
        }
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                CompilationUnitTree tree = workingCopy.getCompilationUnit();
                for (Tree tree2 : tree.getTypeDecls()) {
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree2.getKind())) continue;
                    MethodTree getClasses = null;
                    MethodTree restResources = null;
                    ClassTree classTree = (ClassTree)tree2;
                    List<? extends Tree> members = classTree.getMembers();
                    for (Tree tree3 : members) {
                        if (!tree3.getKind().equals((Object)Tree.Kind.METHOD)) continue;
                        MethodTree method = (MethodTree)tree3;
                        String name = method.getName().toString();
                        if (name.equals(WebRestSupport.GET_CLASSES)) {
                            getClasses = method;
                            continue;
                        }
                        if (!name.equals(WebRestSupport.GET_REST_RESOURCE_CLASSES)) continue;
                        restResources = method;
                    }
                    TreeMaker maker = workingCopy.getTreeMaker();
                    ClassTree classTree4 = classTree;
                    classTree4 = WebRestSupport.this.removeResourcesMethod(restResources, maker, classTree4);
                    classTree4 = WebRestSupport.this.createMethods(getClasses, maker, classTree4, restResources == null, (CompilationController)workingCopy);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree4);
                }
            }
        }).commit();
        Collection files = javaSource.getFileObjects();
        if (files.isEmpty()) {
            return;
        }
        FileObject fileObject = (FileObject)files.iterator().next();
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (dataObject != null && (cookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    protected FileObject getFileObjectFromClassName(String qualifiedClassName) throws IOException {
        int beginIndex;
        String simple;
        FileObject root = this.findSourceRoot();
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)root);
        ClassIndex ci = cpInfo.getClassIndex();
        Set handles = ci.getDeclaredTypes(simple = qualifiedClassName.substring(beginIndex = qualifiedClassName.lastIndexOf(46) + 1), ClassIndex.NameKind.SIMPLE_NAME, Collections.singleton(ClassIndex.SearchScope.SOURCE));
        if (handles == null) {
            return null;
        }
        for (ElementHandle handle : handles) {
            if (!qualifiedClassName.equals(handle.getQualifiedName())) continue;
            return SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)cpInfo);
        }
        return null;
    }

    protected JavaSource getJavaSourceFromClassName(String qualifiedClassName) throws IOException {
        FileObject fo = this.getFileObjectFromClassName(qualifiedClassName);
        if (fo != null) {
            return JavaSource.forFileObject((FileObject)fo);
        }
        return null;
    }

    private void configRestPackages(String ... packs) throws IOException {
        try {
            InitParam initParam;
            this.addResourceConfigToWebApp("/webresources/*");
            FileObject ddFO = this.getWebXml();
            WebApp webApp = this.getWebApp();
            if (webApp == null) {
                return;
            }
            if (webApp.getStatus() == 2 || webApp.getStatus() == 3) {
                return;
            }
            boolean needsSave = false;
            Servlet adaptorServlet = this.getRestServletAdaptor(webApp);
            if (adaptorServlet == null) {
                return;
            }
            InitParam[] initParams = adaptorServlet.getInitParam();
            boolean jerseyParamFound = false;
            boolean jacksonParamFound = false;
            for (InitParam initParam2 : initParams) {
                String paramValue;
                if (initParam2.getParamName().equals(JERSEY_PROP_PACKAGES)) {
                    jerseyParamFound = true;
                    paramValue = initParam2.getParamValue();
                    paramValue = paramValue != null ? paramValue.trim() : "";
                    if (paramValue.length() == 0 || paramValue.equals(".")) {
                        initParam2.setParamValue(this.getPackagesList(packs));
                        needsSave = true;
                        continue;
                    }
                    String[] existed = paramValue.split(";");
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    set.addAll(Arrays.asList(existed));
                    set.addAll(Arrays.asList(packs));
                    initParam2.setParamValue(this.getPackagesList(set));
                    needsSave = existed.length != set.size();
                    continue;
                }
                if (!initParam2.getParamName().equals(POJO_MAPPING_FEATURE)) continue;
                jacksonParamFound = true;
                paramValue = initParam2.getParamValue();
                if (paramValue != null) {
                    paramValue = paramValue.trim();
                }
                if (Boolean.TRUE.toString().equals(paramValue)) continue;
                initParam2.setParamValue(Boolean.TRUE.toString());
                needsSave = true;
            }
            if (!jerseyParamFound) {
                initParam = this.createJerseyPackagesInitParam(adaptorServlet, packs);
                adaptorServlet.addInitParam(initParam);
                needsSave = true;
            }
            if (!jacksonParamFound) {
                initParam = this.createInitParam(adaptorServlet, POJO_MAPPING_FEATURE, Boolean.TRUE.toString(), null);
                adaptorServlet.addInitParam(initParam);
                needsSave = true;
            }
            if (needsSave) {
                webApp.write(ddFO);
                this.logResourceCreation(this.project);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ClassTree removeResourcesMethod(MethodTree restResources, TreeMaker maker, ClassTree modified) {
        return maker.removeClassMember(modified, (Tree)restResources);
    }

    private ClassTree createMethods(MethodTree getClasses, TreeMaker maker, ClassTree modified, boolean addComment, CompilationController controller) throws IOException {
        WildcardTree wildCard = maker.Wildcard(Tree.Kind.UNBOUNDED_WILDCARD, null);
        ParameterizedTypeTree wildClass = maker.ParameterizedType((Tree)maker.QualIdent(Class.class.getCanonicalName()), Collections.singletonList(wildCard));
        ParameterizedTypeTree wildSet = maker.ParameterizedType((Tree)maker.QualIdent(Set.class.getCanonicalName()), Collections.singletonList(wildClass));
        if (getClasses == null) {
            ModifiersTree modifiersTree = maker.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(maker.Annotation((Tree)maker.QualIdent(Override.class.getCanonicalName()), Collections.emptyList())));
            MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)GET_CLASSES, (Tree)wildSet, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{return getRestResourceClasses();}", null);
            modified = maker.addClassMember(modified, (Tree)methodTree);
        }
        StringBuilder builder = new StringBuilder();
        this.collectRestResources(builder, controller);
        ModifiersTree modifiersTree = maker.Modifiers(EnumSet.of(Modifier.PRIVATE));
        MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)GET_REST_RESOURCE_CLASSES, (Tree)wildSet, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), builder.toString(), null);
        if (addComment) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)"Do not modify this method. It is automatically generated by NetBeans REST support.");
            maker.addComment((Tree)methodTree, comment, true);
        }
        modified = maker.addClassMember(modified, (Tree)methodTree);
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectRestResources(final StringBuilder builder, final CompilationController controller) throws IOException {
        builder.append('{');
        builder.append("Set<Class<?>> resources = new java.util.HashSet<Class<?>>();");
        RestServicesModel model = this.getRestServicesModel();
        try {
            model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata metadata) throws Exception {
                    RestServiceDescription[] descriptions;
                    RestServices services = metadata.getRoot();
                    for (RestServiceDescription description : descriptions = services.getRestServiceDescription()) {
                        FileObject file;
                        String className = description.getClassName();
                        TypeElement typeElement = controller.getElements().getTypeElement(className);
                        if (typeElement != null && (file = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)controller.getClasspathInfo())) == null) continue;
                        builder.append("resources.add(");
                        builder.append(className);
                        builder.append(".class);");
                    }
                    builder.append(WebRestSupport.this.getJacksonProviderSnippet());
                    return null;
                }
            });
        }
        catch (MetadataModelException e) {
            Logger.getLogger(WebRestSupport.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
        }
        finally {
            builder.append("return resources;");
            builder.append('}');
        }
    }

    private String getJacksonProviderSnippet() {
        JaxRsStackSupport support;
        boolean addJacksonProvider = this.hasResource("org/codehaus/jackson/jaxrs/JacksonJsonProvider.class");
        if (!addJacksonProvider && (support = this.getJaxRsStackSupport()) != null) {
            addJacksonProvider = support.isBundled(JACKSON_JSON_PROVIDER);
        }
        StringBuilder builder = new StringBuilder();
        if (addJacksonProvider) {
            builder.append("try {");
            builder.append("Class<?> jacksonProvider = Class.forName(");
            builder.append('\"');
            builder.append(JACKSON_JSON_PROVIDER);
            builder.append("\");");
            builder.append("resources.add(jacksonProvider);");
            builder.append("} catch (ClassNotFoundException ex) {");
            builder.append("java.util.logging.Logger.getLogger(getClass().getName())");
            builder.append(".log(java.util.logging.Level.SEVERE, null, ex);}");
            return builder.toString();
        }
        return builder.toString();
    }

    public static enum RestConfig {
        IDE,
        USER,
        DD;

        private String resourcePath;
        private boolean jerseyLibSelected;
        private boolean serverJerseyLibSelected;

        public boolean isJerseyLibSelected() {
            return this.jerseyLibSelected;
        }

        public void setJerseyLibSelected(boolean jerseyLibSelected) {
            this.jerseyLibSelected = jerseyLibSelected;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public void setResourcePath(String reseourcePath) {
            this.resourcePath = reseourcePath;
        }

        public void setServerJerseyLibSelected(boolean isSelected) {
            this.serverJerseyLibSelected = isSelected;
        }

        public boolean isServerJerseyLibSelected() {
            return this.serverJerseyLibSelected;
        }
    }
}

