/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportProvider;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.model.spi.RestServicesMetadataModelFactory;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public abstract class RestSupport {
    public static final String SWDP_LIBRARY = "restlib";
    public static final String RESTAPI_LIBRARY = "restapi";
    protected static final String GFV3_RESTLIB = "restlib_gfv3ee6";
    protected static final String GFV31_RESTLIB = "restlib_gfv31ee6";
    public static final String PROP_SWDP_CLASSPATH = "libs.swdp.classpath";
    public static final String PROP_RESTBEANS_TEST_DIR = "restbeans.test.dir";
    public static final String PROP_RESTBEANS_TEST_FILE = "restbeans.test.file";
    public static final String PROP_RESTBEANS_TEST_URL = "restbeans.test.url";
    public static final String PROP_BASE_URL_TOKEN = "base.url.token";
    public static final String PROP_APPLICATION_PATH = "rest.application.path";
    public static final String BASE_URL_TOKEN = "___BASE_URL___";
    public static final String RESTBEANS_TEST_DIR = "build/generated-sources/rest-test";
    public static final String COMMAND_TEST_RESTBEANS = "test-restbeans";
    public static final String COMMAND_DEPLOY = "run-deploy";
    public static final String TEST_RESBEANS = "test-resbeans";
    public static final String TEST_RESBEANS_HTML = "test-resbeans.html";
    public static final String TEST_RESBEANS_JS = "test-resbeans.js";
    public static final String TEST_RESBEANS_CSS = "test-resbeans.css";
    public static final String TEST_RESBEANS_CSS2 = "css_master-all.css";
    public static final String REST_SERVLET_ADAPTOR = "ServletAdaptor";
    public static final String REST_SERVLET_ADAPTOR_CLASS = "com.sun.jersey.spi.container.servlet.ServletContainer";
    public static final String REST_SERVLET_ADAPTOR_CLASS_OLD = "com.sun.ws.rest.impl.container.servlet.ServletAdaptor";
    public static final String REST_SPRING_SERVLET_ADAPTOR_CLASS = "com.sun.jersey.spi.spring.container.servlet.SpringServlet";
    public static final String REST_SERVLET_ADAPTOR_MAPPING = "/resources/*";
    public static final String PARAM_WEB_RESOURCE_CLASS = "webresourceclass";
    public static final String WEB_RESOURCE_CLASS = "webresources.WebResources";
    public static final String REST_API_JAR = "jsr311-api.jar";
    public static final String REST_RI_JAR = "jersey";
    public static final String IGNORE_PLATFORM_RESTLIB = "restlib.ignore.platform";
    public static final String JSR311_JAR_PATTERN = "jsr311-api.*\\.jar";
    public static final String JERSEY_API_LOCATION = "modules/ext/rest";
    public static final String JTA_USER_TRANSACTION_CLASS = "javax/transaction/UserTransaction.class";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String TOMCAT_SERVER_TYPE = "tomcat";
    public static final String GFV3_SERVER_TYPE = "gfv3";
    public static final String GFV2_SERVER_TYPE = "J2EE";
    public static final int PROJECT_TYPE_DESKTOP = 0;
    public static final int PROJECT_TYPE_WEB = 1;
    public static final int PROJECT_TYPE_NB_MODULE = 2;
    private AntProjectHelper helper;
    private AtomicReference<RestServicesModel> restServicesModel;
    private AtomicReference<RestApplicationModel> restApplicationModel;
    private List<PropertyChangeListener> modelListeners = new ArrayList<PropertyChangeListener>();
    protected final Project project;

    public RestSupport(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Null project");
        }
        this.project = project;
        this.restServicesModel = new AtomicReference();
        this.restApplicationModel = new AtomicReference();
    }

    public abstract void upgrade();

    public abstract void ensureRestDevelopmentReady() throws IOException;

    public abstract void removeRestDevelopmentReadiness() throws IOException;

    public abstract boolean isReady();

    public abstract FileObject getPersistenceXml();

    public abstract Datasource getDatasource(String var1);

    public FileObject findSourceRoot() {
        return RestSupport.findSourceRoot(this.getProject());
    }

    public static FileObject findSourceRoot(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups != null && sourceGroups.length > 0) {
            return sourceGroups[0].getRootFolder();
        }
        return null;
    }

    private static ClassPath getClassPath(Project project, String type) {
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        ArrayList<ClassPath> classPaths = new ArrayList<ClassPath>(sourceGroups.length);
        for (SourceGroup sourceGroup : sourceGroups) {
            String sourceGroupId = sourceGroup.getName();
            if (sourceGroupId != null && sourceGroupId.contains("test")) continue;
            FileObject rootFolder = sourceGroup.getRootFolder();
            ClassPath path = provider.findClassPath(rootFolder, type);
            classPaths.add(path);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])classPaths.toArray(new ClassPath[classPaths.size()]));
    }

    public void addModelListener(PropertyChangeListener listener) {
        this.modelListeners.add(listener);
        RestServicesModel model = this.restServicesModel.get();
        if (model != null) {
            model.addPropertyChangeListener(listener);
        }
    }

    public void removeModelListener(PropertyChangeListener listener) {
        this.modelListeners.remove(listener);
        RestServicesModel model = this.restServicesModel.get();
        if (model != null) {
            model.removePropertyChangeListener(listener);
        }
    }

    public RestServicesModel getRestServicesModel() {
        ClassPathProvider cpProvider;
        FileObject sourceRoot = this.findSourceRoot();
        if (this.restServicesModel.get() == null && sourceRoot != null && (cpProvider = (ClassPathProvider)this.getProject().getLookup().lookup(ClassPathProvider.class)) != null) {
            MetadataUnit metadataUnit;
            RestServicesModel model;
            ClassPath compileCP = cpProvider.findClassPath(sourceRoot, "classpath/compile");
            ClassPath bootCP = cpProvider.findClassPath(sourceRoot, "classpath/boot");
            ClassPath sourceCP = cpProvider.findClassPath(sourceRoot, "classpath/source");
            if (compileCP != null && bootCP != null && this.restServicesModel.compareAndSet(null, model = RestServicesMetadataModelFactory.createMetadataModel(metadataUnit = MetadataUnit.create((ClassPath)bootCP, (ClassPath)RestSupport.extendWithJsr311Api(compileCP), (ClassPath)sourceCP, null), this.project))) {
                for (PropertyChangeListener pcl : this.modelListeners) {
                    model.addPropertyChangeListener(pcl);
                }
            }
        }
        return this.restServicesModel.get();
    }

    public RestApplicationModel getRestApplicationsModel() {
        FileObject sourceRoot = this.findSourceRoot();
        if (this.restApplicationModel.get() == null && sourceRoot != null) {
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)RestSupport.getClassPath(this.getProject(), "classpath/boot"), (ClassPath)RestSupport.getClassPath(this.getProject(), "classpath/compile"), (ClassPath)RestSupport.getClassPath(this.getProject(), "classpath/source"), null);
            RestApplicationModel model = RestServicesMetadataModelFactory.createApplicationMetadataModel(metadataUnit, this.project);
            this.restApplicationModel.compareAndSet(null, model);
        }
        return this.restApplicationModel.get();
    }

    protected void refreshRestServicesMetadataModel() {
        RestServicesModel model = this.restServicesModel.get();
        if (model != null) {
            for (PropertyChangeListener pcl : this.modelListeners) {
                model.removePropertyChangeListener(pcl);
            }
            this.restServicesModel.compareAndSet(model, null);
        }
        try {
            model = this.getRestServicesModel();
            if (model != null) {
                model.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                    public Void run(RestServicesMetadata metadata) throws IOException {
                        metadata.getRoot().sizeRestServiceDescription();
                        return null;
                    }
                });
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
    }

    public static ClassPath extendWithJsr311Api(ClassPath classPath) {
        File[] jsr311Jars;
        File jerseyRoot = InstalledFileLocator.getDefault().locate(JERSEY_API_LOCATION, "org.netbeans.modules.websvc.restlib", false);
        if (jerseyRoot != null && jerseyRoot.isDirectory() && (jsr311Jars = jerseyRoot.listFiles(new JerseyFilter(JSR311_JAR_PATTERN))) != null && jsr311Jars.length > 0) {
            return RestSupport.extendClassPath(classPath, jsr311Jars[0]);
        }
        return classPath;
    }

    public static ClassPath extendClassPath(ClassPath classPath, File path) {
        if (path == null) {
            return classPath;
        }
        try {
            PathResourceImplementation jsr311Path = RestSupport.getPathResource(path);
            ArrayList<PathResourceImplementation> roots = new ArrayList<PathResourceImplementation>();
            roots.add(jsr311Path);
            for (FileObject fo : classPath.getRoots()) {
                roots.add(ClassPathSupport.createResource((URL)fo.getURL()));
            }
            return ClassPathSupport.createClassPath(roots);
        }
        catch (Exception ex) {
            return classPath;
        }
    }

    private static PathResourceImplementation getPathResource(File path) throws MalformedURLException {
        URL url = path.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        } else {
            url = path.toURI().toURL();
            String surl = url.toExternalForm();
            if (!surl.endsWith("/")) {
                url = new URL(surl + "/");
            }
        }
        return ClassPathSupport.createResource((URL)url);
    }

    public abstract FileObject generateTestClient(File var1, String var2) throws IOException;

    public FileObject generateTestClient(File testdir) throws IOException {
        if (!testdir.isDirectory()) {
            FileUtil.createFolder((File)testdir);
        }
        String[] replaceKeys1 = new String[]{"TTL_TEST_RESBEANS", "MSG_TEST_RESBEANS_INFO"};
        String[] replaceKeys2 = new String[]{"MSG_TEST_RESBEANS_wadlErr", "MSG_TEST_RESBEANS_No_AJAX", "MSG_TEST_RESBEANS_Resource", "MSG_TEST_RESBEANS_See", "MSG_TEST_RESBEANS_No_Container", "MSG_TEST_RESBEANS_Content", "MSG_TEST_RESBEANS_TabularView", "MSG_TEST_RESBEANS_RawView", "MSG_TEST_RESBEANS_ResponseHeaders", "MSG_TEST_RESBEANS_Help", "MSG_TEST_RESBEANS_TestButton", "MSG_TEST_RESBEANS_Loading", "MSG_TEST_RESBEANS_Status", "MSG_TEST_RESBEANS_Headers", "MSG_TEST_RESBEANS_HeaderName", "MSG_TEST_RESBEANS_HeaderValue", "MSG_TEST_RESBEANS_Insert", "MSG_TEST_RESBEANS_NoContents", "MSG_TEST_RESBEANS_AddParamButton", "MSG_TEST_RESBEANS_Monitor", "MSG_TEST_RESBEANS_No_SubResources", "MSG_TEST_RESBEANS_SubResources", "MSG_TEST_RESBEANS_ChooseMethod", "MSG_TEST_RESBEANS_ChooseMime", "MSG_TEST_RESBEANS_Continue", "MSG_TEST_RESBEANS_AdditionalParams", "MSG_TEST_RESBEANS_INFO", "MSG_TEST_RESBEANS_Request", "MSG_TEST_RESBEANS_Sent", "MSG_TEST_RESBEANS_Received", "MSG_TEST_RESBEANS_TimeStamp", "MSG_TEST_RESBEANS_Response", "MSG_TEST_RESBEANS_CurrentSelection", "MSG_TEST_RESBEANS_DebugWindow", "MSG_TEST_RESBEANS_Wadl", "MSG_TEST_RESBEANS_RequestFailed", "MSG_TEST_RESBEANS_NoContent"};
        FileObject testFO = RestSupport.copyFile(testdir, TEST_RESBEANS_HTML, replaceKeys1, true);
        RestSupport.copyFile(testdir, TEST_RESBEANS_JS, replaceKeys2, false);
        RestSupport.copyFile(testdir, TEST_RESBEANS_CSS);
        RestSupport.copyFile(testdir, TEST_RESBEANS_CSS2);
        RestSupport.copyFile(testdir, "expand.gif");
        RestSupport.copyFile(testdir, "collapse.gif");
        RestSupport.copyFile(testdir, "item.gif");
        RestSupport.copyFile(testdir, "cc.gif");
        RestSupport.copyFile(testdir, "og.gif");
        RestSupport.copyFile(testdir, "cg.gif");
        RestSupport.copyFile(testdir, "app.gif");
        File testdir2 = new File(testdir, "images");
        testdir2.mkdir();
        RestSupport.copyFile(testdir, "images/background_border_bottom.gif");
        RestSupport.copyFile(testdir, "images/pbsel.png");
        RestSupport.copyFile(testdir, "images/bg_gradient.gif");
        RestSupport.copyFile(testdir, "images/pname.png");
        RestSupport.copyFile(testdir, "images/level1_deselect.jpg");
        RestSupport.copyFile(testdir, "images/level1_selected-1lvl.jpg");
        RestSupport.copyFile(testdir, "images/primary-enabled.gif");
        RestSupport.copyFile(testdir, "images/masthead.png");
        RestSupport.copyFile(testdir, "images/masthead_link_enabled.gif");
        RestSupport.copyFile(testdir, "images/masthead_link_roll.gif");
        RestSupport.copyFile(testdir, "images/primary-roll.gif");
        RestSupport.copyFile(testdir, "images/pbdis.png");
        RestSupport.copyFile(testdir, "images/secondary-enabled.gif");
        RestSupport.copyFile(testdir, "images/pbena.png");
        RestSupport.copyFile(testdir, "images/tbsel.png");
        RestSupport.copyFile(testdir, "images/pbmou.png");
        RestSupport.copyFile(testdir, "images/tbuns.png");
        return testFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject copyFile(File testdir, String name, String[] replaceKeys, boolean overwrite) throws IOException {
        FileObject dir = FileUtil.toFileObject((File)testdir);
        FileObject fo = dir.getFileObject(name);
        if (fo == null) {
            fo = dir.createData(name);
        } else if (!overwrite) {
            return fo;
        }
        FileLock lock = null;
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            int i;
            lock = fo.lock();
            OutputStream os = fo.getOutputStream(lock);
            writer = new BufferedWriter(new OutputStreamWriter(os, Charset.forName("UTF-8")));
            InputStream is = RestSupport.class.getResourceAsStream("resources/" + name);
            reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String lineSep = "\n";
            if (File.separatorChar == '\\') {
                lineSep = "\r\n";
            }
            String[] replaceValues = null;
            if (replaceKeys != null) {
                replaceValues = new String[replaceKeys.length];
                for (i = 0; i < replaceKeys.length; ++i) {
                    replaceValues[i] = NbBundle.getMessage(RestSupport.class, (String)replaceKeys[i]);
                }
            }
            while ((line = reader.readLine()) != null) {
                for (i = 0; i < replaceKeys.length; ++i) {
                    line = line.replaceAll(replaceKeys[i], replaceValues[i]);
                }
                writer.write(line);
                writer.write(lineSep);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject modifyFile(FileObject fo, Map<String, String> replace) throws IOException {
        StringWriter content = new StringWriter();
        FileLock lock = null;
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            writer = new BufferedWriter(content);
            InputStream is = fo.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String lineSep = "\n";
            if (File.separatorChar == '\\') {
                lineSep = "\r\n";
            }
            while ((line = reader.readLine()) != null) {
                for (Map.Entry<String, String> entry : replace.entrySet()) {
                    line = line.replaceAll(entry.getKey(), entry.getValue());
                }
                writer.write(line);
                writer.write(lineSep);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            StringBuffer buffer = content.getBuffer();
            lock = fo.lock();
            try {
                OutputStream outputStream = fo.getOutputStream(lock);
                writer = new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8")));
                writer.write(buffer.toString());
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File testdir, String name) throws IOException {
        String path = "resources/" + name;
        File df = new File(testdir, name);
        if (!df.exists()) {
            InputStream is = null;
            OutputStream os = null;
            try {
                int c;
                is = RestSupport.class.getResourceAsStream(path);
                os = new FileOutputStream(df);
                while ((c = is.read()) != -1) {
                    os.write(c);
                }
            }
            finally {
                if (os != null) {
                    os.flush();
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    public void removeSwdpLibrary(String[] classPathTypes) throws IOException {
        JaxRsStackSupport support = JaxRsStackSupport.getDefault();
        if (support != null) {
            support.removeJaxRsLibraries(this.project);
        }
        JaxRsStackSupport.getDefault().removeJaxRsLibraries(this.project);
    }

    public Project getProject() {
        return this.project;
    }

    public boolean hasSwdpLibrary() {
        return this.hasResource(REST_SERVLET_ADAPTOR_CLASS.replace('.', '/') + ".class");
    }

    public abstract boolean isRestSupportOn();

    public void setProjectProperty(String name, String value) {
        this.setProjectProperty(name, value, "nbproject/project.properties");
    }

    public void setPrivateProjectProperty(String name, String value) {
        this.setProjectProperty(name, value, "nbproject/private/private.properties");
    }

    public String getProjectProperty(String name) {
        if (this.getAntProjectHelper() == null) {
            return null;
        }
        return this.helper.getStandardPropertyEvaluator().getProperty(name);
    }

    public void removeProjectProperties(final String[] propertyNames) {
        if (this.getAntProjectHelper() == null) {
            return;
        }
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    try {
                        RestSupport.this.removeProperty(propertyNames, "nbproject/project.properties");
                        RestSupport.this.removeProperty(propertyNames, "nbproject/private/private.properties");
                        ProjectManager.getDefault().saveProject(RestSupport.this.getProject());
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
    }

    protected boolean ignorePlatformRestLibrary() {
        String v = this.getProjectProperty(IGNORE_PLATFORM_RESTLIB);
        Boolean ignore = v != null ? Boolean.valueOf(v) : true;
        return ignore == false;
    }

    public AntProjectHelper getAntProjectHelper() {
        JAXWSSupport support;
        JAXWSSupportProvider provider;
        if (this.helper == null && (provider = (JAXWSSupportProvider)this.project.getLookup().lookup(JAXWSSupportProvider.class)) != null && (support = provider.findJAXWSSupport(this.project.getProjectDirectory())) != null) {
            this.helper = support.getAntProjectHelper();
        }
        return this.helper;
    }

    public boolean hasJTASupport() {
        return this.hasResource(JTA_USER_TRANSACTION_CLASS);
    }

    public boolean hasSpringSupport() {
        return this.hasResource("org/springframework/transaction/annotation/Transactional.class");
    }

    public String getServerType() {
        return this.getProjectProperty(J2EE_SERVER_TYPE);
    }

    public boolean isServerTomcat() {
        String serverType = this.getServerType();
        if (serverType != null) {
            return serverType.toLowerCase().contains(TOMCAT_SERVER_TYPE);
        }
        return false;
    }

    public boolean isServerGFV3() {
        if (this.getServerType() == null) {
            return false;
        }
        return this.getServerType().startsWith(GFV3_SERVER_TYPE);
    }

    public boolean isServerGFV2() {
        return GFV2_SERVER_TYPE.equals(this.getServerType());
    }

    public String getApplicationPath() throws IOException {
        return "webresources";
    }

    public FileObject getApplicationContextXml() {
        FileObject configRoot;
        FileObject webInf;
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        FileObject[] fobjs = provider.getSourceRoots();
        if (fobjs.length > 0 && (webInf = (configRoot = fobjs[0]).getFileObject("WEB-INF")) != null) {
            return webInf.getFileObject("applicationContext", "xml");
        }
        return null;
    }

    public abstract File getLocalTargetTestRest();

    public abstract String getBaseURL() throws IOException;

    public abstract void deploy() throws IOException;

    public String getContextRootURL() {
        String portNumber = "8080";
        String host = "localhost";
        String contextRoot = "";
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        Deployment.getDefault().getServerInstance(provider.getServerInstanceID());
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RestSupport.class, (String)"MSG_MissingServer"), 0));
        } else {
            ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
            try {
                ServerInstance.Descriptor instanceDescriptor = serverInstance.getDescriptor();
                if (instanceDescriptor != null) {
                    String hostName;
                    int port = instanceDescriptor.getHttpPort();
                    if (port > 0) {
                        portNumber = String.valueOf(port);
                    }
                    if ((hostName = instanceDescriptor.getHostname()) != null) {
                        host = hostName;
                    }
                }
            }
            catch (InstanceRemovedException ex) {
                // empty catch block
            }
        }
        J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
        try {
            contextRoot = configSupport.getWebContextRoot();
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        if (contextRoot.length() > 0 && contextRoot.startsWith("/")) {
            contextRoot = contextRoot.substring(1);
        }
        return "http://" + host + ":" + portNumber + "/" + (contextRoot.length() > 0 ? contextRoot + "/" : "");
    }

    protected boolean hasResource(String resource) {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sgs.length < 1) {
            return false;
        }
        FileObject sourceRoot = sgs[0].getRootFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceRoot, (String)"classpath/compile");
        if (classPath == null) {
            return false;
        }
        FileObject resourceFile = classPath.findResource(resource);
        return resourceFile != null;
    }

    public abstract void configure(String ... var1) throws IOException;

    public abstract int getProjectType();

    private ClassPath getCompileClassPath(SourceGroup[] groups) {
        ClassPathProvider provider = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        ClassPath[] paths = new ClassPath[groups.length];
        int i = 0;
        for (SourceGroup sourceGroup : groups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, "classpath/compile");
            ++i;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])paths);
    }

    private boolean contains(ClassPath classPath, URL url) {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            return false;
        }
        List entries = classPath.entries();
        for (ClassPath.Entry entry : entries) {
            try {
                if (!entry.getURL().toURI().equals(uri)) continue;
                return true;
            }
            catch (URISyntaxException ignore) {
            }
        }
        return false;
    }

    private void setProjectProperty(final String name, final String value, final String propertyPath) {
        if (this.getAntProjectHelper() == null) {
            return;
        }
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    try {
                        EditableProperties ep = RestSupport.this.helper.getProperties(propertyPath);
                        ep.setProperty(name, value);
                        RestSupport.this.helper.putProperties(propertyPath, ep);
                        ProjectManager.getDefault().saveProject(RestSupport.this.getProject());
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
    }

    private void removeProperty(String[] propertyNames, String propertiesPath) {
        EditableProperties ep = this.helper.getProperties(propertiesPath);
        for (String name : propertyNames) {
            ep.remove((Object)name);
        }
        this.helper.putProperties(propertiesPath, ep);
    }

    protected static class JerseyFilter
    implements FileFilter {
        private Pattern pattern;

        JerseyFilter(String regexp) {
            this.pattern = Pattern.compile(regexp);
        }

        @Override
        public boolean accept(File pathname) {
            return this.pattern.matcher(pathname.getName()).matches();
        }
    }
}

