/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ApplicationConfigPanel
extends JPanel {
    private ButtonGroup buttonGroup1;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JSeparator jSeparator1;
    private JTextField jTextField1;

    public ApplicationConfigPanel(String configType, String resourcesPath, boolean isJerseyLib, boolean annotationConfigAvailable, boolean hasServerJerseyLibrary, String jerseyConfig) {
        this.initComponents();
        if (!annotationConfigAvailable) {
            this.jRadioButton1.setVisible(false);
        }
        if ("server".equals(jerseyConfig)) {
            this.jComboBox1.setSelectedIndex(0);
        } else if ("ide".equals(jerseyConfig)) {
            this.jComboBox1.setSelectedIndex(1);
        }
        if (!isJerseyLib) {
            this.jCheckBox1.setSelected(false);
        }
        if ("ide".equals(configType)) {
            if (annotationConfigAvailable) {
                this.jRadioButton1.setSelected(true);
            } else {
                this.jRadioButton3.setSelected(true);
            }
            if (!isJerseyLib) {
                this.jCheckBox1.setSelected(false);
            }
        } else if ("user".equals(configType)) {
            this.jRadioButton2.setSelected(true);
            this.jTextField1.setEnabled(false);
        } else {
            this.jRadioButton3.setSelected(true);
        }
        this.jTextField1.setText(resourcesPath);
        this.jLabel3.setVisible(hasServerJerseyLibrary);
        this.jComboBox1.setVisible(hasServerJerseyLibrary);
        this.addListeners();
    }

    public ApplicationConfigPanel(boolean annotationConfigAvailable, boolean hasServerJerseyLibrary) {
        this.initComponents();
        if (!annotationConfigAvailable) {
            this.jRadioButton1.setVisible(false);
            this.jRadioButton3.setSelected(true);
        }
        this.jLabel3.setVisible(hasServerJerseyLibrary);
        this.jComboBox1.setVisible(hasServerJerseyLibrary);
        this.addListeners();
    }

    private void addListeners() {
        MyItemListener l = new MyItemListener();
        this.jRadioButton1.addItemListener(l);
        this.jRadioButton2.addItemListener(l);
        this.jRadioButton3.addItemListener(l);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = ApplicationConfigPanel.this.jCheckBox1.isSelected();
                ApplicationConfigPanel.this.jLabel3.setEnabled(enable);
                ApplicationConfigPanel.this.jComboBox1.setEnabled(enable);
            }
        };
        if (this.jComboBox1.isVisible()) {
            this.jCheckBox1.addActionListener(listener);
        }
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Point location = ApplicationConfigPanel.this.jTextField1.getLocation();
                double bottomY = location.getY() + (double)ApplicationConfigPanel.this.jTextField1.getHeight();
                location = ApplicationConfigPanel.this.jLabel2.getLocation();
                double topY = location.getY();
                Dimension dim = ApplicationConfigPanel.this.getPreferredSize();
                int newHeight = (int)(bottomY += topY);
                if (dim.height < newHeight) {
                    ApplicationConfigPanel.this.setPreferredSize(new Dimension(dim.width, newHeight));
                }
            }
        });
    }

    private ComboBoxModel getSourceModel() {
        String serverLibrary = NbBundle.getMessage(ApplicationConfigPanel.class, (String)"TXT_UseServerLibrary");
        String nbLibrary = NbBundle.getMessage(ApplicationConfigPanel.class, (String)"TXT_UseNbLibrary");
        Object[] items = new Object[]{serverLibrary, nbLibrary};
        return new DefaultComboBoxModel<Object>(items);
    }

    public String getConfigType() {
        if (this.jRadioButton1.isSelected()) {
            return "ide";
        }
        if (this.jRadioButton2.isSelected()) {
            return "user";
        }
        return "dd";
    }

    public boolean isJerseyLibSelected() {
        if (!this.jCheckBox1.isSelected()) {
            return false;
        }
        if (!this.jComboBox1.isVisible()) {
            return true;
        }
        return this.jComboBox1.getSelectedIndex() == 1;
    }

    public boolean isServerJerseyLibSelected() {
        boolean visible = this.jComboBox1.isVisible();
        if (!visible || !this.jCheckBox1.isSelected()) {
            return false;
        }
        return this.jComboBox1.getSelectedIndex() == 0;
    }

    public String getApplicationPath() {
        return this.jTextField1.getText().trim();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jPanel1 = new JPanel();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton1 = new JRadioButton();
        this.jCheckBox1 = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1.setLabelFor(this.jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jLabel1.text"));
        this.jTextField1.setText(NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jTextField1.text"));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.buttonGroup1.add(this.jRadioButton3);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton3, (String)NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jRadioButton3.text"));
        this.jRadioButton3.setVerticalTextPosition(1);
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jRadioButton2.text"));
        this.jRadioButton2.setVerticalTextPosition(1);
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jRadioButton1.text"));
        this.jRadioButton1.setAutoscrolls(true);
        this.jRadioButton1.setVerifyInputWhenFocusTarget(false);
        this.jRadioButton1.setVerticalTextPosition(1);
        this.jCheckBox1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jCheckBox1.text"));
        this.jComboBox1.setModel(this.getSourceModel());
        this.jLabel3.setLabelFor(this.jComboBox1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ApplicationConfigPanel.class, (String)"LBL_Source"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 564, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jCheckBox1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(134, 134, 134).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox1, -2, 202, -2)))).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton3, GroupLayout.Alignment.TRAILING, -1, 572, Short.MAX_VALUE).addComponent(this.jRadioButton2, GroupLayout.Alignment.TRAILING, -1, 572, Short.MAX_VALUE).addComponent(this.jRadioButton1, -1, 572, Short.MAX_VALUE)).addContainerGap())));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(152, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButton1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton3, -2, 24, -2).addContainerGap(92, Short.MAX_VALUE))));
        this.jComboBox1.getAccessibleContext().setAccessibleName(this.jLabel3.getAccessibleContext().getAccessibleName());
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(this.jLabel3.getAccessibleContext().getAccessibleDescription());
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ACSN_Source"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ACSD_Source"));
        this.jLabel2.setText(NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -1, 217, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 361, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ApplicationConfigPanel.class, (String)"TTL_ApplicationConfigPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ApplicationConfigPanel.class, (String)"ApplicationConfigPanel.jLabel2.text"));
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ApplicationConfigPanel.this.jRadioButton1.isSelected()) {
                ApplicationConfigPanel.this.jLabel1.setEnabled(true);
                ApplicationConfigPanel.this.jTextField1.setEnabled(true);
                ApplicationConfigPanel.this.jCheckBox1.setEnabled(true);
            } else if (ApplicationConfigPanel.this.jRadioButton2.isSelected()) {
                ApplicationConfigPanel.this.jLabel1.setEnabled(false);
                ApplicationConfigPanel.this.jTextField1.setEnabled(false);
                ApplicationConfigPanel.this.jCheckBox1.setEnabled(true);
            } else if (ApplicationConfigPanel.this.jRadioButton3.isSelected()) {
                ApplicationConfigPanel.this.jLabel1.setEnabled(true);
                ApplicationConfigPanel.this.jTextField1.setEnabled(true);
                ApplicationConfigPanel.this.jCheckBox1.setSelected(true);
                ApplicationConfigPanel.this.jCheckBox1.setEnabled(false);
            }
        }
    }
}

