/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.Icon;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.impl.RestServiceDescriptionImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;
import org.openide.filesystems.FileObject;

public class RestServicesImpl
implements RestServices {
    private Project project;
    private AnnotationModelHelper helper;
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private volatile PersistentObjectManager<RestServiceDescriptionImpl> restServiceManager;
    private boolean disableChangeSupport;

    public static RestServicesImpl create(AnnotationModelHelper helper, Project project) {
        RestServicesImpl instance = new RestServicesImpl(helper, project);
        instance.initialize();
        return instance;
    }

    private RestServicesImpl(AnnotationModelHelper helper, Project project) {
        this.helper = helper;
        this.project = project;
    }

    private void initialize() {
        this.restServiceManager = this.helper.createPersistentObjectManager((ObjectProvider)new RestServiceProvider());
        this.restServiceManager.addChangeListener(new ChangeListener(){

            @Override
            public synchronized void stateChanged(ChangeEvent e) {
                if (RestServicesImpl.this.disableChangeSupport) {
                    return;
                }
                RestServicesImpl.this.propChangeSupport.firePropertyChange("/restservices", null, null);
            }
        });
    }

    @Override
    public RestServiceDescription[] getRestServiceDescription() {
        Collection restServices = this.restServiceManager.getObjects();
        return restServices.toArray(new RestServiceDescriptionImpl[restServices.size()]);
    }

    @Override
    public RestServiceDescription getRestServiceDescription(String name) {
        for (RestServiceDescription desc : this.getRestServiceDescription()) {
            if (!desc.getName().equals(name)) continue;
            return desc;
        }
        return null;
    }

    @Override
    public int sizeRestServiceDescription() {
        return this.restServiceManager.getObjects().size();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propChangeSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propChangeSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void disablePropertyChangeListener() {
        this.disableChangeSupport = true;
    }

    @Override
    public void enablePropertyChangeListener() {
        this.disableChangeSupport = false;
    }

    public Object clone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(FileObject fo) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void merge(RootInterface root, int mode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setId(String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getValue(String propertyName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void write(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDescription(String locale, String description) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDescription(String description) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAllDescriptions(Map descriptions) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDescription(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDefaultDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map getAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDescriptionForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeAllDescriptions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDisplayName(String locale, String displayName) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDisplayName(String displayName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAllDisplayNames(Map displayNames) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDisplayName(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getDefaultDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map getAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDisplayNameForLocale(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeAllDisplayNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean createBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean addBean(String beanName, String[] propertyNames, Object[] propertyValues, String keyProperty) throws ClassNotFoundException, NameAlreadyUsedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean addBean(String beanName) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CommonDDBean findBeanByName(String beanName, String propertyName, String value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSmallIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setSmallIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLargeIcon(String locale, String icon) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLargeIcon(String icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAllIcons(String[] locales, String[] smallIcons, String[] largeIcons) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIcon(Icon icon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Icon getDefaultIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map getAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSmallIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeLargeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeIcon(String locale) throws VersionNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSmallIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeLargeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeAllIcons() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private final class RestServiceProvider
    implements ObjectProvider<RestServiceDescriptionImpl> {
        private RestServiceProvider() {
        }

        public List<RestServiceDescriptionImpl> createInitialObjects() throws InterruptedException {
            HashMap<TypeElement, RestServiceDescriptionImpl> result = new HashMap<TypeElement, RestServiceDescriptionImpl>();
            this.findAnnotation("javax.ws.rs.Path", EnumSet.of(ElementKind.CLASS), result);
            this.findAnnotation("javax.ws.rs.GET", EnumSet.of(ElementKind.METHOD), result);
            this.findAnnotation("javax.ws.rs.POST", EnumSet.of(ElementKind.METHOD), result);
            this.findAnnotation("javax.ws.rs.PUT", EnumSet.of(ElementKind.METHOD), result);
            this.findAnnotation("javax.ws.rs.DELETE", EnumSet.of(ElementKind.METHOD), result);
            return new ArrayList<RestServiceDescriptionImpl>(result.values());
        }

        public List<RestServiceDescriptionImpl> createObjects(TypeElement type) {
            if (type == null) {
                return Collections.emptyList();
            }
            Utils.checkForJsr311Bootstrap(type, RestServicesImpl.this.project, RestServicesImpl.this.helper);
            if (Utils.isRest(type, RestServicesImpl.this.helper)) {
                return Collections.singletonList(new RestServiceDescriptionImpl(RestServicesImpl.this.helper, type));
            }
            return Collections.emptyList();
        }

        public boolean modifyObjects(TypeElement type, List<RestServiceDescriptionImpl> objects) {
            if (type == null) {
                return false;
            }
            Utils.checkForJsr311Bootstrap(type, RestServicesImpl.this.project, RestServicesImpl.this.helper);
            assert (objects.size() == 1);
            RestServiceDescriptionImpl restService = objects.get(0);
            Status status = restService.refresh(type);
            switch (status) {
                case REMOVED: {
                    objects.remove(0);
                    return true;
                }
                case MODIFIED: {
                    return true;
                }
                case UNMODIFIED: {
                    return false;
                }
            }
            return false;
        }

        private void findAnnotation(String annotationType, EnumSet<ElementKind> kinds, final Map<TypeElement, RestServiceDescriptionImpl> result) throws InterruptedException {
            RestServicesImpl.this.helper.getAnnotationScanner().findAnnotations(annotationType, kinds, new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    if (type == null) {
                        return;
                    }
                    Utils.checkForJsr311Bootstrap(type, RestServicesImpl.this.project, RestServicesImpl.this.helper);
                    if (!result.containsKey(type)) {
                        result.put(type, new RestServiceDescriptionImpl(RestServicesImpl.this.helper, type));
                    }
                }
            });
        }
    }

    public static enum Status {
        UNMODIFIED,
        MODIFIED,
        REMOVED;

    }
}

