/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.impl.RestMethodDescriptionFactory;
import org.netbeans.modules.websvc.rest.model.impl.RestMethodDescriptionImpl;
import org.netbeans.modules.websvc.rest.model.impl.RestServicesImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;
import org.openide.filesystems.FileObject;

public class RestServiceDescriptionImpl
extends PersistentObject
implements RestServiceDescription {
    private String name;
    private String uriTemplate;
    private String className;
    private Map<String, RestMethodDescriptionImpl> methods;
    private boolean isRest;

    public RestServiceDescriptionImpl(AnnotationModelHelper helper, TypeElement typeElement) {
        super(helper, typeElement);
        this.name = typeElement.getSimpleName().toString();
        this.uriTemplate = Utils.getUriTemplate(typeElement);
        this.className = typeElement.getQualifiedName().toString();
        this.isRest = true;
        this.initMethods(typeElement);
    }

    private void initMethods(TypeElement typeElement) {
        this.methods = new HashMap<String, RestMethodDescriptionImpl>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (element == null || element.getKind() != ElementKind.METHOD) continue;
            this.addMethod(element);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Override
    public List<RestMethodDescription> getMethods() {
        ArrayList<RestMethodDescription> list = new ArrayList<RestMethodDescription>();
        for (RestMethodDescriptionImpl method : this.methods.values()) {
            list.add((RestMethodDescription)((Object)method));
        }
        return list;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isRest() {
        return this.isRest;
    }

    public RestServicesImpl.Status refresh(TypeElement typeElement) {
        String newValue;
        if (typeElement.getKind() == ElementKind.INTERFACE) {
            return RestServicesImpl.Status.REMOVED;
        }
        boolean isRest = false;
        boolean isModified = false;
        if (Utils.hasUriTemplate(typeElement)) {
            isRest = true;
        }
        if (this.name != (newValue = typeElement.getSimpleName().toString())) {
            this.name = newValue;
            isModified = true;
        }
        if (this.className != (newValue = typeElement.getQualifiedName().toString())) {
            this.className = newValue;
            isModified = true;
        }
        if (!this.uriTemplate.equals(newValue = Utils.getUriTemplate(typeElement))) {
            this.uriTemplate = newValue;
            isModified = true;
        }
        Map<String, RestMethodDescriptionImpl> prevMethods = this.methods;
        this.methods = new HashMap<String, RestMethodDescriptionImpl>();
        for (Element element : typeElement.getEnclosedElements()) {
            if (element == null || element.getKind() != ElementKind.METHOD) continue;
            String methodName = element.getSimpleName().toString();
            RestMethodDescriptionImpl method = prevMethods.get(methodName);
            if (method != null) {
                RestServicesImpl.Status status = method.refresh(element);
                switch (status) {
                    case REMOVED: {
                        if (this.addMethod(element)) {
                            isRest = true;
                        }
                        isModified = true;
                        break;
                    }
                    case MODIFIED: {
                        isRest = true;
                        isModified = true;
                        this.methods.put(methodName, method);
                        break;
                    }
                    case UNMODIFIED: {
                        isRest = true;
                        this.methods.put(methodName, method);
                    }
                }
                continue;
            }
            if (!this.addMethod(element)) continue;
            isRest = true;
            isModified = true;
        }
        if (this.methods.size() != prevMethods.size()) {
            isModified = true;
        }
        if (!isRest) {
            this.isRest = false;
            return RestServicesImpl.Status.REMOVED;
        }
        if (isModified) {
            return RestServicesImpl.Status.MODIFIED;
        }
        return RestServicesImpl.Status.UNMODIFIED;
    }

    @Override
    public FileObject getFile() {
        return SourceUtils.getFile((ElementHandle)this.getTypeElementHandle(), (ClasspathInfo)this.getHelper().getClasspathInfo());
    }

    private boolean addMethod(Element element) {
        RestMethodDescriptionImpl method = RestMethodDescriptionFactory.create(element);
        if (method != null) {
            this.methods.put(element.getSimpleName().toString(), method);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name + "[" + this.uriTemplate + "]";
    }
}

