/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.JavaClass;
import org.netbeans.modules.websvc.api.customization.model.ServiceCustomization;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.WeakListeners;

public class ServicePanel
extends SaveableSectionInnerPanel {
    private Service service;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener itemListener;
    private JCheckBox defaultJavaClassCB;
    private JLabel javaClassLabel;
    private JTextField javaClassText;

    public ServicePanel(SectionView view, Service service) {
        super(view);
        this.service = service;
        this.model = this.service.getModel();
        this.initComponents();
        this.disableEnterKey();
        this.sync();
        this.itemListener = new DefaultItemListener();
        ItemListener il = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.itemListener, (Object)this.defaultJavaClassCB);
        this.defaultJavaClassCB.addItemListener(il);
        this.addModifier(this.javaClassText);
        this.addModifier(this.defaultJavaClassCB);
        this.addValidatee(this.javaClassText);
    }

    private void sync() {
        List ee = this.service.getExtensibilityElements(ServiceCustomization.class);
        if (ee.size() > 0) {
            ServiceCustomization sc = (ServiceCustomization)ee.get(0);
            JavaClass jc = sc.getJavaClass();
            if (jc != null) {
                this.setJavaClass(jc.getName());
            } else {
                this.defaultJavaClassCB.setSelected(true);
                this.javaClassText.setEnabled(false);
            }
        } else {
            this.defaultJavaClassCB.setSelected(true);
            this.javaClassText.setEnabled(false);
        }
    }

    public void setJavaClass(String name) {
        this.javaClassText.setText(name);
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List ee = this.service.getExtensibilityElements(ServiceCustomization.class);
        CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.javaClassText || jComponent == this.defaultJavaClassCB) {
            ServiceCustomization sc;
            JavaClass jc;
            String text = this.javaClassText.getText();
            if (text != null && !text.trim().equals("") && !this.defaultJavaClassCB.isSelected()) {
                if (!JaxWsUtils.isJavaIdentifier((String)text)) {
                    return;
                }
                if (ee.size() == 1) {
                    ServiceCustomization sc2 = (ServiceCustomization)ee.get(0);
                    JavaClass jc2 = sc2.getJavaClass();
                    if (jc2 == null) {
                        try {
                            jc2 = factory.createJavaClass(this.model);
                            this.model.startTransaction();
                            jc2.setName(text);
                            sc2.setJavaClass(jc2);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            jc2.setName(text);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    ServiceCustomization sc3 = factory.createServiceCustomization(this.model);
                    JavaClass jc3 = factory.createJavaClass(this.model);
                    try {
                        this.model.startTransaction();
                        jc3.setName(text);
                        sc3.setJavaClass(jc3);
                        this.service.addExtensibilityElement((ExtensibilityElement)sc3);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (ee.size() == 1 && (jc = (sc = (ServiceCustomization)ee.get(0)).getJavaClass()) != null) {
                try {
                    this.model.startTransaction();
                    sc.removeJavaClass(jc);
                    if (sc.getChildren().size() == 0) {
                        this.service.removeExtensibilityElement((ExtensibilityElement)sc);
                    }
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.javaClassText && !JaxWsUtils.isJavaIdentifier((String)val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.javaClassText) {
            ServiceCustomization sc;
            JavaClass jc;
            String className = "";
            List ee = this.service.getExtensibilityElements(ServiceCustomization.class);
            if (ee.size() == 1 && (jc = (sc = (ServiceCustomization)ee.get(0)).getJavaClass()) != null) {
                className = jc.getName();
            }
            this.javaClassText.setText(className);
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.javaClassLabel = new JLabel();
        this.javaClassText = new JTextField();
        this.defaultJavaClassCB = new JCheckBox();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.javaClassLabel.setText(bundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.setToolTipText(bundle.getString("TOOLTIP_SERVICE_CLASS"));
        this.defaultJavaClassCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultJavaClassCB.setText(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultJavaClassCB.setContentAreaFilled(false);
        this.defaultJavaClassCB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.javaClassLabel).addGap(21, 21, 21).addComponent(this.javaClassText, -2, 172, -2).addGap(20, 20, 20).addComponent(this.defaultJavaClassCB).addContainerGap(70, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaClassLabel).addComponent(this.javaClassText, -2, -1, -2).addComponent(this.defaultJavaClassCB)).addContainerGap(29, Short.MAX_VALUE)));
        this.javaClassLabel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleName(bundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_USE_DEFAULT"));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ServicePanel.this.defaultJavaClassCB.isSelected()) {
                ServicePanel.this.javaClassText.setEnabled(false);
            } else {
                ServicePanel.this.javaClassText.setEnabled(true);
                ServicePanel.this.javaClassText.requestFocus();
            }
        }
    }
}

