/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableAsyncMapping;
import org.netbeans.modules.websvc.api.customization.model.EnableWrapperStyle;
import org.netbeans.modules.websvc.api.customization.model.JavaClass;
import org.netbeans.modules.websvc.api.customization.model.PortTypeCustomization;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.DefinitionsPanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PortTypePanel
extends SaveableSectionInnerPanel {
    private PortType portType;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener defaultItemListener;
    private ModelChangeListener modelListener;
    private PortTypeActionListener listener;
    private Definitions primaryDefinitions;
    private JCheckBox defaultJavaClassCB;
    private ButtonGroup eamButtonGroup;
    private JCheckBox enableAsyncMappingCB;
    private JCheckBox enableWrapperStyleCB;
    private ButtonGroup ewsButtonGroup;
    private JLabel javaClassLabel;
    private JTextField javaClassText;

    public PortTypePanel(SectionView view, PortType portType, Node node, Definitions primaryDefinitions) {
        super(view);
        this.portType = portType;
        this.primaryDefinitions = primaryDefinitions;
        this.model = this.portType.getModel();
        this.initComponents();
        this.disableEnterKey();
        if (!this.isClient(node)) {
            this.enableAsyncMappingCB.setVisible(false);
        }
        this.enableAsyncMappingCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_ASYNC"));
        this.enableWrapperStyleCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_WRAPPER"));
        this.javaClassText.setToolTipText(NbBundle.getMessage(PortTypePanel.class, (String)"TOOLTIP_PORTTYPE_CLASS"));
        this.syncButtons();
        this.syncJavaClass();
        this.defaultItemListener = new DefaultItemListener();
        ItemListener il = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultItemListener, (Object)this.defaultJavaClassCB);
        this.defaultJavaClassCB.addItemListener(il);
        this.modelListener = new ModelChangeListener();
        WSDLModel primaryModel = primaryDefinitions.getModel();
        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)primaryModel);
        primaryModel.addPropertyChangeListener(pcl);
        this.listener = new PortTypeActionListener();
        ActionListener eamListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableAsyncMappingCB);
        this.enableAsyncMappingCB.addActionListener(eamListener);
        ActionListener ewsListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.listener, (Object)this.enableWrapperStyleCB);
        this.enableWrapperStyleCB.addActionListener(ewsListener);
        this.addModifier(this.javaClassText);
        this.addModifier(this.defaultJavaClassCB);
        this.addValidatee(this.javaClassText);
    }

    private void syncJavaClass() {
        List ee = this.portType.getExtensibilityElements(PortTypeCustomization.class);
        if (ee.size() > 0) {
            PortTypeCustomization pc = (PortTypeCustomization)ee.get(0);
            JavaClass jc = pc.getJavaClass();
            if (jc != null) {
                this.setJavaClass(jc.getName());
            } else {
                this.defaultJavaClassCB.setSelected(true);
                this.javaClassText.setEnabled(false);
            }
        } else {
            this.defaultJavaClassCB.setSelected(true);
            this.javaClassText.setEnabled(false);
        }
    }

    private void syncButtons() {
        List ee = this.portType.getExtensibilityElements(PortTypeCustomization.class);
        if (ee.size() > 0) {
            PortTypeCustomization pc = (PortTypeCustomization)ee.get(0);
            EnableAsyncMapping eam = pc.getEnableAsyncMapping();
            if (eam != null) {
                this.setEnableAsyncMapping(eam.isEnabled());
            } else {
                this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            }
            EnableWrapperStyle ews = pc.getEnableWrapperStyle();
            if (ews != null) {
                this.setEnableWrapperStyle(ews.isEnabled());
            } else {
                this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
            }
        } else {
            this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
        }
    }

    private boolean getAsyncMappingOfParent() {
        DefinitionsCustomization dc;
        EnableAsyncMapping asyncMapping;
        List dcs = this.primaryDefinitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (asyncMapping = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableAsyncMapping()) != null) {
            return asyncMapping.isEnabled();
        }
        return false;
    }

    private boolean getWrapperStyleOfParent() {
        DefinitionsCustomization dc;
        EnableWrapperStyle wrapperStyle;
        List dcs = this.primaryDefinitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (wrapperStyle = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableWrapperStyle()) != null) {
            return wrapperStyle.isEnabled();
        }
        return true;
    }

    public void setEnableAsyncMapping(boolean enable) {
        this.enableAsyncMappingCB.setSelected(enable);
    }

    public boolean getEnableAsyncMapping() {
        return this.enableAsyncMappingCB.isSelected();
    }

    public void setEnableWrapperStyle(boolean enable) {
        this.enableWrapperStyleCB.setSelected(enable);
    }

    public Boolean getEnableWrapperStyle() {
        return this.enableWrapperStyleCB.isSelected();
    }

    public String getJavaClass() {
        return this.javaClassText.getText();
    }

    public void setJavaClass(String name) {
        this.javaClassText.setText(name);
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        block44: {
            List ee = this.portType.getExtensibilityElements(PortTypeCustomization.class);
            CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
            try {
                if (jComponent == this.javaClassText || jComponent == this.defaultJavaClassCB) {
                    String text = this.javaClassText.getText();
                    if (text != null && !text.trim().equals("") && !this.defaultJavaClassCB.isSelected()) {
                        if (!JaxWsUtils.isJavaIdentifier((String)text)) {
                            return;
                        }
                        if (ee.size() == 1) {
                            PortTypeCustomization pc = (PortTypeCustomization)ee.get(0);
                            JavaClass jc = pc.getJavaClass();
                            if (jc == null) {
                                try {
                                    jc = factory.createJavaClass(this.model);
                                    this.model.startTransaction();
                                    jc.setName(text);
                                    pc.setJavaClass(jc);
                                    this.wsdlDirty = true;
                                    break block44;
                                }
                                finally {
                                    this.model.endTransaction();
                                }
                            }
                            try {
                                this.model.startTransaction();
                                jc.setName(text);
                                this.wsdlDirty = true;
                                break block44;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        PortTypeCustomization pc = factory.createPortTypeCustomization(this.model);
                        JavaClass jc = factory.createJavaClass(this.model);
                        try {
                            this.model.startTransaction();
                            jc.setName(text);
                            pc.setJavaClass(jc);
                            this.portType.addExtensibilityElement((ExtensibilityElement)pc);
                            this.wsdlDirty = true;
                            break block44;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    try {
                        PortTypeCustomization pc;
                        JavaClass jc;
                        if (ee.size() == 1 && (jc = (pc = (PortTypeCustomization)ee.get(0)).getJavaClass()) != null) {
                            this.model.startTransaction();
                            pc.removeJavaClass(jc);
                            if (pc.getChildren().size() == 0) {
                                this.portType.removeExtensibilityElement((ExtensibilityElement)pc);
                            }
                            this.wsdlDirty = true;
                        }
                        break block44;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent == this.enableWrapperStyleCB) {
                    if (ee.size() == 1) {
                        PortTypeCustomization pc = (PortTypeCustomization)ee.get(0);
                        EnableWrapperStyle ews = pc.getEnableWrapperStyle();
                        if (ews == null) {
                            try {
                                this.model.startTransaction();
                                ews = factory.createEnableWrapperStyle(this.model);
                                ews.setEnabled(this.getEnableWrapperStyle().booleanValue());
                                pc.setEnableWrapperStyle(ews);
                                this.wsdlDirty = true;
                                break block44;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        try {
                            this.model.startTransaction();
                            ews.setEnabled(this.getEnableWrapperStyle().booleanValue());
                            this.wsdlDirty = true;
                            break block44;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    PortTypeCustomization pc = factory.createPortTypeCustomization(this.model);
                    EnableWrapperStyle ews = factory.createEnableWrapperStyle(this.model);
                    try {
                        this.model.startTransaction();
                        ews.setEnabled(this.getEnableWrapperStyle().booleanValue());
                        pc.setEnableWrapperStyle(ews);
                        this.portType.addExtensibilityElement((ExtensibilityElement)pc);
                        this.wsdlDirty = true;
                        break block44;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent != this.enableAsyncMappingCB) break block44;
                if (ee.size() == 1) {
                    PortTypeCustomization pc = (PortTypeCustomization)ee.get(0);
                    EnableAsyncMapping eam = pc.getEnableAsyncMapping();
                    if (eam == null) {
                        try {
                            this.model.startTransaction();
                            eam = factory.createEnableAsyncMapping(this.model);
                            eam.setEnabled(this.getEnableAsyncMapping());
                            pc.setEnableAsyncMapping(eam);
                            this.wsdlDirty = true;
                            break block44;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    try {
                        this.model.startTransaction();
                        eam.setEnabled(this.getEnableAsyncMapping());
                        this.wsdlDirty = true;
                        break block44;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                PortTypeCustomization pc = factory.createPortTypeCustomization(this.model);
                EnableAsyncMapping eam = factory.createEnableAsyncMapping(this.model);
                try {
                    this.model.startTransaction();
                    eam.setEnabled(this.getEnableAsyncMapping());
                    pc.setEnableAsyncMapping(eam);
                    this.portType.addExtensibilityElement((ExtensibilityElement)pc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
            catch (IllegalStateException ex) {
                Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.javaClassText && !JaxWsUtils.isJavaIdentifier((String)val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.javaClassText) {
            PortTypeCustomization ptc;
            JavaClass jc;
            String className = "";
            List ee = this.portType.getExtensibilityElements(PortTypeCustomization.class);
            if (ee.size() == 1 && (jc = (ptc = (PortTypeCustomization)ee.get(0)).getJavaClass()) != null) {
                className = jc.getName();
            }
            this.javaClassText.setText(className);
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.ewsButtonGroup = new ButtonGroup();
        this.eamButtonGroup = new ButtonGroup();
        this.javaClassLabel = new JLabel();
        this.javaClassText = new JTextField();
        this.defaultJavaClassCB = new JCheckBox();
        this.enableWrapperStyleCB = new JCheckBox();
        this.enableAsyncMappingCB = new JCheckBox();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.javaClassLabel.setText(bundle.getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultJavaClassCB.setText(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultJavaClassCB.setContentAreaFilled(false);
        this.defaultJavaClassCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableWrapperStyleCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_WRAPPER_STYLE").charAt(0));
        this.enableWrapperStyleCB.setText(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableWrapperStyleCB.setContentAreaFilled(false);
        this.enableWrapperStyleCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableAsyncMappingCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_ASYNC_CLIENT").charAt(0));
        this.enableAsyncMappingCB.setText(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAsyncMappingCB.setContentAreaFilled(false);
        this.enableAsyncMappingCB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enableAsyncMappingCB).addComponent(this.enableWrapperStyleCB).addGroup(layout.createSequentialGroup().addComponent(this.javaClassLabel).addGap(16, 16, 16).addComponent(this.javaClassText, -2, 237, -2).addGap(21, 21, 21).addComponent(this.defaultJavaClassCB))).addContainerGap(33, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaClassLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaClassText, -2, 16, -2).addComponent(this.defaultJavaClassCB))).addGap(18, 18, 18).addComponent(this.enableWrapperStyleCB).addGap(15, 15, 15).addComponent(this.enableAsyncMappingCB).addContainerGap(25, Short.MAX_VALUE)));
        this.javaClassLabel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleName(bundle.getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_USE_DEFAULT"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EnableAsyncMapping eam;
            WSDLComponent parent;
            Object source = evt.getSource();
            if (source instanceof EnableWrapperStyle) {
                EnableWrapperStyle ews = (EnableWrapperStyle)source;
                WSDLComponent parent2 = (WSDLComponent)ews.getParent();
                if (parent2 instanceof DefinitionsCustomization) {
                    PortTypePanel.this.syncButtons();
                }
            } else if (source instanceof EnableAsyncMapping && (parent = (WSDLComponent)(eam = (EnableAsyncMapping)source).getParent()) instanceof DefinitionsCustomization) {
                PortTypePanel.this.syncButtons();
            }
        }
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (PortTypePanel.this.defaultJavaClassCB.isSelected()) {
                PortTypePanel.this.javaClassText.setEnabled(false);
            } else {
                PortTypePanel.this.javaClassText.setEnabled(true);
                PortTypePanel.this.javaClassText.requestFocus();
            }
        }
    }

    class PortTypeActionListener
    implements ActionListener {
        PortTypeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PortTypePanel.this.setValue((JComponent)e.getSource(), null);
        }
    }
}

