/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class ExternalBindingTablePanel
extends DefaultTablePanel {
    private static final String[] columnName = new String[]{NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"LBL_CUSTOMIZATION_FILES")};
    private EBTableModel model;
    private String previousDirectory = "";
    private static final FileFilter XML_FILE_FILTER = new XmlFileFilter();
    private Node node;
    private Map<String, FileObject> addedBindings;
    private RemoveActionListener removeActionListener;
    private AddActionListener addActionListener;

    public ExternalBindingTablePanel(EBTableModel model, Node node) {
        super((AbstractTableModel)model);
        this.getTable().getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"LBL_CUSTOMIZATION_FILES"));
        this.getTable().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"LBL_CUSTOMIZATION_FILES"));
        this.model = model;
        this.node = node;
        this.editButton.setVisible(false);
        this.addedBindings = new HashMap<String, FileObject>();
        this.addActionListener = new AddActionListener();
        ActionListener addListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.addActionListener, (Object)this.addButton);
        this.addButton.addActionListener(addListener);
        this.removeActionListener = new RemoveActionListener();
        ActionListener removeListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.removeActionListener, (Object)this.removeButton);
        this.removeButton.addActionListener(removeListener);
    }

    public String getRelativePathToWsdl() {
        String relativePath = "";
        FileObject srcRoot = (FileObject)this.node.getLookup().lookup(FileObject.class);
        FileObject localWsdlFile = null;
        FileObject wsdlFolder = null;
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        if (client != null) {
            JAXWSClientSupport support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)srcRoot);
            wsdlFolder = support.getLocalWsdlFolderForClient(client.getName(), false);
            localWsdlFile = wsdlFolder.getFileObject(client.getLocalWsdlFile());
        } else {
            JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)srcRoot);
            Service service = (Service)this.node.getLookup().lookup(Service.class);
            wsdlFolder = support.getLocalWsdlFolderForService(service.getName(), false);
            localWsdlFile = wsdlFolder.getFileObject(service.getLocalWsdlFile());
        }
        try {
            relativePath = Utilities.relativize((URI)FileUtil.toFile((FileObject)wsdlFolder).toURI(), (URI)new URI(localWsdlFile.getURL().toExternalForm()));
        }
        catch (Exception e) {
            return "Unable to obtain relative path";
        }
        return "../wsdl/" + relativePath;
    }

    public Map<String, FileObject> getAddedBindings() {
        return this.addedBindings;
    }

    public Set<String> getRemovedBindings() {
        HashSet<String> bindingsRemoved = new HashSet<String>();
        Binding[] bindingsInModel = null;
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        if (client != null) {
            bindingsInModel = client.getBindings();
        } else {
            Service service = (Service)this.node.getLookup().lookup(Service.class);
            if (service != null) {
                bindingsInModel = service.getBindings();
            }
        }
        if (bindingsInModel == null) {
            return Collections.emptySet();
        }
        List bindingsInTable = this.model.getChildren();
        for (int i = 0; i < bindingsInModel.length; ++i) {
            String bindingInModel = bindingsInModel[i].getFileName();
            boolean found = false;
            for (String bindingInTable : bindingsInTable) {
                if (!bindingInTable.equals(bindingInModel)) continue;
                found = true;
                break;
            }
            if (found) continue;
            bindingsRemoved.add(bindingInModel);
        }
        return bindingsRemoved;
    }

    public List getChildren() {
        return this.model.getChildren();
    }

    void populateModel() {
        this.model.setData(this.node);
    }

    private static class XmlFileFilter
    extends FileFilter {
        private XmlFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            boolean result = f.isDirectory() || "xml".equalsIgnoreCase(FileUtil.getExtension((String)f.getName())) || "jxb".equalsIgnoreCase(FileUtil.getExtension((String)f.getName())) || "xjb".equalsIgnoreCase(FileUtil.getExtension((String)f.getName()));
            return result;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"DESC_CUSTOMIZATION_FILE_FILTER");
        }
    }

    public static class EBTableModel
    extends AbstractTableModel {
        List<String> children;

        @Override
        public Object getValueAt(int row, int column) {
            return this.children.get(row);
        }

        @Override
        public int getRowCount() {
            if (this.children != null) {
                return this.children.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return columnName.length;
        }

        public void removeRow(int row) {
            this.children.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void addRow(String value) {
            this.children.add(value);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        public void setData(Node node) {
            this.children = new ArrayList<String>();
            ArrayList<String> list = new ArrayList<String>();
            Client client = (Client)node.getLookup().lookup(Client.class);
            if (client != null) {
                Binding[] bindings = client.getBindings();
                for (int i = 0; i < bindings.length; ++i) {
                    list.add(bindings[i].getFileName());
                }
            } else {
                Service service = (Service)node.getLookup().lookup(Service.class);
                if (service != null) {
                    Binding[] bindings = service.getBindings();
                    for (int i = 0; i < bindings.length; ++i) {
                        list.add(bindings[i].getFileName());
                    }
                }
            }
            this.children.addAll(list);
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            return columnName[column];
        }

        public List getChildren() {
            return this.children;
        }
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File bindingFile;
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"MSG_EXTERNAL_BINDING", (Object)ExternalBindingTablePanel.this.getRelativePathToWsdl()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            if (notifyDesc.getValue() == NotifyDescriptor.NO_OPTION) {
                return;
            }
            JFileChooser chooser = new JFileChooser(ExternalBindingTablePanel.this.previousDirectory);
            chooser.setMultiSelectionEnabled(false);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addChoosableFileFilter(XML_FILE_FILTER);
            chooser.setFileFilter(XML_FILE_FILTER);
            if (chooser.showOpenDialog((Component)((Object)ExternalBindingTablePanel.this)) == 0 && (bindingFile = chooser.getSelectedFile()).exists()) {
                FileObject bindingFO = FileUtil.toFileObject((File)bindingFile);
                String bindingName = bindingFO.getName();
                bindingName = FileUtil.findFreeFileName((FileObject)this.getBindingsFolder(ExternalBindingTablePanel.this.node), (String)bindingName, (String)bindingFO.getExt());
                bindingName = bindingFO.getExt().equals("") ? bindingName : bindingName + "." + bindingFO.getExt();
                ExternalBindingTablePanel.this.addedBindings.put(bindingName, bindingFO);
                ExternalBindingTablePanel.this.model.addRow(bindingName);
                ExternalBindingTablePanel.this.previousDirectory = bindingFile.getPath();
            }
        }

        private FileObject getBindingsFolder(Node node) {
            FileObject srcRoot = (FileObject)node.getLookup().lookup(FileObject.class);
            assert (srcRoot != null) : "Cannot find srcRoot";
            FileObject bindingsFolder = null;
            Client client = (Client)node.getLookup().lookup(Client.class);
            if (client != null) {
                JAXWSClientSupport support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)srcRoot);
                bindingsFolder = support.getBindingsFolderForClient(node.getName(), true);
            } else {
                Service service = (Service)node.getLookup().lookup(Service.class);
                if (service != null) {
                    JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)srcRoot);
                    bindingsFolder = support.getBindingsFolderForService(node.getName(), true);
                }
            }
            return bindingsFolder;
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ExternalBindingTablePanel.this.getTable().getSelectedRow();
            if (row == -1) {
                return;
            }
            String fileName = (String)ExternalBindingTablePanel.this.getTable().getValueAt(row, 0);
            if (this.confirmDeletion(fileName)) {
                ExternalBindingTablePanel.this.addedBindings.remove(fileName);
                ExternalBindingTablePanel.this.model.removeRow(row);
            }
        }

        private boolean confirmDeletion(String fileName) {
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"MSG_CONFIRM_DELETE", (Object)fileName), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            return notifyDesc.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

