/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.jaxwssettings.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.customization.jaxwssettings.panel.WsimportOptionsPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class OptionsPanel
extends JPanel {
    private List<String> reservedOptions;
    private Object[] columnNames;
    private List<WsimportOption> options;
    private OptionsTableModel optionsTableModel;
    private AddButtonActionListener addListener;
    private RemoveButtonActionListener removeListener;
    private WsimportOptions wsimportOptions;
    private JButton addBtn;
    private JScrollPane jScrollPane1;
    private JTable optionsTable;
    private JButton removeBtn;

    public OptionsPanel() {
        this(new String[]{"", ""}, new ArrayList<WsimportOption>(), new ArrayList<String>(), null);
    }

    public OptionsPanel(Object[] columnNames, List<WsimportOption> options, List<String> reservedOptions, WsimportOptions wsimportOptions) {
        this.initComponents();
        this.reservedOptions = reservedOptions;
        this.columnNames = columnNames;
        this.options = options;
        this.wsimportOptions = wsimportOptions;
        this.optionsTableModel = new OptionsTableModel(columnNames, options);
        this.optionsTable.setModel(this.optionsTableModel);
        this.optionsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ListSelectionListenerImpl listSelectionListener = new ListSelectionListenerImpl();
        this.optionsTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.optionsTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
        this.addListener = new AddButtonActionListener();
        ActionListener al = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.addListener, (Object)this.addBtn);
        this.addBtn.addActionListener(al);
        this.removeListener = new RemoveButtonActionListener();
        ActionListener rl = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.removeListener, (Object)this.removeBtn);
        this.removeBtn.addActionListener(rl);
        this.removeBtn.setEnabled(false);
    }

    private void updateButtons() {
        boolean oneSelected = this.optionsTable.getSelectedRowCount() == 1;
        this.removeBtn.setEnabled(oneSelected);
    }

    private int getSelectedRow() {
        ListSelectionModel lsm = this.optionsTable.getSelectionModel();
        if (lsm.isSelectionEmpty()) {
            return -1;
        }
        return lsm.getMinSelectionIndex();
    }

    public void setReservedOptions(List<String> reservedOptions) {
        this.reservedOptions = reservedOptions;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        this.optionsTableModel.setColumnIdentifiers(columnNames);
    }

    public void setOptions(List<WsimportOption> options) {
        this.options = options;
        for (WsimportOption option : options) {
            this.optionsTableModel.addRow(new String[]{option.getWsimportOptionName(), option.getWsimportOptionValue()});
        }
    }

    public List<WsimportOption> getOptions() {
        return this.optionsTableModel.getOptions();
    }

    public TableModel getOptionsTableModel() {
        return this.optionsTableModel;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.optionsTable = new JTable();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.jScrollPane1.setViewportView(this.optionsTable);
        this.addBtn.setText("Add");
        this.addBtn.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"HINT_Add"));
        this.removeBtn.setText("Remove");
        this.removeBtn.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"HINT_Remove"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 351, -2).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeBtn, -1, 124, Short.MAX_VALUE).addComponent(this.addBtn, -1, 124, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 165, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removeBtn))).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)NbBundle.getMessage(OptionsPanel.class, (String)"Add_DotDotDot_label"));
        this.addBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsPanel.class, (String)"Add_DotDotDot_label"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)NbBundle.getMessage(OptionsPanel.class, (String)"Remove_label"));
        this.removeBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsPanel.class, (String)"Remove_label"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsPanel.class, (String)"Remove_label"));
    }

    class OptionsTableModel
    extends DefaultTableModel {
        private List<WsimportOption> options;
        private String[] columnNames;

        public OptionsTableModel(Object[] columnNames, List<WsimportOption> options) {
            super(columnNames, options.size());
            this.columnNames = (String[])columnNames;
            this.options = options;
        }

        public Class getColumnClass(int c) {
            return super.getColumnClass(c);
        }

        public List<WsimportOption> getOptions() {
            return this.options;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        private String generateUniqueName(String name) {
            String uniqueName = name;
            int suffix = 1;
            HashSet<String> names = new HashSet<String>();
            for (WsimportOption option : this.options) {
                names.add(option.getWsimportOptionName());
            }
            while (names.contains(uniqueName)) {
                uniqueName = name + ++suffix;
            }
            return uniqueName;
        }

        public int addOption() {
            String name = this.generateUniqueName(NbBundle.getMessage(OptionsPanel.class, (String)"DEFAULT_OPTION_NAME"));
            int index = this.options.size();
            String defaultValue = NbBundle.getMessage(OptionsPanel.class, (String)"DEFAULT_VALUE");
            this.addRow(new String[]{name, defaultValue});
            WsimportOption opt = OptionsPanel.this.wsimportOptions.newWsimportOption();
            opt.setWsimportOptionName(name);
            opt.setWsimportOptionValue(defaultValue);
            this.options.add(opt);
            this.fireTableRowsInserted(index, index);
            return index;
        }

        public void removeOption(int index) {
            this.options.remove(index);
            this.removeRow(index);
            this.fireTableRowsDeleted(index, index);
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = null;
            if (row >= 0) {
                WsimportOption option = this.options.get(row);
                switch (column) {
                    case 0: {
                        result = option.getWsimportOptionName();
                        break;
                    }
                    case 1: {
                        result = option.getWsimportOptionValue();
                        break;
                    }
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            WsimportOption opt = null;
            String insertedValue = (String)aValue;
            String oldValue = (String)this.getValueAt(row, 1);
            if (column == 0) {
                String oldKey = (String)this.getValueAt(row, 0);
                if (oldKey.equals(insertedValue)) {
                    return;
                }
                if (OptionsPanel.this.reservedOptions != null) {
                    for (String option : OptionsPanel.this.reservedOptions) {
                        if (!insertedValue.trim().equals(option)) continue;
                        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WsimportOptionsPanel.class, (String)"ERR_RESERVED_OPTION", (Object)insertedValue));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                        WsimportOption op = OptionsPanel.this.wsimportOptions.newWsimportOption();
                        op.setWsimportOptionName(oldKey);
                        op.setWsimportOptionValue(oldValue);
                        this.options.set(row, op);
                        this.fireTableCellUpdated(row, column);
                        return;
                    }
                }
                opt = OptionsPanel.this.wsimportOptions.newWsimportOption();
                opt.setWsimportOptionName(insertedValue);
                opt.setWsimportOptionValue((String)this.getValueAt(row, 1));
            } else if (column == 1) {
                if (oldValue != null && oldValue.equals(insertedValue)) {
                    return;
                }
                opt = OptionsPanel.this.wsimportOptions.newWsimportOption();
                opt.setWsimportOptionName((String)this.getValueAt(row, 0));
                opt.setWsimportOptionValue(insertedValue);
            }
            this.options.set(row, opt);
            this.fireTableCellUpdated(row, column);
        }
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            OptionsPanel.this.optionsTable.editCellAt(OptionsPanel.this.optionsTable.getSelectedRow(), OptionsPanel.this.optionsTable.getSelectedColumn());
            Component editor = OptionsPanel.this.optionsTable.getEditorComponent();
            if (editor != null) {
                editor.requestFocus();
            }
            if (editor instanceof JTextComponent) {
                JTextComponent textComp = (JTextComponent)editor;
                textComp.selectAll();
            }
            OptionsPanel.this.updateButtons();
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int index = OptionsPanel.this.optionsTableModel.addOption();
            OptionsPanel.this.optionsTable.getSelectionModel().setSelectionInterval(index, index);
            OptionsPanel.this.optionsTable.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            OptionsPanel.this.updateButtons();
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = OptionsPanel.this.getSelectedRow();
            String option = (String)OptionsPanel.this.optionsTableModel.getValueAt(selectedRow, 0);
            if (this.confirmDeletion(option)) {
                if (selectedRow > -1) {
                    OptionsPanel.this.optionsTableModel.removeOption(selectedRow);
                }
                if (selectedRow == OptionsPanel.this.optionsTable.getRowCount()) {
                    --selectedRow;
                }
                OptionsPanel.this.optionsTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            }
            OptionsPanel.this.updateButtons();
        }

        private boolean confirmDeletion(String option) {
            NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WsimportOptionsPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)option), NbBundle.getMessage(WsimportOptionsPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
            return notifyDesc.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

