/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.core.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.customization.jaxwssettings.panel.WsimportOptionsPanel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JaxwsSettingsEditor
implements WSEditor {
    private Service service;
    private Client client;
    private WsimportOptionsPanel panel;
    private JaxWsModel jaxWsModel;

    JaxwsSettingsEditor(JaxWsModel jaxWsModel) {
        this.jaxWsModel = jaxWsModel;
    }

    public JComponent createWSEditorComponent(Node node) {
        this.service = (Service)node.getLookup().lookup(Service.class);
        this.client = (Client)node.getLookup().lookup(Client.class);
        WsimportOptions wsimportOptions = null;
        if (this.service != null) {
            wsimportOptions = this.service.getWsImportOptions();
        } else if (this.client != null) {
            wsimportOptions = this.client.getWsImportOptions();
        }
        ArrayList<WsimportOption> options = new ArrayList<WsimportOption>();
        ArrayList<WsimportOption> jaxbOptions = new ArrayList<WsimportOption>();
        if (wsimportOptions != null) {
            WsimportOption[] wsoptions = wsimportOptions.getWsimportOptions();
            for (int i = 0; i < wsoptions.length; ++i) {
                WsimportOption wsimportOption = wsoptions[i];
                if (wsimportOption.getJaxbOption() != null && wsimportOption.getJaxbOption().booleanValue()) {
                    jaxbOptions.add(wsimportOption);
                    continue;
                }
                options.add(wsimportOption);
            }
        }
        this.panel = new WsimportOptionsPanel(options, jaxbOptions, wsimportOptions);
        return this.panel;
    }

    public String getTitle() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_TITLE");
    }

    public void save(Node node) {
        try {
            WsimportOptions wsimportOptions = null;
            if (this.service != null) {
                wsimportOptions = this.service.getWsImportOptions();
                if (wsimportOptions == null) {
                    wsimportOptions = this.service.newWsimportOptions();
                }
            } else if (this.client != null && (wsimportOptions = this.client.getWsImportOptions()) == null) {
                wsimportOptions = this.client.newWsimportOptions();
            }
            if (wsimportOptions != null) {
                wsimportOptions.clearWsimportOptions();
                List<WsimportOption> options = this.getWsimportOptions();
                for (WsimportOption option : options) {
                    wsimportOptions.addWsimportOption(option);
                }
                options = this.getJaxbOptions();
                for (WsimportOption option : options) {
                    option.setJaxbOption(Boolean.valueOf(true));
                    wsimportOptions.addWsimportOption(option);
                }
            }
            this.jaxWsModel.write();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void cancel(Node node) {
    }

    public String getDescription() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_DESC");
    }

    private List<WsimportOption> getWsimportOptions() {
        return this.panel.getWsimportOptions();
    }

    private List<WsimportOption> getJaxbOptions() {
        return this.panel.getJaxbOptions();
    }
}

