/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.qnavigator.navigator.ItemEvent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NavigatorComponent
implements NavigatorPanel,
LookupListener {
    private Lookup.Result<DataObject> doContext;
    private NavigatorPanelUI panelUI;
    private NavigatorModel curModel;
    private DataObject curData;
    private final Lock lock = new Lock();
    private final Lock uiLock = new Lock();
    private static final RequestProcessor RP = new RequestProcessor("Updating C/C++ Navigator Content", 1);

    public String getDisplayName() {
        return NbBundle.getMessage(NavigatorComponent.class, (String)"LBL_members");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(NavigatorComponent.class, (String)"HINT_NavigatorTopComponen");
    }

    public JComponent getComponent() {
        return this.getPanelUI();
    }

    private String getMime(DataObject dobj) {
        FileObject fo = dobj == null ? null : dobj.getPrimaryFile();
        String mime = fo == null ? "" : fo.getMIMEType();
        return mime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelActivated(Lookup context) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.doContext = context.lookupResult(DataObject.class);
            this.doContext.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelDeactivated() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.doContext.removeLookupListener((LookupListener)this);
            this.doContext = null;
            this.detachFromModel(this.curModel);
            this.curModel = null;
            this.curData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        Lock lock = this.lock;
        synchronized (lock) {
            for (DataObject dob : this.doContext.allInstances()) {
                if (!MIMENames.isFortranOrHeaderOrCppOrC((String)this.getMime(dob))) continue;
                if (dob.equals(this.curData)) break;
                this.detachFromModel(this.curModel);
                this.curData = dob;
                this.setNewContent(dob);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.curData == null || !this.curData.isValid()) {
                return this.getPanelUI().getLookup();
            }
            if (this.getPanelUI().getLookup().lookup(Node.class) == null) {
                return new ProxyLookup(new Lookup[]{this.getPanelUI().getLookup(), Lookups.fixed((Object[])new Object[]{this.curData.getNodeDelegate(), this.curData, this.curData.getPrimaryFile()})});
            }
            return new ProxyLookup(new Lookup[]{this.getPanelUI().getLookup(), Lookups.fixed((Object[])new Object[]{this.curData, this.curData.getPrimaryFile()})});
        }
    }

    public void busyStart() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(true);
                }
            });
        }
    }

    public void busyEnd() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getPanelUI().setBusyState(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorComponent.this.getPanelUI().setBusyState(false);
                }
            });
        }
    }

    public void newContentReady() {
        this.getPanelUI().newContentReady();
    }

    public void itemsChanged(ItemEvent evt) {
    }

    public void itemsCleared(ItemEvent evt) {
        this.getPanelUI().getContent().repaint();
    }

    private void setNewContent(final DataObject cdo) {
        final NavigatorPanelUI ui = this.getPanelUI();
        RP.post(new Runnable(){

            @Override
            public void run() {
                NavigatorComponent.this.setNewContentImpl(cdo, ui);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewContentImpl(DataObject cdo, NavigatorPanelUI ui) {
        NavigatorModel aNavigatorModel = new NavigatorModel(cdo, ui, this, this.getMime(cdo));
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)aNavigatorModel);
        CsmListeners.getDefault().addModelListener((CsmModelListener)aNavigatorModel);
        ui.getContent().setModel(aNavigatorModel);
        try {
            aNavigatorModel.addBusyListener(this);
        }
        catch (Exception exc) {
            exc.printStackTrace(System.err);
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.curModel = aNavigatorModel;
        }
        aNavigatorModel.addNotify();
    }

    private void detachFromModel(NavigatorModel model) {
        if (model != null) {
            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)model);
            CsmListeners.getDefault().removeModelListener((CsmModelListener)model);
            model.removeBusyListener(this);
            model.removeNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigatorPanelUI getPanelUI() {
        Lock lock = this.uiLock;
        synchronized (lock) {
            if (this.panelUI == null) {
                this.panelUI = new NavigatorPanelUI();
            }
            return this.panelUI;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

