/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.openide.util.NbPreferences;

public class CsmFileFilter {
    private BooleanFilter showForwardClassDeclarations = new BooleanFilter("ShowForwardClassDeclarations", true);
    private BooleanFilter showForwardFunctionDeclarations = new BooleanFilter("ShowForwardFunctionDeclarations", false);
    private BooleanFilter showInclude = new BooleanFilter("ShowInclude", true);
    private BooleanFilter showMacro = new BooleanFilter("ShowMacro", true);
    private BooleanFilter showTypedef = new BooleanFilter("ShowTypedef", true);
    private BooleanFilter showVariable = new BooleanFilter("ShowVariable", true);
    private BooleanFilter showField = new BooleanFilter("ShowField", true);
    private BooleanFilter showUsing = new BooleanFilter("ShowUsing", true);
    private SortMode sortByName = SortMode.Name;
    private BooleanFilter groupByKind = new BooleanFilter("groupByKind", false);
    private BooleanFilter expandAll = new BooleanFilter("expandAll", false);

    public CsmFileFilter() {
        Preferences ps = NbPreferences.forModule(CsmFileFilter.class);
        this.sortByName = SortMode.valueOf(ps.get("SortByName", this.sortByName.name()));
    }

    public boolean isApplicable(CsmOffsetable object) {
        if (!this.isShowForwardFunctionDeclarations() && CsmKindUtilities.isFunctionDeclaration((CsmObject)object)) {
            CsmFunctionDefinition def = ((CsmFunction)object).getDefinition();
            if (def != null && !def.equals(object) && !CsmKindUtilities.isMethod((CsmObject)def)) {
                return !object.getContainingFile().equals(def.getContainingFile());
            }
        } else {
            if (!this.isShowForwardClassDeclarations() && (CsmKindUtilities.isClassForwardDeclaration((CsmObject)object) || CsmKindUtilities.isEnumForwardDeclaration((CsmObject)object))) {
                return false;
            }
            if (!this.isShowTypedef() && CsmKindUtilities.isTypedef((CsmObject)object)) {
                return false;
            }
            if (!(this.isShowVariable() && this.isShowField() || !CsmKindUtilities.isVariable((CsmObject)object))) {
                if (CsmKindUtilities.isClassMember((CsmObject)object)) {
                    return this.isShowField();
                }
                return this.isShowVariable();
            }
            if (!this.isShowUsing() && (CsmKindUtilities.isUsing((CsmObject)object) || CsmKindUtilities.isNamespaceAlias((CsmObject)object))) {
                return false;
            }
        }
        return true;
    }

    public boolean isApplicableInclude() {
        return this.isShowInclude();
    }

    public boolean isApplicableMacro() {
        return this.isShowMacro();
    }

    public boolean isShowInclude() {
        return this.showInclude.isSelected();
    }

    public void setShowInclude(boolean showInclude) {
        this.showInclude.setSelected(showInclude);
    }

    public boolean isShowMacro() {
        return this.showMacro.isSelected();
    }

    public void setShowMacro(boolean showMacro) {
        this.showMacro.setSelected(showMacro);
    }

    public boolean isShowForwardFunctionDeclarations() {
        return this.showForwardFunctionDeclarations.isSelected();
    }

    public void setShowForwardFunctionDeclarations(boolean showForwardFunctionDeclarations) {
        this.showForwardFunctionDeclarations.setSelected(showForwardFunctionDeclarations);
    }

    public boolean isShowForwardClassDeclarations() {
        return this.showForwardClassDeclarations.isSelected();
    }

    public void setShowForwardClassDeclarations(boolean showForwardClassDeclarations) {
        this.showForwardClassDeclarations.setSelected(showForwardClassDeclarations);
    }

    public boolean isShowTypedef() {
        return this.showTypedef.isSelected();
    }

    public void setShowTypedef(boolean showTypedef) {
        this.showTypedef.setSelected(showTypedef);
    }

    public boolean isShowVariable() {
        return this.showVariable.isSelected();
    }

    public void setShowVariable(boolean showVariable) {
        this.showVariable.setSelected(showVariable);
    }

    public boolean isShowField() {
        return this.showField.isSelected();
    }

    public void setShowField(boolean showField) {
        this.showField.setSelected(showField);
    }

    public boolean isShowUsing() {
        return this.showUsing.isSelected();
    }

    public void setShowUsing(boolean showUsing) {
        this.showUsing.setSelected(showUsing);
    }

    public SortMode getSortMode() {
        return this.sortByName;
    }

    public void setSortMode(SortMode sortByName) {
        this.sortByName = sortByName;
        Preferences ps = NbPreferences.forModule(CsmFileFilter.class);
        ps.put("SortByName", sortByName.name());
    }

    public boolean isGroupByKind() {
        return this.groupByKind.isSelected();
    }

    public void setGroupByKind(boolean groupKind) {
        this.groupByKind.setSelected(groupKind);
    }

    public boolean isExpandAll() {
        return this.expandAll.isSelected();
    }

    public void setExpandAll(boolean expandAll) {
        this.expandAll.setSelected(expandAll);
    }

    private static final class BooleanFilter {
        private boolean value;
        private final String name;

        private BooleanFilter(String name, boolean defauilt) {
            this.name = name;
            this.value = this.getPreferences().getBoolean(name, defauilt);
        }

        public boolean isSelected() {
            return this.value;
        }

        public void setSelected(boolean value) {
            this.value = value;
            this.getPreferences().putBoolean(this.name, value);
        }

        private Preferences getPreferences() {
            return NbPreferences.forModule(CsmFileFilter.class);
        }
    }

    public static enum SortMode {
        Name,
        Offset;

    }
}

