/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.AbstractCsmNode;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileModel;
import org.netbeans.modules.cnd.qnavigator.navigator.GoToDeclarationAction;
import org.netbeans.modules.cnd.qnavigator.navigator.IndexOffsetNode;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorChildren;
import org.netbeans.modules.cnd.qnavigator.navigator.OpenContainingProjectAction;
import org.netbeans.modules.cnd.refactoring.api.ui.CsmRefactoringActionsFactory;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.CharSequences;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class CppDeclarationNode
extends AbstractCsmNode
implements Comparable<CppDeclarationNode> {
    private static final String FONT_COLORCONTROLSHADOW = "<font color='!controlShadow'>  ";
    private Image icon;
    private CsmObject object;
    private CsmFile file;
    private boolean isFriend;
    private boolean isSpecialization;
    private CsmFileModel model;
    private boolean needInitHTML = true;
    private CharSequence name;
    private CharSequence htmlDisplayName;
    private CharSequence scopeName = CharSequences.empty();
    private byte weight;
    private final InstanceContent ic;

    private static CppDeclarationNode createNamespaseContainer(CsmOffsetableDeclaration element, CsmFileModel model, List<IndexOffsetNode> lineNumberIndex) {
        CppDeclarationNode res = new CppDeclarationNode((Children)new NavigatorChildren(element, model, null, lineNumberIndex), new InstanceContent(), (CsmObject)element, element.getContainingFile(), model);
        res.icon = res.getIcon(0);
        return res;
    }

    private static CppDeclarationNode createClassifierContainer(CsmOffsetableDeclaration element, CsmFileModel model, CsmCompoundClassifier classifier, List<IndexOffsetNode> lineNumberIndex) {
        CppDeclarationNode res = new CppDeclarationNode((Children)new NavigatorChildren(element, model, classifier, lineNumberIndex), new InstanceContent(), (CsmObject)element, element.getContainingFile(), model);
        res.icon = res.getIcon(0);
        return res;
    }

    private static CppDeclarationNode createFile(CsmFile csmFile, CsmFileModel model) {
        CppDeclarationNode res = new CppDeclarationNode(Children.LEAF, new InstanceContent(), (CsmObject)csmFile, csmFile, model);
        res.icon = res.getIcon(0);
        return res;
    }

    private static CppDeclarationNode createDeclaration(CsmOffsetableDeclaration element, CsmFileModel model, boolean isFriend) {
        CppDeclarationNode res = new CppDeclarationNode(Children.LEAF, new InstanceContent(), (CsmObject)element, element.getContainingFile(), model);
        res.isFriend = isFriend;
        res.icon = res.getIcon(0);
        return res;
    }

    private static CppDeclarationNode createObject(CsmOffsetable element, CsmFileModel model) {
        CppDeclarationNode res = new CppDeclarationNode(Children.LEAF, new InstanceContent(), (CsmObject)element, element.getContainingFile(), model);
        res.icon = res.getIcon(0);
        return res;
    }

    private CppDeclarationNode(Children children, InstanceContent ic, CsmObject element, CsmFile file, CsmFileModel model) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        this.object = element;
        this.file = file;
        this.model = model;
        this.weight = this.getObjectWeight();
        ic.add((Object)element);
        ic.add((Object)model.getFileObject());
        this.ic = ic;
    }

    private CharSequence createFunctionSpecializationHtmlDisplayName() {
        return CharSequences.create((CharSequence)(CsmDisplayUtilities.htmlize((CharSequence)this.getDisplayName()) + FONT_COLORCONTROLSHADOW + this.scopeName));
    }

    private CharSequence createMemberHtmlDisplayName() {
        String aName = CsmDisplayUtilities.htmlize((CharSequence)this.scopeName);
        String displayName = CsmDisplayUtilities.htmlize((CharSequence)this.getDisplayName());
        String in = NbBundle.getMessage(this.getClass(), (String)"LBL_inClass", (Object)aName);
        return CharSequences.create((CharSequence)(displayName + FONT_COLORCONTROLSHADOW + in));
    }

    private CharSequence getFunctionSpecializationName(CsmObject csmObject) throws MissingResourceException {
        String in;
        CsmFunction fun = (CsmFunction)csmObject;
        String specializationContainerName = ((Object)fun.getQualifiedName()).toString();
        int endInd = specializationContainerName.lastIndexOf("::");
        if (endInd > 0) {
            specializationContainerName = CsmDisplayUtilities.htmlize((CharSequence)specializationContainerName.substring(0, endInd));
            in = NbBundle.getMessage(this.getClass(), (String)"LBL_forClassSpecialization", (Object)specializationContainerName);
        } else {
            in = "";
        }
        return CharSequences.create((CharSequence)in);
    }

    private static CharSequence getClassifierName(CsmClassifier cls) {
        CharSequence clsName = cls.getName();
        if (CsmKindUtilities.isClass((CsmObject)cls) && CsmKindUtilities.isTemplate((CsmObject)cls)) {
            clsName = ((CsmTemplate)cls).getDisplayName();
        }
        return clsName;
    }

    private byte getObjectWeight() {
        try {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.object)) {
                CsmFunction function = ((CsmFunctionDefinition)this.object).getDeclaration();
                if (function != null && !function.equals(this.object) && CsmKindUtilities.isClassMember((CsmObject)function)) {
                    CsmClass cls = ((CsmMember)function).getContainingClass();
                    if (cls != null && cls.getName().length() > 0) {
                        this.scopeName = CppDeclarationNode.getClassifierName((CsmClassifier)cls);
                    } else if (CsmKindUtilities.isSpecialization((CsmObject)function)) {
                        this.isSpecialization = true;
                        this.scopeName = this.getFunctionSpecializationName((CsmObject)function);
                    }
                } else if (CsmKindUtilities.isSpecialization((CsmObject)this.object)) {
                    this.isSpecialization = true;
                    this.scopeName = this.getFunctionSpecializationName(this.object);
                }
            } else if (CsmKindUtilities.isVariableDefinition((CsmObject)this.object)) {
                CsmClass cls;
                CsmVariable variable = ((CsmVariableDefinition)this.object).getDeclaration();
                if (variable != null && !variable.equals(this.object) && CsmKindUtilities.isClassMember((CsmObject)variable) && (cls = ((CsmMember)variable).getContainingClass()) != null && cls.getName().length() > 0) {
                    this.scopeName = CppDeclarationNode.getClassifierName((CsmClassifier)cls);
                }
            } else if (CsmKindUtilities.isFunction((CsmObject)this.object) && CsmKindUtilities.isSpecialization((CsmObject)this.object)) {
                this.isSpecialization = true;
                this.scopeName = this.getFunctionSpecializationName(this.object);
            }
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)this.object)) {
            return 2;
        }
        if (CsmKindUtilities.isFile((CsmObject)this.object)) {
            return 0;
        }
        if (CsmKindUtilities.isNamespaceAlias((CsmObject)this.object)) {
            return 0;
        }
        if (CsmKindUtilities.isUsing((CsmObject)this.object)) {
            return 1;
        }
        if (CsmKindUtilities.isModule((CsmObject)this.object)) {
            return 3;
        }
        if (CsmKindUtilities.isProgram((CsmObject)this.object)) {
            return 4;
        }
        if (CsmKindUtilities.isClass((CsmObject)this.object)) {
            return 11;
        }
        if (CsmKindUtilities.isFriendClass((CsmObject)this.object)) {
            return 10;
        }
        if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)this.object)) {
            return 10;
        }
        if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)this.object)) {
            return 10;
        }
        if (CsmKindUtilities.isEnum((CsmObject)this.object)) {
            return 11;
        }
        if (CsmKindUtilities.isTypedef((CsmObject)this.object)) {
            return 12;
        }
        if (CsmKindUtilities.isVariableDeclaration((CsmObject)this.object)) {
            return 20;
        }
        if (CsmKindUtilities.isVariableDefinition((CsmObject)this.object)) {
            return 21;
        }
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)this.object)) {
            return 30;
        }
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.object)) {
            return 31;
        }
        if (CsmKindUtilities.isMacro((CsmObject)this.object)) {
            return 40;
        }
        if (CsmKindUtilities.isInclude((CsmObject)this.object)) {
            return 50;
        }
        return 90;
    }

    public CsmObject getCsmObject() {
        if (CsmKindUtilities.isCsmObject((Object)this.object)) {
            return this.object;
        }
        return null;
    }

    int getOffset() {
        if (CsmKindUtilities.isOffsetable((Object)this.object)) {
            return ((CsmOffsetable)this.object).getStartOffset();
        }
        return 0;
    }

    void resetNode(CppDeclarationNode node) {
        if (this.object != node.object) {
            this.ic.remove((Object)this.object);
            this.object = node.object;
            this.ic.add((Object)this.object);
        }
        this.file = this.object instanceof CsmFile ? (CsmFile)this.object : ((CsmOffsetable)this.object).getContainingFile();
        this.weight = node.weight;
        this.scopeName = node.scopeName;
        this.isFriend = node.isFriend;
        this.isSpecialization = node.isSpecialization;
        this.needInitHTML = node.needInitHTML;
        this.htmlDisplayName = node.htmlDisplayName;
        this.icon = node.icon;
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
    }

    @Override
    public int compareTo(CppDeclarationNode o) {
        int res = this.compareToWithoutOffset(o);
        if (res == 0) {
            int start1 = 0;
            if (this.object instanceof CsmOffsetable) {
                start1 = ((CsmOffsetable)this.object).getStartOffset();
            }
            int start2 = 0;
            if (o.object instanceof CsmOffsetable) {
                start2 = ((CsmOffsetable)o.object).getStartOffset();
            }
            res = start1 - start2;
        }
        return res;
    }

    public int compareToWithoutOffset(CppDeclarationNode o) {
        int res = 0;
        switch (this.model.getFilter().getSortMode()) {
            case Name: {
                res = CharSequences.comparator().compare(this.scopeName, o.scopeName);
                if (res != 0) break;
                if (this.model.getFilter().isGroupByKind()) {
                    res = this.weight / 10 - o.weight / 10;
                    if (res != 0 || (res = this.getDisplayName().compareTo(o.getDisplayName())) != 0) break;
                    res = this.weight - o.weight;
                    break;
                }
                res = this.getDisplayName().compareTo(o.getDisplayName());
                if (res != 0) break;
                res = this.weight - o.weight;
                break;
            }
            case Offset: {
                if (!this.model.getFilter().isGroupByKind()) break;
                res = this.weight / 10 - o.weight / 10;
            }
        }
        return res;
    }

    public String getName() {
        return ((Object)this.name).toString();
    }

    public String getHtmlDisplayName() {
        CharSequence html = this.htmlDisplayName;
        if (this.needInitHTML) {
            this.htmlDisplayName = html = this.createHtmlDisplayName();
            this.needInitHTML = false;
        }
        if (html != null) {
            return ((Object)html).toString();
        }
        return null;
    }

    private CharSequence createHtmlDisplayName() {
        try {
            CsmObject csmObject = this.getCsmObject();
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                if (this.scopeName.length() > 0) {
                    if (this.isSpecialization) {
                        return this.createFunctionSpecializationHtmlDisplayName();
                    }
                    return this.createMemberHtmlDisplayName();
                }
            } else if (CsmKindUtilities.isVariableDefinition((CsmObject)csmObject)) {
                if (this.scopeName.length() > 0) {
                    return this.createMemberHtmlDisplayName();
                }
            } else {
                if (csmObject instanceof CsmFile) {
                    if (this.model.getUnopenedProject() != null) {
                        return CharSequences.create((CharSequence)("<font color='" + CsmDisplayUtilities.getHTMLColor((Color)Color.red) + ">" + NbBundle.getMessage(CppDeclarationNode.class, (String)"UnopenedProject", (Object)ProjectUtils.getInformation((Project)this.model.getUnopenedProject()).getDisplayName())));
                    }
                    return CharSequences.create((CharSequence)("<font color='" + CsmDisplayUtilities.getHTMLColor((Color)Color.red) + ">" + NbBundle.getMessage(CppDeclarationNode.class, (String)"StandAloneFile")));
                }
                if (CsmKindUtilities.isFunction((CsmObject)csmObject) && CsmKindUtilities.isSpecialization((CsmObject)csmObject) && this.scopeName.length() > 0 && this.isSpecialization) {
                    return this.createFunctionSpecializationHtmlDisplayName();
                }
            }
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    public String getDisplayName() {
        if (this.object instanceof CsmFile) {
            return " " + super.getDisplayName();
        }
        return super.getDisplayName();
    }

    public Image getIcon(int param) {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.file != null && !this.file.isValid()) {
            if (this.object instanceof CsmOffsetable) {
                return super.superGetIcon(param);
            }
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/qnavigator/resources/exclamation.gif");
        }
        if (this.isFriend) {
            CsmFriend csmObj = (CsmFriend)this.object;
            return csmObj == null ? super.getIcon(param) : CsmImageLoader.getFriendFunctionImage((CsmFriend)csmObj);
        }
        if (this.object instanceof CsmOffsetable) {
            return super.getIcon(param);
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/qnavigator/resources/exclamation.gif");
    }

    public Image getOpenedIcon(int param) {
        return this.getIcon(param);
    }

    public Action getPreferredAction() {
        Project project;
        if (CsmKindUtilities.isOffsetable((Object)this.object)) {
            return new GoToDeclarationAction((CsmOffsetable)this.object);
        }
        if (this.object instanceof CsmFile && (project = this.model.getUnopenedProject()) != null) {
            return new OpenContainingProjectAction(project);
        }
        return null;
    }

    public Action[] getActions(boolean context) {
        Action action = this.getPreferredAction();
        if (action != null) {
            ArrayList<Action> list = new ArrayList<Action>();
            list.add(action);
            if (CsmRefactoringActionsFactory.supportRefactoring((CsmFile)this.file)) {
                list.add((Action)RefactoringActionsFactory.renameAction());
                list.add((Action)RefactoringActionsFactory.whereUsedAction());
                CsmObject obj = this.getCsmObject();
                if (CsmKindUtilities.isField((CsmObject)obj) || CsmKindUtilities.isClass((CsmObject)obj)) {
                    list.add((Action)CsmRefactoringActionsFactory.encapsulateFieldsAction());
                } else if (CsmKindUtilities.isFunction((CsmObject)obj) && !CsmKindUtilities.isDestructor((CsmObject)obj)) {
                    list.add((Action)CsmRefactoringActionsFactory.changeParametersAction());
                }
            }
            list.add(null);
            list.addAll(Arrays.asList(this.model.getActions()));
            return list.toArray(new Action[list.size()]);
        }
        return this.model.getActions();
    }

    public static CppDeclarationNode nodeFactory(CsmObject element, CsmFileModel model, boolean isFriend, List<IndexOffsetNode> lineNumberIndex) {
        if (!(element instanceof CsmFile) && !model.getFilter().isApplicable((CsmOffsetable)element)) {
            return null;
        }
        CppDeclarationNode node = null;
        if (CsmKindUtilities.isTypedef((CsmObject)element)) {
            CsmClassifier cls;
            CsmTypedef def = (CsmTypedef)element;
            if (def.isTypeUnnamed() && (cls = def.getType().getClassifier()) != null && cls.getName().length() == 0 && cls instanceof CsmCompoundClassifier) {
                node = CppDeclarationNode.createClassifierContainer((CsmOffsetableDeclaration)element, model, (CsmCompoundClassifier)cls, lineNumberIndex);
                node.name = ((CsmDeclaration)element).getName();
                return node;
            }
            node = CppDeclarationNode.createDeclaration((CsmOffsetableDeclaration)element, model, isFriend);
            node.name = ((CsmDeclaration)element).getName();
            model.addOffset((Node)node, (CsmOffsetable)element, lineNumberIndex);
            return node;
        }
        if (CsmKindUtilities.isClassifier((CsmObject)element)) {
            Collection list;
            CharSequence name = ((CsmClassifier)element).getName();
            if (name.length() == 0 && element instanceof CsmCompoundClassifier && (list = ((CsmCompoundClassifier)element).getEnclosingTypedefs()).size() > 0) {
                return null;
            }
            if (CsmKindUtilities.isTemplate((CsmObject)element) && ((CsmTemplate)element).isExplicitSpecialization()) {
                return null;
            }
            node = CsmKindUtilities.isClassForwardDeclaration((CsmObject)element) || CsmKindUtilities.isEnumForwardDeclaration((CsmObject)element) ? CppDeclarationNode.createObject((CsmOffsetable)((CsmOffsetableDeclaration)element), model) : CppDeclarationNode.createNamespaseContainer((CsmOffsetableDeclaration)element, model, lineNumberIndex);
            node.name = CppDeclarationNode.getClassifierName((CsmClassifier)element);
            model.addOffset((Node)node, (CsmOffsetable)element, lineNumberIndex);
            return node;
        }
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)element)) {
            node = CppDeclarationNode.createNamespaseContainer((CsmOffsetableDeclaration)((CsmNamespaceDefinition)element), model, lineNumberIndex);
            node.name = ((CsmNamespaceDefinition)element).getName();
            model.addOffset((Node)node, (CsmOffsetable)element, lineNumberIndex);
            return node;
        }
        if (CsmKindUtilities.isDeclaration((CsmObject)element)) {
            if (CsmKindUtilities.isFunction((CsmObject)element)) {
                node = CppDeclarationNode.createDeclaration((CsmOffsetableDeclaration)element, model, isFriend);
                node.name = CharSequences.create((CharSequence)CsmUtilities.getSignature((CsmFunction)((CsmFunction)element), (boolean)true));
            } else {
                if (CsmKindUtilities.isFunctionExplicitInstantiation((CsmObject)element)) {
                    return null;
                }
                CharSequence name = ((CsmDeclaration)element).getName();
                if (name.length() == 0 && CsmKindUtilities.isVariable((CsmObject)element)) {
                    return node;
                }
                node = CppDeclarationNode.createDeclaration((CsmOffsetableDeclaration)element, model, isFriend);
                node.name = name;
            }
            model.addOffset((Node)node, (CsmOffsetable)element, lineNumberIndex);
            return node;
        }
        if (CsmKindUtilities.isEnumerator((Object)element)) {
            node = CppDeclarationNode.createObject((CsmOffsetable)((CsmEnumerator)element), model);
            node.name = ((CsmEnumerator)element).getName();
            model.addOffset((Node)node, (CsmOffsetable)element, lineNumberIndex);
            return node;
        }
        if (CsmKindUtilities.isMacro((CsmObject)element)) {
            node = CppDeclarationNode.createObject((CsmOffsetable)((CsmMacro)element), model);
            node.name = ((CsmMacro)element).getName();
            model.addOffset((Node)node, (CsmOffsetable)element, lineNumberIndex);
            return node;
        }
        if (element instanceof CsmInclude) {
            node = CppDeclarationNode.createObject((CsmOffsetable)((CsmInclude)element), model);
            node.name = ((CsmInclude)element).getIncludeName();
            model.addOffset((Node)node, (CsmOffsetable)element, lineNumberIndex);
            return node;
        }
        if (element instanceof CsmFile) {
            node = CppDeclarationNode.createFile((CsmFile)element, model);
            node.name = ((CsmFile)element).getName();
            model.addFileOffset((Node)node, (CsmFile)element, lineNumberIndex);
            return node;
        }
        return node;
    }
}

