/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public abstract class AbstractTaskSchema {
    private final Map<String, Field> fieldByKey = new LinkedHashMap<String, Field>();

    public Field getFieldByKey(String taskKey) {
        return this.fieldByKey.get(taskKey);
    }

    public void initialize(TaskData taskData) {
        for (Field field : this.fieldByKey.values()) {
            field.createAttribute(taskData.getRoot());
        }
    }

    protected Field createField(String key, String label, String type) {
        return this.createField(key, label, type, (String)null, (Flag[])null);
    }

    protected Field createField(String key, String label, String type, Flag ... flags) {
        return this.createField(key, label, type, (String)null, flags);
    }

    protected Field createField(String key, String label, String type, String indexKey, Flag ... flags) {
        Field field = new Field(key, label, type, indexKey, flags);
        this.fieldByKey.put(key, field);
        return field;
    }

    protected FieldFactory inheritFrom(Field source) {
        return new FieldFactory(source);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Field {
        private EnumSet<Flag> flags;
        private final String key;
        private final String label;
        private final String type;
        private final String indexKey;

        protected Field(String key, String label, String type) {
            this(key, label, type, (String)null, (Flag[])null);
        }

        protected Field(String key, String label, String type, Flag ... flags) {
            this(key, label, type, (String)null, flags);
        }

        public Field(String key, String label, String type, String indexKey, Flag ... flags) {
            Assert.isNotNull((Object)key);
            Assert.isNotNull((Object)label);
            Assert.isNotNull((Object)type);
            this.key = key;
            this.label = label;
            this.type = type;
            this.indexKey = indexKey;
            this.flags = flags == null || flags.length == 0 ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(Arrays.asList(flags));
        }

        public TaskAttribute createAttribute(TaskAttribute parent) {
            TaskAttribute attribute = parent.createMappedAttribute(this.getKey());
            TaskAttributeMetaData metaData = attribute.getMetaData();
            metaData.setLabel(this.getLabel());
            metaData.setType(this.getType());
            metaData.setReadOnly(this.isReadOnly());
            metaData.setKind(this.getKind());
            Map<String, String> options = this.getDefaultOptions();
            if (options != null) {
                for (Map.Entry<String, String> option : options.entrySet()) {
                    attribute.putOption(option.getKey(), option.getValue());
                }
            }
            return attribute;
        }

        public Map<String, String> getDefaultOptions() {
            return Collections.emptyMap();
        }

        public String getKey() {
            return this.key;
        }

        public String getIndexKey() {
            return this.indexKey;
        }

        public String getKind() {
            if (this.flags.contains((Object)Flag.ATTRIBUTE)) {
                return "task.common.kind.default";
            }
            if (this.flags.contains((Object)Flag.PEOPLE)) {
                return "task.common.kind.people";
            }
            if (this.flags.contains((Object)Flag.OPERATION)) {
                return "task.common.kind.operation";
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return this.flags.contains((Object)Flag.READ_ONLY);
        }

        public String toString() {
            return this.getLabel();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.indexKey == null ? 0 : this.indexKey.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            if (this.indexKey == null ? other.indexKey != null : !this.indexKey.equals(other.indexKey)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }

    protected class FieldFactory {
        private EnumSet<Flag> flags;
        private String key;
        private String label;
        private String type;

        public FieldFactory(Field source) {
            this.flags = EnumSet.copyOf(source.flags);
            this.key = source.key;
            this.label = source.label;
            this.type = source.type;
        }

        public FieldFactory addFlags(Flag ... flags) {
            this.flags.addAll(Arrays.asList(flags));
            return this;
        }

        public Field create() {
            return AbstractTaskSchema.this.createField(this.key, this.label, this.type, !this.flags.isEmpty() ? this.flags.toArray(new Flag[0]) : null);
        }

        public FieldFactory flags(Flag ... flags) {
            this.flags = EnumSet.copyOf(Arrays.asList(flags));
            return this;
        }

        public FieldFactory key(String key) {
            this.key = key;
            return this;
        }

        public FieldFactory label(String label) {
            this.label = label;
            return this;
        }

        public FieldFactory removeFlags(Flag ... flags) {
            this.flags.removeAll(Arrays.asList(flags));
            return this;
        }

        public FieldFactory type(String type) {
            this.type = type;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        ATTRIBUTE,
        OPERATION,
        PEOPLE,
        READ_ONLY;

    }
}

