/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.context;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.context.AbstractTaskContextStore;

public class DefaultTaskContextStore
extends AbstractTaskContextStore {
    public static final String CONTEXT_FILENAME_ENCODING = "UTF-8";
    public static final String CONTEXT_FILE_EXTENSION = ".xml.zip";
    private File directory;
    private File contextDirectory;

    public IAdaptable copyContext(ITask sourceTask, ITask destinationTask) {
        return null;
    }

    public void clearContext(ITask task) {
        File file = this.getFileForContext(task);
        if (file.exists()) {
            file.delete();
        }
    }

    public void deleteContext(ITask task) {
        File file = this.getFileForContext(task);
        if (file.exists()) {
            file.delete();
        }
    }

    public File getFileForContext(ITask task) {
        String handleIdentifier = task.getHandleIdentifier();
        try {
            String encoded = URLEncoder.encode(handleIdentifier, CONTEXT_FILENAME_ENCODING);
            File contextDirectory = this.getContextDirectory();
            File contextFile = new File(contextDirectory, String.valueOf(encoded) + CONTEXT_FILE_EXTENSION);
            return contextFile;
        }
        catch (UnsupportedEncodingException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not determine path for context", (Throwable)e));
            return null;
        }
    }

    public boolean hasContext(ITask task) {
        File file = this.getFileForContext(task);
        return file.exists();
    }

    public void mergeContext(ITask sourceTask, ITask targetTask) {
    }

    public IAdaptable moveContext(ITask sourceTask, ITask destinationTask) {
        return null;
    }

    public void refactorRepositoryUrl(TaskRepository repository, String oldRepositoryUrl, String newRepositoryUrl) {
    }

    public void saveActiveContext() {
    }

    public synchronized void setDirectory(File directory) {
        this.directory = directory;
        this.contextDirectory = new File(directory.getParent(), "contexts");
        if (!this.contextDirectory.exists()) {
            this.contextDirectory.mkdirs();
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    private File getContextDirectory() {
        return this.contextDirectory;
    }
}

