/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.Bundle;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.DesignSupport;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.OutlineView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Task;
import org.openide.util.TaskListener;

final class LayoutLaunchingPanel
extends BasicWizardIterator.Panel
implements TaskListener,
Runnable,
ExplorerManager.Provider {
    private AtomicReference<FileObject> userDir = new AtomicReference();
    private NewTCIterator.DataModel data;
    private Task task;
    private ProgressHandle handle;
    private ExplorerManager em;
    private OutlineView outlineView;
    private JPanel progress;
    private JPanel tree;

    public LayoutLaunchingPanel(WizardDescriptor setting, NewTCIterator.DataModel data) {
        super(setting);
        this.data = data;
        AbstractNode root = new AbstractNode((Children)new Children.Array());
        this.em = new ExplorerManager();
        this.em.setRootContext((Node)root);
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", Bundle.LBL_LayoutingWizardTitle());
    }

    public void addNotify() {
        super.addNotify();
        if (this.outlineView == null) {
            this.outlineView = new OutlineView(Bundle.CTL_FoundModes());
            this.outlineView.getOutline().setRootVisible(false);
            this.tree.add((Component)this.outlineView);
            this.outlineView.setDefaultActionAllowed(false);
            this.outlineView.setVisible(false);
            this.tree.setMinimumSize(this.outlineView.getPreferredSize());
        }
    }

    @Override
    protected void storeToDataModel() {
        for (Node n : this.getExplorerManager().getRootContext().getChildren().getNodes()) {
            ModeNode mn = (ModeNode)n;
            if (!mn.isSelected().booleanValue()) continue;
            this.data.defineMode(mn.getName(), mn.text);
        }
    }

    @Override
    protected void readFromDataModel() {
        this.checkValidity();
        if (this.task == null) {
            try {
                this.task = DesignSupport.invokeDesignMode(this.data.getProject(), this.userDir, false, !this.data.isIgnorePreviousRun());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.handle = ProgressHandleFactory.createHandle((String)Bundle.MSG_LaunchingApplication());
            JComponent pc = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
            JLabel ml = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)this.handle);
            this.progress.add(ml);
            this.progress.add(pc);
            this.handle.start();
            this.markInvalid();
            this.task.addTaskListener((TaskListener)this);
        }
    }

    @Override
    protected String getPanelName() {
        return Bundle.LBL_DesignLayout();
    }

    private boolean checkValidity() {
        int cnt = 0;
        for (Node node : this.getExplorerManager().getRootContext().getChildren().getNodes()) {
            ModeNode mn;
            if (!(node instanceof ModeNode) || !(mn = (ModeNode)node).isSelected().booleanValue()) continue;
            ++cnt;
        }
        if (cnt == 0 || !this.outlineView.isVisible()) {
            this.markInvalid();
            return false;
        }
        this.markValid();
        return true;
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(LayoutLaunchingPanel.class);
    }

    private void initComponents() {
        this.progress = new JPanel();
        this.tree = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        this.add(this.progress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 11;
        this.add(this.tree, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Bundle.ACS_DesignPanel());
    }

    public void taskFinished(Task task) {
        this.handle.finish();
        FileObject modeDir = this.userDir.get().getFileObject("config/Windows2Local/Modes");
        boolean one = false;
        Children ch = this.getExplorerManager().getRootContext().getChildren();
        if (modeDir != null) {
            try {
                FileSystem layer = DesignSupport.findLayer(this.data.getProject());
                if (layer == null) {
                    throw new IOException("Cannot find layer in " + this.data.getProject());
                }
                this.data.setSFS(layer);
                for (FileObject m : modeDir.getChildren()) {
                    if (!m.isData() || !"wsmode".equals(m.getExt())) continue;
                    ModeNode mn = new ModeNode(m, this.data);
                    ch.add(new Node[]{mn});
                    one = true;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (!one) {
            AbstractNode empty = new AbstractNode(Children.LEAF);
            empty.setName("empty");
            empty.setDisplayName(Bundle.LBL_NoModesFound());
            empty.setShortDescription(Bundle.MSG_NoModesFound());
            ch.add(new Node[]{empty});
            this.markInvalid();
        } else {
            this.markValid();
        }
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        this.progress.setVisible(false);
        this.outlineView.setVisible(true);
        this.progress.invalidate();
        this.outlineView.invalidate();
        this.validate();
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    private class ModeNode
    extends AbstractNode
    implements CheckableNode {
        private final FileObject mode;
        private final String text;
        private boolean selected;

        public ModeNode(FileObject mode, NewTCIterator.DataModel data) throws IOException {
            super(Children.LEAF);
            this.mode = mode;
            this.text = DesignSupport.readMode(mode);
            this.selected = !data.isExistingMode(mode.getName());
            this.setName(mode.getName());
        }

        public boolean isCheckable() {
            return true;
        }

        public boolean isCheckEnabled() {
            return true;
        }

        public Boolean isSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = Boolean.TRUE.equals(selected);
            LayoutLaunchingPanel.this.checkValidity();
        }
    }
}

