/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadGroupReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMOutOfMemoryExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ThreadsTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(116) >= 0;
    private JPDADebuggerImpl debugger;
    private Map<Object, ChildrenTree> childrenCache = new WeakHashMap<Object, ChildrenTree>();
    private Listener listener;
    private Collection<ModelListener> listeners = new HashSet<ModelListener>();

    public ThreadsTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        Object[] ch;
        ChildrenTree cht;
        Map<Object, ChildrenTree> map = this.childrenCache;
        synchronized (map) {
            cht = this.childrenCache.get(o);
            ch = cht != null ? cht.getChildren() : null;
        }
        if (ch == null) {
            ch = this.computeChildren(o);
            if (ch == null) {
                throw new UnknownTypeException(o);
            }
            map = this.childrenCache;
            synchronized (map) {
                cht = new ChildrenTree();
                cht.setChildren(ch);
                this.childrenCache.put(o, cht);
            }
        }
        int l = ch.length;
        from = Math.min(l, from);
        to = Math.min(l, to);
        if (from == 0 && to == l) {
            return ch;
        }
        Object[] ch1 = new Object[to - from];
        System.arraycopy(ch, from, ch1, 0, to - from);
        ch = ch1;
        return ch;
    }

    private Object[] computeChildren(Object node) {
        if (node.equals("Root")) {
            if (verbose) {
                VirtualMachine vm = this.debugger.getVirtualMachine();
                if (vm == null) {
                    System.err.println("\nThreadsTreeModel.computeChildren():\nVM is null!\n");
                } else {
                    try {
                        List<ThreadReference> threads = VirtualMachineWrapper.allThreads(vm);
                        System.err.println("\nThreadsTreeModel.computeChildren() ALL Threads:");
                        for (ThreadReference t : threads) {
                            System.err.println("  " + ThreadReferenceWrapper.name(t) + " is suspended: " + ThreadReferenceWrapper.isSuspended(t) + ", suspend count = " + ThreadReferenceWrapper.suspendCount(t));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.err.println("");
                }
            }
            return this.debugger.getTopLevelThreadGroups();
        }
        if (node instanceof JPDAThreadGroup) {
            JPDAThreadGroup tg = (JPDAThreadGroup)node;
            JPDAThreadGroup[] tgs = tg.getThreadGroups();
            JPDAThread[] ts = tg.getThreads();
            int n = tgs.length + ts.length;
            Object[] ch = new Object[n];
            System.arraycopy(tgs, 0, ch, 0, tgs.length);
            System.arraycopy(ts, 0, ch, tgs.length, ts.length);
            return ch;
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeChildren() {
        Map<Object, ChildrenTree> map = this.childrenCache;
        synchronized (map) {
            this.recomputeChildren(this.getRoot());
        }
    }

    private void recomputeChildren(Object node) {
        ChildrenTree cht = this.childrenCache.get(node);
        if (cht != null) {
            Set<Object> keys = this.childrenCache.keySet();
            Object[] newCh = this.computeChildren(node);
            cht.setChildren(newCh);
            for (int i = 0; i < newCh.length; ++i) {
                if (!keys.contains(newCh[i])) continue;
                this.recomputeChildren(newCh[i]);
            }
        }
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(Object o) throws UnknownTypeException {
        if (o instanceof JPDAThread) {
            return true;
        }
        if (o instanceof JPDAThreadGroup) {
            return false;
        }
        if (o == "Root") {
            return false;
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        ModelListener[] ls;
        this.recomputeChildren();
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            ls = this.listeners.toArray(new ModelListener[0]);
        }
        ModelEvent.TreeChanged ev = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].modelChanged((ModelEvent)ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeChanged(Object node) {
        ModelListener[] ls;
        this.recomputeChildren();
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            ls = this.listeners.toArray(new ModelListener[0]);
        }
        ModelEvent.NodeChanged ev = new ModelEvent.NodeChanged((Object)this, node);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].modelChanged((ModelEvent)ev);
        }
    }

    private static class ChildrenTree {
        private Object[] ch;

        public void setChildren(Object[] ch) {
            this.ch = ch;
        }

        public Object[] getChildren() {
            return this.ch;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebuggerImpl debugger;
        private ThreadsCache tc;
        private WeakReference<ThreadsTreeModel> model;
        private RequestProcessor.Task task;
        private Set<Object> nodesToRefresh;

        public Listener(ThreadsTreeModel tm, JPDADebuggerImpl debugger) {
            this.debugger = debugger;
            this.tc = debugger.getThreadsCache();
            this.model = new WeakReference<ThreadsTreeModel>(tm);
            this.tc.addPropertyChangeListener(this);
        }

        private ThreadsTreeModel getModel() {
            ThreadsTreeModel tm = (ThreadsTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            this.tc.removePropertyChangeListener(this);
            Listener listener = this;
            synchronized (listener) {
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("TTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
            }
        }

        private RequestProcessor.Task createTask() {
            RequestProcessor.Task task = this.debugger.getRequestProcessor().create((Runnable)new RefreshTree());
            if (verbose) {
                System.out.println("TTM  create task " + task);
            }
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ThreadGroupReference tg;
            ThreadReference t;
            if (e.getPropertyName() == "threadStarted") {
                t = (ThreadReference)e.getNewValue();
                try {
                    tg = ThreadReferenceWrapper.threadGroup(t);
                }
                catch (InternalExceptionWrapper ex) {
                    tg = null;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return;
                }
                catch (VMOutOfMemoryExceptionWrapper ex) {
                    return;
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    return;
                }
                catch (IllegalThreadStateExceptionWrapper ex) {
                    tg = null;
                }
            } else if (e.getPropertyName() == "threadDied") {
                t = (ThreadReference)e.getOldValue();
                try {
                    tg = ThreadReferenceWrapper.threadGroup(t);
                }
                catch (InternalExceptionWrapper ex) {
                    tg = null;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return;
                }
                catch (VMOutOfMemoryExceptionWrapper ex) {
                    tg = null;
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    tg = null;
                }
                catch (IllegalThreadStateExceptionWrapper ex) {
                    tg = null;
                }
            } else if (e.getPropertyName() == "groupAdded") {
                tg = (ThreadGroupReference)e.getNewValue();
                try {
                    tg = ThreadGroupReferenceWrapper.parent(tg);
                }
                catch (InternalExceptionWrapper ex) {
                    tg = null;
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    tg = null;
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    tg = null;
                }
            } else {
                return;
            }
            String node = tg == null ? "Root" : this.debugger.getThreadGroup(tg);
            Listener listener = this;
            synchronized (listener) {
                if (this.task == null) {
                    this.task = this.createTask();
                }
                if (this.nodesToRefresh == null) {
                    this.nodesToRefresh = new LinkedHashSet<Object>();
                }
                this.nodesToRefresh.add(node);
                this.task.schedule(100);
            }
        }

        private class RefreshTree
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList nodes;
                ThreadsTreeModel tm = Listener.this.getModel();
                if (tm == null) {
                    return;
                }
                if (verbose) {
                    System.out.println("TTM do R task " + Listener.this.task);
                }
                Listener listener = Listener.this;
                synchronized (listener) {
                    nodes = new ArrayList(Listener.this.nodesToRefresh);
                    Listener.this.nodesToRefresh.clear();
                }
                for (Object node : nodes) {
                    tm.fireNodeChanged(node);
                }
            }
        }
    }
}

