/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.InterpProtoANSI;
import org.netbeans.lib.terminalemulator.Ops;

public class InterpProtoANSIX
extends InterpProtoANSI {
    protected String text = null;
    private InterpTypeProtoANSIX type;
    private static final InterpTypeProtoANSIX type_singleton = new InterpTypeProtoANSIX();

    public InterpProtoANSIX(Ops ops) {
        super(ops, type_singleton);
        this.type = type_singleton;
        this.setup();
    }

    protected InterpProtoANSIX(Ops ops, InterpTypeProtoANSIX type) {
        super(ops, type);
        this.type = type;
        this.setup();
    }

    @Override
    public String name() {
        return "proto-ansi-x";
    }

    @Override
    public void reset() {
        super.reset();
        this.text = null;
    }

    private void setup() {
    }

    protected static class InterpTypeProtoANSIX
    extends InterpProtoANSI.InterpTypeProtoANSI {
        protected final AbstractInterp.State st_wait = new AbstractInterp.State("wait");
        protected final AbstractInterp.State st_esc_rb = new AbstractInterp.State("esc_rb");
        protected final AbstractInterp.State st_esc_rb_N = new AbstractInterp.State("esc_rb_N");
        protected final AbstractInterp.State st_esc_lb_q = new AbstractInterp.State("esc_lb_q");
        protected final AbstractInterp.State st_esc_lb_b = new AbstractInterp.State("esc_lb_b");
        protected final AbstractInterp.Actor act_D = new ACT_D();
        protected final AbstractInterp.Actor act_start_collect = new ACT_START_COLLECT();
        protected final AbstractInterp.Actor act_collect = new ACT_COLLECT();
        protected final AbstractInterp.Actor act_done_collect_bel = new ACT_DONE_COLLECT_BEL();
        protected final AbstractInterp.Actor act_DEC_private = new ACT_DEC_PRIVATE();

        protected InterpTypeProtoANSIX() {
            char c;
            this.st_esc.setAction('D', this.st_base, this.act_D);
            this.st_esc.setAction(']', this.st_esc_rb, this.act_start_collect);
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.st_esc_rb.setAction(c, this.st_esc_rb_N, this.act_collect);
            }
            for (c = '\u0000'; c < '\u0080'; c = (char)(c + '\u0001')) {
                this.st_esc_rb_N.setAction(c, this.st_esc_rb_N, this.act_collect);
            }
            this.st_esc_rb_N.setAction('\u0007', this.st_base, this.act_done_collect_bel);
            this.st_esc_lb.setAction('?', this.st_esc_lb_q, this.act_reset_number);
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.st_esc_lb_q.setAction(c, this.st_esc_lb_q, this.act_remember_digit);
            }
            this.st_esc_lb_q.setAction('h', this.st_base, this.act_DEC_private);
            this.st_esc_lb_q.setAction('l', this.st_base, this.act_DEC_private);
            this.st_esc_lb_q.setAction('r', this.st_base, this.act_DEC_private);
            this.st_esc_lb_q.setAction('s', this.st_base, this.act_DEC_private);
            this.st_esc_lb.setAction('!', this.st_esc_lb_b, this.act_reset_number);
            this.st_esc_lb_b.setAction('p', this.st_base, new ACT_DEC_STR());
        }

        protected static final class ACT_DEC_STR
        implements AbstractInterp.Actor {
            protected ACT_DEC_STR() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_soft_reset();
                return null;
            }
        }

        static final class ACT_DEC_PRIVATE
        implements AbstractInterp.Actor {
            ACT_DEC_PRIVATE() {
            }

            private static String decPrivateSet(AbstractInterp ai, char c, int n) {
                if (n == 5) {
                    ai.ops.op_reverse(true);
                } else if (n == 25) {
                    ai.ops.op_cursor_visible(true);
                } else {
                    return "act_DEC_private: unrecognized cmd " + c;
                }
                return null;
            }

            private static String decPrivateReset(AbstractInterp ai, char c, int n) {
                if (n == 5) {
                    ai.ops.op_reverse(false);
                } else if (n == 25) {
                    ai.ops.op_cursor_visible(false);
                } else {
                    return "act_DEC_private: unrecognized cmd " + c;
                }
                return null;
            }

            private static String decPrivateSave(AbstractInterp ai, char c, int n) {
                return "act_DEC_private: unrecognized cmd " + c;
            }

            private static String decPrivateRestore(AbstractInterp ai, char c, int n) {
                return "act_DEC_private: unrecognized cmd " + c;
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    return "act_DEC_private: no number";
                }
                int n = ai.numberAt(0);
                switch (c) {
                    case 'h': {
                        return ACT_DEC_PRIVATE.decPrivateSet(ai, c, n);
                    }
                    case 'l': {
                        return ACT_DEC_PRIVATE.decPrivateReset(ai, c, n);
                    }
                    case 'r': {
                        return ACT_DEC_PRIVATE.decPrivateRestore(ai, c, n);
                    }
                    case 's': {
                        return ACT_DEC_PRIVATE.decPrivateSave(ai, c, n);
                    }
                }
                return "act_DEC_private: unrecognized cmd " + c;
            }
        }

        static final class ACT_DONE_COLLECT_BEL
        implements AbstractInterp.Actor {
            ACT_DONE_COLLECT_BEL() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSIX i = (InterpProtoANSIX)ai;
                int semix = i.text.indexOf(59);
                if (semix == -1) {
                    return null;
                }
                String p1 = i.text.substring(0, semix);
                String p2 = i.text.substring(semix + 1);
                int code = Integer.parseInt(p1);
                switch (code) {
                    case 0: {
                        ai.ops.op_icon_name(p2);
                        ai.ops.op_win_title(p2);
                        break;
                    }
                    case 1: {
                        ai.ops.op_icon_name(p2);
                        break;
                    }
                    case 2: {
                        ai.ops.op_win_title(p2);
                        break;
                    }
                    case 3: {
                        ai.ops.op_cwd(p2);
                        break;
                    }
                    case 10: {
                        int semix2 = p2.indexOf(59);
                        if (semix == -1) {
                            return null;
                        }
                        String p3 = p2.substring(semix2 + 1);
                        p2 = p2.substring(0, semix2);
                        ai.ops.op_hyperlink(p2, p3);
                    }
                }
                return null;
            }
        }

        static final class ACT_COLLECT
        implements AbstractInterp.Actor {
            ACT_COLLECT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSIX i = (InterpProtoANSIX)ai;
                i.text = i.text + c;
                return null;
            }
        }

        static final class ACT_START_COLLECT
        implements AbstractInterp.Actor {
            ACT_START_COLLECT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSIX i = (InterpProtoANSIX)ai;
                i.text = "";
                return null;
            }
        }

        static final class ACT_D
        implements AbstractInterp.Actor {
            ACT_D() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_do(1);
                return null;
            }
        }
    }
}

