/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.InterpProtoANSI;
import org.netbeans.lib.terminalemulator.Ops;

public class InterpANSI
extends InterpProtoANSI {
    private InterpTypeANSI type;
    private static final InterpTypeANSI type_singleton = new InterpTypeANSI();

    public InterpANSI(Ops ops) {
        super(ops, type_singleton);
        this.type = type_singleton;
        this.setup();
    }

    protected InterpANSI(Ops ops, InterpTypeANSI type) {
        super(ops, type);
        this.type = type;
        this.setup();
    }

    @Override
    public String name() {
        return "ansi";
    }

    @Override
    public void reset() {
        super.reset();
    }

    private void setup() {
        this.state = this.type.st_base;
    }

    protected static class InterpTypeANSI
    extends InterpProtoANSI.InterpTypeProtoANSI {
        protected InterpTypeANSI() {
            this.st_esc.setAction('7', this.st_base, new ACT_SC());
            this.st_esc.setAction('8', this.st_base, new ACT_RC());
            this.st_esc_lb.setAction('i', this.st_base, new ACT_PRINT());
            this.st_esc_lb.setAction('l', this.st_base, new ACT_RM());
            this.st_esc_lb.setAction('t', this.st_base, new ACT_GLYPH());
        }

        static final class ACT_GLYPH
        implements AbstractInterp.Actor {
            ACT_GLYPH() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    return "ACT GLYPH: missing number";
                }
                int p1 = ai.numberAt(0);
                int p2 = ai.numberAt(1);
                int p3 = ai.numberAt(2);
                if (p1 != 22) {
                    return "ACT GLYPH: op othger than 22 not supported";
                }
                ai.ops.op_glyph(p2, p3);
                return null;
            }
        }

        static final class ACT_PRINT
        implements AbstractInterp.Actor {
            ACT_PRINT() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (!ai.noNumber()) {
                    switch (ai.numberAt(0)) {
                        case 1: 
                        case 4: 
                        case 5: {
                            break;
                        }
                        case 10: {
                            ai.ops.op_time(true);
                            break;
                        }
                        case 11: {
                            ai.ops.op_time(false);
                        }
                    }
                }
                return null;
            }
        }

        static final class ACT_RM
        implements AbstractInterp.Actor {
            ACT_RM() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                if (ai.noNumber()) {
                    ai.ops.op_reset_mode(1);
                } else {
                    ai.ops.op_reset_mode(ai.numberAt(0));
                }
                return null;
            }
        }

        static final class ACT_RC
        implements AbstractInterp.Actor {
            ACT_RC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_rc();
                return null;
            }
        }

        static final class ACT_SC
        implements AbstractInterp.Actor {
            ACT_SC() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_sc();
                return null;
            }
        }
    }
}

