/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.utils;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;

public class ASTChildrenVisitor
implements GroovyCodeVisitor {
    private List<ASTNode> children = new ArrayList<ASTNode>();

    public List<ASTNode> children() {
        return this.children;
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        List<Statement> statements = block.getStatements();
        for (Statement statement : statements) {
            this.children.add(statement);
        }
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        this.children.add(forLoop.getCollectionExpression());
        this.children.add(forLoop.getLoopBlock());
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        this.children.add(loop.getBooleanExpression());
        this.children.add(loop.getLoopBlock());
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement loop) {
        this.children.add(loop.getLoopBlock());
        this.children.add(loop.getBooleanExpression());
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        this.children.add(ifElse.getBooleanExpression());
        this.children.add(ifElse.getIfBlock());
        this.children.add(ifElse.getElseBlock());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        this.children.add(statement.getExpression());
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        this.children.add(statement.getExpression());
    }

    @Override
    public void visitAssertStatement(AssertStatement statement) {
        this.children.add(statement.getBooleanExpression());
        this.children.add(statement.getMessageExpression());
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.children.add(statement.getTryStatement());
        List<CatchStatement> list = statement.getCatchStatements();
        for (CatchStatement catchStatement : list) {
            this.children.add(catchStatement);
        }
        this.children.add(statement.getFinallyStatement());
    }

    @Override
    public void visitSwitch(SwitchStatement statement) {
        this.children.add(statement.getExpression());
        List<CaseStatement> list = statement.getCaseStatements();
        for (CaseStatement caseStatement : list) {
            this.children.add(caseStatement);
        }
        this.children.add(statement.getDefaultStatement());
    }

    @Override
    public void visitCaseStatement(CaseStatement statement) {
        this.children.add(statement.getExpression());
        this.children.add(statement.getCode());
    }

    @Override
    public void visitBreakStatement(BreakStatement statement) {
    }

    @Override
    public void visitContinueStatement(ContinueStatement statement) {
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.children.add(statement.getExpression());
        this.children.add(statement.getCode());
    }

    @Override
    public void visitThrowStatement(ThrowStatement statement) {
        this.children.add(statement.getExpression());
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        this.children.add(call.getObjectExpression());
        this.children.add(call.getMethod());
        this.children.add(call.getArguments());
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        this.children.add(call.getArguments());
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.children.add(call.getArguments());
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        this.children.add(expression.getLeftExpression());
        this.children.add(expression.getRightExpression());
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        this.children.add(expression.getBooleanExpression());
        this.children.add(expression.getTrueExpression());
        this.children.add(expression.getFalseExpression());
    }

    @Override
    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        this.visitTernaryExpression(expression);
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitBooleanExpression(BooleanExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitNotExpression(NotExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        this.children.add(expression.getCode());
    }

    @Override
    public void visitTupleExpression(TupleExpression expression) {
        this.visitListOfExpressions(expression.getExpressions());
    }

    @Override
    public void visitListExpression(ListExpression expression) {
        this.visitListOfExpressions(expression.getExpressions());
    }

    @Override
    public void visitArrayExpression(ArrayExpression expression) {
        this.visitListOfExpressions(expression.getExpressions());
        this.visitListOfExpressions(expression.getSizeExpression());
    }

    @Override
    public void visitMapExpression(MapExpression expression) {
        this.visitListOfExpressions(expression.getMapEntryExpressions());
    }

    @Override
    public void visitMapEntryExpression(MapEntryExpression expression) {
        this.children.add(expression.getKeyExpression());
        this.children.add(expression.getValueExpression());
    }

    @Override
    public void visitRangeExpression(RangeExpression expression) {
        this.children.add(expression.getFrom());
        this.children.add(expression.getTo());
    }

    @Override
    public void visitSpreadExpression(SpreadExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        this.children.add(expression.getExpression());
        this.children.add(expression.getMethodName());
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        this.children.add(expression.getExpression());
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression) {
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.visitBinaryExpression(expression);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression) {
        this.children.add(expression.getObjectExpression());
        this.children.add(expression.getProperty());
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        this.children.add(expression.getObjectExpression());
        this.children.add(expression.getProperty());
    }

    @Override
    public void visitFieldExpression(FieldExpression expression) {
    }

    @Override
    public void visitGStringExpression(GStringExpression expression) {
        this.visitListOfExpressions(expression.getStrings());
        this.visitListOfExpressions(expression.getValues());
    }

    private void visitListOfExpressions(List list) {
        if (list == null) {
            return;
        }
        for (Expression expression : list) {
            if (expression instanceof SpreadExpression) {
                Expression spread = ((SpreadExpression)expression).getExpression();
                this.children.add(spread);
                continue;
            }
            this.children.add(expression);
        }
    }

    @Override
    public void visitCatchStatement(CatchStatement statement) {
        this.children.add(statement.getCode());
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        this.visitTupleExpression(ale);
    }

    @Override
    public void visitClosureListExpression(ClosureListExpression cle) {
        this.visitListOfExpressions(cle.getExpressions());
    }

    @Override
    public void visitBytecodeExpression(BytecodeExpression bce) {
    }
}

