/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.options;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;

public final class CodeStyle {
    private static final String continuationIndentSize = "continuationIndentSize";
    private static final String reformatComments = "reformatComments";
    private static final String indentHtml = "indentHtml";
    private static final String rightMargin = "text-limit-width";
    private final Preferences preferences;
    private final Document doc;

    private CodeStyle(Document doc) {
        this.preferences = CodeStylePreferences.get((Document)doc).getPreferences();
        this.doc = doc;
    }

    public static CodeStyle get(Document doc) {
        return new CodeStyle(doc);
    }

    public int getIndentSize() {
        return IndentUtils.indentLevelSize((Document)this.doc);
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt(continuationIndentSize, 4);
    }

    public boolean isReformatComments() {
        return this.preferences.getBoolean(reformatComments, false);
    }

    public boolean isIndentHtml() {
        return this.preferences.getBoolean(indentHtml, true);
    }

    public int getRightMargin() {
        return this.preferences.getInt(rightMargin, 80);
    }
}

