/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.occurrences;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.netbeans.modules.groovy.editor.api.FindTypeUtils;
import org.netbeans.modules.groovy.editor.api.Methods;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.occurrences.TypeVisitor;

public final class VariableScopeVisitor
extends TypeVisitor {
    private final Set<ASTNode> occurrences = new HashSet<ASTNode>();
    private final ASTNode leafParent;

    public VariableScopeVisitor(SourceUnit sourceUnit, AstPath path, BaseDocument doc, int cursorOffset) {
        super(sourceUnit, path, doc, cursorOffset, true);
        this.leafParent = path.leafParent();
    }

    public Set<ASTNode> getOccurrences() {
        return this.occurrences;
    }

    @Override
    public void visitArrayExpression(ArrayExpression visitedArray) {
        ClassNode visitedType = visitedArray.getElementType();
        String visitedName = ElementUtils.getTypeName(visitedType);
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            ASTNode currentNode = FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset);
            this.addOccurrences(visitedType, (ClassNode)currentNode);
        } else if (this.leaf instanceof Variable) {
            String varName = this.removeParentheses(((Variable)((Object)this.leaf)).getName());
            if (varName.equals(visitedName)) {
                this.occurrences.add(new ASTUtils.FakeASTNode(visitedType, visitedName));
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression && visitedName.equals(((PropertyExpression)this.leafParent).getPropertyAsString())) {
            this.occurrences.add(new ASTUtils.FakeASTNode(visitedType, visitedName));
        }
        super.visitArrayExpression(visitedArray);
    }

    @Override
    protected void visitParameters(Parameter[] parameters, Variable variable) {
        for (Parameter parameter : parameters) {
            ClassNode paramType = parameter.getType();
            if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
                this.addOccurrences(paramType, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
                continue;
            }
            if (!parameter.getName().equals(variable.getName())) continue;
            this.occurrences.add(parameter);
            break;
        }
        super.visitParameters(parameters, variable);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        if (expression.isParameterSpecified() && this.leaf instanceof Variable) {
            this.visitParameters(expression.getParameters(), (Variable)((Object)this.leaf));
        }
        super.visitClosureExpression(expression);
    }

    @Override
    protected boolean isValidToken(Token<GroovyTokenId> currentToken, Token<GroovyTokenId> previousToken) {
        return currentToken.id() == GroovyTokenId.IDENTIFIER || previousToken.id() == GroovyTokenId.IDENTIFIER;
    }

    @Override
    public void visitVariableExpression(VariableExpression variableExpression) {
        ClassNode visitedType = variableExpression.getType();
        String visitedName = variableExpression.getName();
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addOccurrences(visitedType, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        } else if (this.leaf instanceof FieldNode) {
            if (visitedName.equals(((FieldNode)this.leaf).getName())) {
                this.occurrences.add(variableExpression);
            }
        } else if (this.leaf instanceof PropertyNode) {
            if (visitedName.equals(((PropertyNode)this.leaf).getField().getName())) {
                this.occurrences.add(variableExpression);
            }
        } else if (this.leaf instanceof Variable) {
            if (visitedName.equals(((Variable)((Object)this.leaf)).getName())) {
                this.occurrences.add(variableExpression);
            }
        } else if (this.leaf instanceof ForStatement) {
            if (visitedName.equals(((ForStatement)this.leaf).getVariable().getName())) {
                this.occurrences.add(variableExpression);
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression property = (PropertyExpression)this.leafParent;
            if (variableExpression.getName().equals(property.getPropertyAsString())) {
                this.occurrences.add(variableExpression);
            }
        }
        super.visitVariableExpression(variableExpression);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        ClassNode visitedType = !expression.isMultipleAssignmentDeclaration() ? expression.getVariableExpression().getType() : expression.getTupleExpression().getType();
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addOccurrences(visitedType, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        }
        super.visitDeclarationExpression(expression);
    }

    @Override
    public void visitField(FieldNode visitedField) {
        PropertyExpression property;
        ClassNode visitedType = visitedField.getType();
        String visitedName = visitedField.getName();
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addOccurrences(visitedType, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        } else if (this.leaf instanceof FieldNode) {
            if (visitedName.equals(((FieldNode)this.leaf).getName())) {
                this.occurrences.add(visitedField);
            }
        } else if (this.leaf instanceof PropertyNode) {
            if (visitedName.equals(((PropertyNode)this.leaf).getField().getName())) {
                this.occurrences.add(visitedField);
            }
        } else if (this.leaf instanceof Variable) {
            if (visitedName.equals(((Variable)((Object)this.leaf)).getName())) {
                this.occurrences.add(visitedField);
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression && visitedName.equals((property = (PropertyExpression)this.leafParent).getPropertyAsString())) {
            this.occurrences.add(visitedField);
        }
        super.visitField(visitedField);
    }

    @Override
    public void visitMethod(MethodNode methodNode) {
        MethodCallExpression methodCallExpression;
        VariableScope variableScope = methodNode.getVariableScope();
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addMethodOccurrences(methodNode, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        } else if (this.leaf instanceof Variable) {
            String name = ((Variable)((Object)this.leaf)).getName();
            if (variableScope != null && variableScope.getDeclaredVariable(name) != null) {
                return;
            }
        } else if (this.leaf instanceof MethodNode) {
            if (Methods.isSameMethod(methodNode, (MethodNode)this.leaf)) {
                this.occurrences.add(methodNode);
            }
        } else if (this.leaf instanceof DeclarationExpression) {
            VariableExpression variable = ((DeclarationExpression)this.leaf).getVariableExpression();
            if (!variable.isDynamicTyped() && !methodNode.isDynamicReturnType()) {
                this.addMethodOccurrences(methodNode, variable.getType());
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression && Methods.isSameMethod(methodNode, methodCallExpression = (MethodCallExpression)this.leafParent)) {
            this.occurrences.add(methodNode);
        }
        super.visitMethod(methodNode);
    }

    private void addMethodOccurrences(MethodNode visitedMethod, ClassNode findingNode) {
        this.addOccurrences(visitedMethod.getReturnType(), findingNode);
        for (Parameter parameter : visitedMethod.getParameters()) {
            this.addOccurrences(parameter.getType(), findingNode);
        }
    }

    @Override
    public void visitConstructor(ConstructorNode constructor) {
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addConstructorOccurrences(constructor, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        } else {
            VariableScope variableScope = constructor.getVariableScope();
            if (this.leaf instanceof Variable) {
                String name = ((Variable)((Object)this.leaf)).getName();
                if (variableScope != null && variableScope.getDeclaredVariable(name) != null) {
                    return;
                }
            } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
                String name = ((ConstantExpression)this.leaf).getText();
                if (variableScope != null && variableScope.getDeclaredVariable(name) != null) {
                    return;
                }
            }
            if (this.leaf instanceof ConstructorNode) {
                if (Methods.isSameConstructor(constructor, (ConstructorNode)this.leaf)) {
                    this.occurrences.add(constructor);
                }
            } else if (this.leaf instanceof ConstructorCallExpression && Methods.isSameConstructor(constructor, (ConstructorCallExpression)this.leaf) && !constructor.hasNoRealSourcePosition()) {
                this.occurrences.add(constructor);
            }
        }
        super.visitConstructor(constructor);
    }

    private void addConstructorOccurrences(ConstructorNode constructor, ClassNode findingNode) {
        for (Parameter parameter : constructor.getParameters()) {
            this.addOccurrences(parameter.getType(), findingNode);
        }
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCall) {
        if (!FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            if (this.leaf instanceof MethodNode) {
                MethodNode method = (MethodNode)this.leaf;
                if (Methods.isSameMethod(method, methodCall)) {
                    this.occurrences.add(methodCall);
                }
            } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression && Methods.isSameMethod(methodCall, (MethodCallExpression)this.leafParent)) {
                this.occurrences.add(methodCall);
            }
        }
        super.visitMethodCallExpression(methodCall);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            String findingNodeName;
            ClassNode findingNode = (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset);
            String callName = ElementUtils.getNameWithoutPackage(call);
            if (!callName.equals(findingNodeName = ElementUtils.getNameWithoutPackage(findingNode))) {
                this.addOccurrences(call.getType(), findingNode);
            }
        } else if (this.leaf instanceof ConstructorNode) {
            ConstructorNode constructor = (ConstructorNode)this.leaf;
            if (Methods.isSameConstructor(constructor, call)) {
                this.occurrences.add(call);
            }
        } else if (this.leaf instanceof ConstructorCallExpression && Methods.isSameConstuctor(call, (ConstructorCallExpression)this.leaf)) {
            this.occurrences.add(call);
        }
        super.visitConstructorCallExpression(call);
    }

    @Override
    public void visitClassExpression(ClassExpression clazz) {
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addClassExpressionOccurrences(clazz, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        }
        super.visitClassExpression(clazz);
    }

    private void addClassExpressionOccurrences(ClassExpression clazz, ClassNode findingNode) {
        String findingName;
        String visitedName = ElementUtils.getTypeName(clazz);
        if (visitedName.equals(findingName = ElementUtils.getTypeName(findingNode))) {
            this.occurrences.add(clazz);
        }
    }

    @Override
    public void visitClass(ClassNode classNode) {
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addClassNodeOccurrences(classNode, (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        }
        super.visitClass(classNode);
    }

    private void addClassNodeOccurrences(ClassNode visitedNode, ClassNode findingNode) {
        String findingName = ElementUtils.getTypeName(findingNode);
        ClassNode superClass = visitedNode.getUnresolvedSuperClass(false);
        ClassNode[] interfaces = visitedNode.getInterfaces();
        if (findingName.equals(visitedNode.getName())) {
            this.occurrences.add(new ASTUtils.FakeASTNode(visitedNode, visitedNode.getNameWithoutPackage()));
        }
        if (superClass.getLineNumber() > 0 && superClass.getColumnNumber() > 0 && findingName.equals(superClass.getName())) {
            this.occurrences.add(new ASTUtils.FakeASTNode(superClass, superClass.getNameWithoutPackage()));
        }
        for (ClassNode interfaceNode : interfaces) {
            if (interfaceNode.getLineNumber() <= 0 || interfaceNode.getColumnNumber() <= 0 || !findingName.equals(interfaceNode.getName())) continue;
            this.occurrences.add(new ASTUtils.FakeASTNode(interfaceNode, interfaceNode.getNameWithoutPackage()));
        }
    }

    @Override
    public void visitPropertyExpression(PropertyExpression node) {
        Expression property = node.getProperty();
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(node.getPropertyAsString())) {
            this.occurrences.add(property);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyUnderCursor = (PropertyExpression)this.leafParent;
            String nodeAsString = node.getPropertyAsString();
            if (nodeAsString != null && nodeAsString.equals(propertyUnderCursor.getPropertyAsString())) {
                this.occurrences.add(property);
            }
        }
        super.visitPropertyExpression(node);
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addOccurrences(forLoop.getVariableType(), (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        } else {
            Parameter forLoopVar = forLoop.getVariable();
            String varName = forLoopVar.getName();
            if (this.leaf instanceof Variable) {
                if (varName.equals(((Variable)((Object)this.leaf)).getName())) {
                    this.occurrences.add(forLoopVar);
                }
            } else if (this.leaf instanceof ForStatement && varName.equals(((ForStatement)this.leaf).getVariable().getName())) {
                this.occurrences.add(forLoopVar);
            }
        }
        super.visitForLoop(forLoop);
    }

    @Override
    public void visitCatchStatement(CatchStatement statement) {
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            this.addOccurrences(statement.getExceptionType(), (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
        }
        super.visitCatchStatement(statement);
    }

    @Override
    public void visitImports(ModuleNode node) {
        if (FindTypeUtils.isCaretOnClassNode(this.path, this.doc, this.cursorOffset)) {
            for (ImportNode importNode : node.getImports()) {
                this.addOccurrences(importNode.getType(), (ClassNode)FindTypeUtils.findCurrentNode(this.path, this.doc, this.cursorOffset));
            }
        }
        super.visitImports(node);
    }

    private void addOccurrences(ClassNode visitedType, ClassNode findingType) {
        String visitedTypeName = ElementUtils.getTypeName(visitedType);
        String findingName = ElementUtils.getTypeName(findingType);
        String findingNameWithoutPkg = ElementUtils.getTypeNameWithoutPackage(findingType);
        if (visitedTypeName.equals(findingName)) {
            this.occurrences.add(new ASTUtils.FakeASTNode(visitedType, findingNameWithoutPkg));
        }
        this.addGenericsOccurrences(visitedType, findingType);
    }

    private void addGenericsOccurrences(ClassNode visitedType, ClassNode findingNode) {
        String findingTypeName = ElementUtils.getTypeName(findingNode);
        GenericsType[] genericsTypes = visitedType.getGenericsTypes();
        if (genericsTypes != null && genericsTypes.length > 0) {
            for (GenericsType genericsType : genericsTypes) {
                String genericTypeName = genericsType.getType().getName();
                String genericTypeNameWithoutPkg = genericsType.getName();
                if (!genericTypeName.equals(findingTypeName)) continue;
                this.occurrences.add(new ASTUtils.FakeASTNode(genericsType, genericTypeNameWithoutPkg));
            }
        }
    }

    private String removeParentheses(String name) {
        if (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }
}

