/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.language;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.groovy.editor.api.ASTUtils;

public class SemanticAnalysisVisitor
extends ClassCodeVisitorSupport {
    private final ModuleNode root;
    private final BaseDocument doc;
    private final Map<OffsetRange, Set<ColoringAttributes>> highlights;

    public SemanticAnalysisVisitor(ModuleNode root, BaseDocument document) {
        this.root = root;
        this.doc = document;
        this.highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
    }

    public Map<OffsetRange, Set<ColoringAttributes>> annotate() {
        this.highlights.clear();
        for (ClassNode classNode : this.root.getClasses()) {
            this.visitClass(classNode);
        }
        for (MethodNode methodNode : this.root.getMethods()) {
            this.visitMethod(methodNode);
        }
        this.visitBlockStatement(this.root.getStatementBlock());
        return this.highlights;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.root.getContext();
    }

    @Override
    public void visitField(FieldNode node) {
        if (this.isInSource(node)) {
            OffsetRange range = ASTUtils.getRange(node, this.doc);
            EnumSet<ColoringAttributes> attributes = EnumSet.of(ColoringAttributes.FIELD);
            if (node.isStatic()) {
                attributes.add(ColoringAttributes.STATIC);
            }
            this.highlights.put(range, attributes);
        }
        super.visitField(node);
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        if (this.isInSource(node)) {
            OffsetRange range = ASTUtils.getRange(node, this.doc);
            this.highlights.put(range, ColoringAttributes.CONSTRUCTOR_SET);
        }
        super.visitConstructor(node);
    }

    @Override
    public void visitMethod(MethodNode node) {
        if (this.isInSource(node)) {
            OffsetRange range = ASTUtils.getRange(node, this.doc);
            EnumSet<ColoringAttributes> attributes = EnumSet.of(ColoringAttributes.METHOD);
            if (node.isStatic()) {
                attributes.add(ColoringAttributes.STATIC);
            }
            this.highlights.put(range, attributes);
        }
        super.visitMethod(node);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression node) {
        super.visitPropertyExpression(node);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (this.isInSource(node)) {
            OffsetRange range = ASTUtils.getRange(node, this.doc);
            this.highlights.put(range, ColoringAttributes.CLASS_SET);
        }
        super.visitClass(node);
    }

    @Override
    public void visitVariableExpression(VariableExpression node) {
        Variable var = node.getAccessedVariable();
        if (var instanceof FieldNode && this.isInSource(node)) {
            OffsetRange range = ASTUtils.getRange(node, this.doc);
            this.highlights.put(range, ColoringAttributes.FIELD_SET);
        }
        super.visitVariableExpression(node);
    }

    private boolean isInSource(AnnotatedNode node) {
        return node.getLineNumber() > 0 && !node.hasNoRealSourcePosition();
    }
}

