/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.GroovyUtils;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedElement;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedField;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedMethod;
import org.netbeans.modules.groovy.editor.completion.AccessLevel;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;

public final class GroovyElementHandler {
    private static final Logger LOGGER = Logger.getLogger(GroovyElementHandler.class.getName());
    private final ParserResult info;

    private GroovyElementHandler(ParserResult info) {
        this.info = info;
    }

    public static GroovyElementHandler forCompilationInfo(ParserResult info) {
        return new GroovyElementHandler(info);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(GroovyIndex index, String className, String prefix, int anchor, boolean emphasise, Set<AccessLevel> levels, boolean nameOnly) {
        Set<IndexedMethod> methods;
        if (index == null) {
            return Collections.emptyMap();
        }
        String methodName = "";
        if (prefix != null) {
            methodName = prefix;
        }
        if ((methods = methodName.equals("") ? index.getMethods(".*", className, QuerySupport.Kind.REGEXP) : index.getMethods(methodName, className, QuerySupport.Kind.PREFIX)).size() == 0) {
            LOGGER.log(Level.FINEST, "Nothing found in GroovyIndex");
            return Collections.emptyMap();
        }
        LOGGER.log(Level.FINEST, "Found this number of methods : {0} ", methods.size());
        HashMap<MethodSignature, CompletionItem> result = new HashMap<MethodSignature, CompletionItem>();
        for (IndexedMethod indexedMethod : methods) {
            LOGGER.log(Level.FINEST, "method from index : {0} ", indexedMethod.getName());
            if (!this.accept(levels, indexedMethod)) continue;
            List<String> params = indexedMethod.getParameters();
            StringBuffer sb = new StringBuffer();
            for (String string : params) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(GroovyUtils.stripPackage(string));
            }
            result.put(this.getSignature(indexedMethod), CompletionItem.forJavaMethod(className, indexedMethod.getName(), sb.toString(), indexedMethod.getReturnType(), Utilities.gsfModifiersToModel(indexedMethod.getModifiers(), Modifier.PUBLIC), anchor, emphasise, nameOnly));
        }
        return result;
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(GroovyIndex index, String className, String prefix, int anchor, boolean emphasise) {
        Set<IndexedField> fields;
        if (index == null) {
            return Collections.emptyMap();
        }
        String methodName = "";
        if (prefix != null) {
            methodName = prefix;
        }
        if ((fields = methodName.equals("") ? index.getFields(".*", className, QuerySupport.Kind.REGEXP) : index.getFields(methodName, className, QuerySupport.Kind.PREFIX)).size() == 0) {
            LOGGER.log(Level.FINEST, "Nothing found in GroovyIndex");
            return Collections.emptyMap();
        }
        LOGGER.log(Level.FINEST, "Found this number of fields : {0} ", fields.size());
        HashMap<FieldSignature, CompletionItem.JavaFieldItem> result = new HashMap<FieldSignature, CompletionItem.JavaFieldItem>();
        for (IndexedField indexedField : fields) {
            LOGGER.log(Level.FINEST, "field from index : {0} ", indexedField.getName());
            result.put(this.getSignature(indexedField), new CompletionItem.JavaFieldItem(className, indexedField.getName(), null, Utilities.gsfModifiersToModel(indexedField.getModifiers(), Modifier.PRIVATE), anchor, emphasise));
        }
        return result;
    }

    private MethodSignature getSignature(IndexedMethod method) {
        String[] parameters = method.getParameters().toArray(new String[method.getParameters().size()]);
        return new MethodSignature(method.getName(), parameters);
    }

    private FieldSignature getSignature(IndexedField field) {
        return new FieldSignature(field.getName());
    }

    private boolean accept(Set<AccessLevel> levels, IndexedElement element) {
        for (AccessLevel level : levels) {
            if (!level.accept(element.getModifiers())) continue;
            return true;
        }
        return false;
    }
}

