/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedField;
import org.netbeans.modules.groovy.editor.spi.completion.CompletionContext;
import org.netbeans.modules.groovy.editor.spi.completion.DynamicCompletionProvider;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class DynamicElementHandler {
    private static final Logger LOGGER = Logger.getLogger(DynamicElementHandler.class.getName());
    private final ParserResult info;

    private DynamicElementHandler(ParserResult info) {
        this.info = info;
    }

    public static DynamicElementHandler forCompilationInfo(ParserResult info) {
        return new DynamicElementHandler(info);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(String sourceClassName, String className, String prefix, int anchor, boolean nameOnly, boolean leaf, FileObject classSource) {
        if (this.info.getSnapshot().getSource().getFileObject() == null) {
            return Collections.emptyMap();
        }
        CompletionContext context = new CompletionContext(anchor, classSource, sourceClassName, className, prefix, false, this.getProperties(className), leaf, nameOnly);
        HashMap<MethodSignature, CompletionItem> resultDynamic = new HashMap<MethodSignature, CompletionItem>();
        for (DynamicCompletionProvider provider : Lookup.getDefault().lookupAll(DynamicCompletionProvider.class)) {
            for (Map.Entry<MethodSignature, CompletionItem> entry : provider.getMethods(context).entrySet()) {
                if (!entry.getKey().getName().startsWith(prefix)) continue;
                resultDynamic.put(entry.getKey(), entry.getValue());
            }
        }
        return resultDynamic;
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(String sourceClassName, String className, String prefix, int anchor, boolean leaf, FileObject classSource) {
        if (this.info.getSnapshot().getSource().getFileObject() == null) {
            return Collections.emptyMap();
        }
        CompletionContext context = new CompletionContext(anchor, classSource, sourceClassName, className, prefix, false, this.getProperties(className), leaf, false);
        HashMap<FieldSignature, CompletionItem> resultDynamic = new HashMap<FieldSignature, CompletionItem>();
        for (DynamicCompletionProvider provider : Lookup.getDefault().lookupAll(DynamicCompletionProvider.class)) {
            for (Map.Entry<FieldSignature, CompletionItem> entry : provider.getFields(context).entrySet()) {
                if (!entry.getKey().getName().startsWith(prefix)) continue;
                resultDynamic.put(entry.getKey(), entry.getValue());
            }
        }
        return resultDynamic;
    }

    private List<String> getProperties(String className) {
        FileObject f = this.info.getSnapshot().getSource().getFileObject();
        if (f == null) {
            return Collections.emptyList();
        }
        GroovyIndex index = GroovyIndex.get(QuerySupport.findRoots((FileObject)f, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet()));
        Set<IndexedField> fields = index.getFields(".*", className, QuerySupport.Kind.REGEXP);
        if (fields.size() == 0) {
            LOGGER.log(Level.FINEST, "Nothing found in GroovyIndex");
            return Collections.emptyList();
        }
        LOGGER.log(Level.FINEST, "Found this number of fields : {0} ", fields.size());
        ArrayList<String> result = new ArrayList<String>();
        for (IndexedField indexedField : fields) {
            LOGGER.log(Level.FINEST, "field from index : {0} ", indexedField.getName());
            if (indexedField.isStatic() || !indexedField.isProperty()) continue;
            result.add(indexedField.getName());
        }
        return result;
    }
}

