/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedClass;
import org.netbeans.modules.groovy.editor.completion.AccessLevel;
import org.netbeans.modules.groovy.editor.completion.DynamicElementHandler;
import org.netbeans.modules.groovy.editor.completion.GroovyElementHandler;
import org.netbeans.modules.groovy.editor.completion.JavaElementHandler;
import org.netbeans.modules.groovy.editor.completion.MetaElementHandler;
import org.netbeans.modules.groovy.editor.java.Utilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;

public final class CompleteElementHandler {
    private static final Logger LOG = Logger.getLogger(CompleteElementHandler.class.getName());
    private final ParserResult info;
    private final GroovyIndex index;

    private CompleteElementHandler(ParserResult info) {
        this.info = info;
        FileObject fo = info.getSnapshot().getSource().getFileObject();
        this.index = fo != null ? GroovyIndex.get(QuerySupport.findRoots((FileObject)fo, Collections.singleton("classpath/source"), null, null)) : null;
    }

    public static CompleteElementHandler forCompilationInfo(ParserResult info) {
        return new CompleteElementHandler(info);
    }

    public Map<MethodSignature, CompletionItem> getMethods(ClassNode source, ClassNode node, String prefix, int anchor, boolean nameOnly) {
        Map<MethodSignature, CompletionItem> result = this.getMethodsInner(source, node, prefix, anchor, 0, AccessLevel.create(source, node), nameOnly);
        return result;
    }

    public Map<FieldSignature, CompletionItem> getFields(ClassNode source, ClassNode node, String prefix, int anchor) {
        Map<FieldSignature, CompletionItem> result = this.getFieldsInner(source, node, prefix, anchor, 0);
        return result;
    }

    private Map<MethodSignature, CompletionItem> getMethodsInner(ClassNode source, ClassNode node, String prefix, int anchor, int level, Set<AccessLevel> access, boolean nameOnly) {
        boolean leaf = level == 0;
        Set<AccessLevel> modifiedAccess = AccessLevel.update(access, source, node);
        TreeMap<MethodSignature, CompletionItem> result = new TreeMap<MethodSignature, CompletionItem>(new Comparator<MethodSignature>(){

            @Override
            public int compare(MethodSignature method1, MethodSignature method2) {
                if (!method1.getName().equals(method2.getName())) {
                    return method1.getName().compareTo(method2.getName());
                }
                if (method1.getParameters().length < method2.getParameters().length) {
                    return -1;
                }
                if (method1.getParameters().length > method2.getParameters().length) {
                    return 1;
                }
                for (int i = 0; i < method1.getParameters().length; ++i) {
                    String param2;
                    String param1 = method1.getParameters()[i];
                    int comparedValue = param1.compareTo(param2 = method2.getParameters()[i]);
                    if (comparedValue == 0) continue;
                    return comparedValue;
                }
                return 0;
            }
        });
        ClassDefinition definition = this.loadDefinition(node);
        ClassNode typeNode = definition.getNode();
        Map<MethodSignature, ? extends CompletionItem> groovyItems = GroovyElementHandler.forCompilationInfo(this.info).getMethods(this.index, typeNode.getName(), prefix, anchor, leaf, access, nameOnly);
        CompleteElementHandler.fillSuggestions(groovyItems, result);
        if (groovyItems.isEmpty()) {
            String[] typeParameters = new String[typeNode.isUsingGenerics() && typeNode.getGenericsTypes() != null ? typeNode.getGenericsTypes().length : 0];
            for (int i = 0; i < typeParameters.length; ++i) {
                GenericsType genType = typeNode.getGenericsTypes()[i];
                typeParameters[i] = genType.getUpperBounds() != null ? Utilities.translateClassLoaderTypeName(genType.getUpperBounds()[0].getName()) : Utilities.translateClassLoaderTypeName(genType.getName());
            }
            CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getMethods(typeNode.getName(), prefix, anchor, typeParameters, leaf, modifiedAccess, nameOnly), result);
        }
        CompleteElementHandler.fillSuggestions(MetaElementHandler.forCompilationInfo(this.info).getMethods(typeNode.getName(), prefix, anchor, nameOnly), result);
        if (source != null) {
            CompleteElementHandler.fillSuggestions(DynamicElementHandler.forCompilationInfo(this.info).getMethods(source.getName(), typeNode.getName(), prefix, anchor, nameOnly, leaf, definition.getFileObject()), result);
        }
        if (typeNode.getSuperClass() != null) {
            CompleteElementHandler.fillSuggestions(this.getMethodsInner(source, typeNode.getSuperClass(), prefix, anchor, level + 1, modifiedAccess, nameOnly), result);
        } else if (leaf) {
            CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getMethods("java.lang.Object", prefix, anchor, new String[0], false, modifiedAccess, nameOnly), result);
        }
        for (ClassNode inter : typeNode.getInterfaces()) {
            CompleteElementHandler.fillSuggestions(this.getMethodsInner(source, inter, prefix, anchor, level + 1, modifiedAccess, nameOnly), result);
        }
        return result;
    }

    private Map<FieldSignature, CompletionItem> getFieldsInner(ClassNode source, ClassNode node, String prefix, int anchor, int level) {
        boolean leaf = level == 0;
        HashMap<FieldSignature, CompletionItem> result = new HashMap<FieldSignature, CompletionItem>();
        ClassDefinition definition = this.loadDefinition(node);
        ClassNode typeNode = definition.getNode();
        CompleteElementHandler.fillSuggestions(GroovyElementHandler.forCompilationInfo(this.info).getFields(this.index, typeNode.getName(), prefix, anchor, leaf), result);
        CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getFields(typeNode.getName(), prefix, anchor, leaf), result);
        CompleteElementHandler.fillSuggestions(MetaElementHandler.forCompilationInfo(this.info).getFields(typeNode.getName(), prefix, anchor), result);
        if (source != null) {
            CompleteElementHandler.fillSuggestions(DynamicElementHandler.forCompilationInfo(this.info).getFields(source.getName(), typeNode.getName(), prefix, anchor, leaf, definition.getFileObject()), result);
        }
        if (typeNode.getSuperClass() != null) {
            CompleteElementHandler.fillSuggestions(this.getFieldsInner(source, typeNode.getSuperClass(), prefix, anchor, level + 1), result);
        } else if (leaf) {
            CompleteElementHandler.fillSuggestions(JavaElementHandler.forCompilationInfo(this.info).getFields("java.lang.Object", prefix, anchor, false), result);
        }
        for (ClassNode inter : typeNode.getInterfaces()) {
            CompleteElementHandler.fillSuggestions(this.getFieldsInner(source, inter, prefix, anchor, level + 1), result);
        }
        return result;
    }

    private ClassDefinition loadDefinition(ClassNode node) {
        IndexedClass indexed;
        ASTNode astNode;
        if (this.index == null) {
            return new ClassDefinition(node, null);
        }
        Set<IndexedClass> classes = this.index.getClasses(node.getName(), QuerySupport.Kind.EXACT, true, false, false);
        if (!classes.isEmpty() && (astNode = ASTUtils.getForeignNode(indexed = classes.iterator().next())) instanceof ClassNode) {
            return new ClassDefinition((ClassNode)astNode, indexed);
        }
        return new ClassDefinition(node, null);
    }

    private static <T> void fillSuggestions(Map<T, ? extends CompletionItem> input, Map<T, ? super CompletionItem> result) {
        for (Map.Entry<T, CompletionItem> entry : input.entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
    }

    private static class ClassDefinition {
        private final ClassNode node;
        private final IndexedClass indexed;

        public ClassDefinition(ClassNode node, IndexedClass indexed) {
            this.node = node;
            this.indexed = indexed;
        }

        public ClassNode getNode() {
            return this.node;
        }

        public FileObject getFileObject() {
            return this.indexed != null ? this.indexed.getFileObject() : null;
        }
    }
}

