/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import groovy.lang.GroovyClassLoader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.groovy.editor.api.parser.CompilationUnit;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParser;
import org.openide.filesystems.FileObject;

public final class ClassNodeCache {
    private static final Logger LOG = Logger.getLogger(ClassNodeCache.class.getName());
    private static final ThreadLocal<ClassNodeCache> instance = new ThreadLocal();
    private static final int DEFAULT_NON_EXISTENT_CACHE_SIZE = 10000;
    private static final int NON_EXISTENT_CACHE_SIZE = Integer.getInteger("groovy.editor.ClassNodeCache.nonExistent.size", 10000);
    private final Map<CharSequence, ClassNode> cache = new HashMap<CharSequence, ClassNode>();
    private final Map<CharSequence, Void> nonExistent = new LinkedHashMap<CharSequence, Void>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<CharSequence, Void> eldest) {
            if (this.size() > NON_EXISTENT_CACHE_SIZE) {
                LOG.log(Level.FINE, "Non existent cache full, removing : {0}", eldest.getKey());
                return true;
            }
            return false;
        }
    };
    private Reference<JavaSource> resolver;
    private Reference<GroovyClassLoader> transformationLoaderRef;
    private Reference<GroovyClassLoader> resolveLoaderRef;
    private long invocationCount;
    private long hitCount;

    private ClassNodeCache() {
        LOG.fine("ClassNodeCache created");
    }

    @CheckForNull
    public ClassNode get(@NonNull CharSequence name) {
        ClassNode result = this.cache.get(name);
        if (LOG.isLoggable(Level.FINER)) {
            ++this.invocationCount;
            if (result != null) {
                ++this.hitCount;
            } else {
                LOG.log(Level.FINEST, "No binding for: {0}", name);
            }
            LOG.log(Level.FINER, "Hit ratio: {0}%", (double)this.hitCount / (double)this.invocationCount * 100.0);
        }
        return result;
    }

    public boolean isNonExistent(@NonNull CharSequence name) {
        boolean res = this.nonExistent.containsKey(name);
        if (LOG.isLoggable(Level.FINER)) {
            ++this.invocationCount;
            if (res) {
                ++this.hitCount;
            } else {
                LOG.log(Level.FINEST, "No binding for: {0}", name);
            }
            LOG.log(Level.FINER, "Hit ratio: {0}%", (double)this.hitCount / (double)this.invocationCount * 100.0);
        }
        return res;
    }

    public void put(@NonNull CharSequence name, @NullAllowed ClassNode node) {
        if (node != null) {
            LOG.log(Level.FINE, "Added binding for: {0}", name);
            this.cache.put(name, node);
        } else {
            LOG.log(Level.FINE, "Added nonexistent class: {0}", name);
            this.nonExistent.put(name, null);
        }
    }

    public boolean containsKey(@NonNull CharSequence name) {
        boolean result = this.cache.containsKey(name);
        if (LOG.isLoggable(Level.FINER)) {
            ++this.invocationCount;
            if (result) {
                ++this.hitCount;
            } else {
                LOG.log(Level.FINEST, "No binding for: {0}", name);
            }
            LOG.log(Level.FINER, "Hit ratio: {0}%", (double)this.hitCount / (double)this.invocationCount * 100.0);
        }
        return result;
    }

    @NonNull
    public JavaSource createResolver(@NonNull ClasspathInfo info) {
        JavaSource src;
        JavaSource javaSource = src = this.resolver == null ? null : this.resolver.get();
        if (src == null) {
            LOG.log(Level.FINE, "Javac resolver created.");
            src = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
            this.resolver = new SoftReference<JavaSource>(src);
        }
        return src;
    }

    public GroovyClassLoader createTransformationLoader(@NonNull ClassPath allResources, @NonNull CompilerConfiguration configuration) {
        GroovyClassLoader transformationLoader;
        GroovyClassLoader groovyClassLoader = transformationLoader = this.transformationLoaderRef == null ? null : this.transformationLoaderRef.get();
        if (transformationLoader == null) {
            LOG.log(Level.FINE, "Transformation ClassLoader created.");
            transformationLoader = new GroovyParser.TransformationClassLoader(CompilationUnit.class.getClassLoader(), allResources, configuration);
            this.transformationLoaderRef = new SoftReference<GroovyClassLoader>(transformationLoader);
        }
        return transformationLoader;
    }

    public GroovyClassLoader createResolveLoader(@NonNull ClassPath allResources, @NonNull CompilerConfiguration configuration) {
        GroovyClassLoader resolveLoader;
        GroovyClassLoader groovyClassLoader = resolveLoader = this.resolveLoaderRef == null ? null : this.resolveLoaderRef.get();
        if (resolveLoader == null) {
            LOG.log(Level.FINE, "Resolver ClassLoader created.");
            resolveLoader = new GroovyParser.ParsingClassLoader(allResources, configuration, this);
            this.resolveLoaderRef = new SoftReference<GroovyClassLoader>(resolveLoader);
        }
        return resolveLoader;
    }

    @NonNull
    public static ClassNodeCache get() {
        ClassNodeCache c = instance.get();
        if (c == null) {
            c = new ClassNodeCache();
        }
        return c;
    }

    public static ClassNodeCache createThreadLocalInstance() {
        ClassNodeCache c = new ClassNodeCache();
        instance.set(c);
        LOG.log(Level.FINE, "ClassNodeCache attached to thread: {0}", Thread.currentThread().getId());
        return c;
    }

    public static void clearThreadLocalInstance() {
        instance.remove();
        LOG.log(Level.FINE, "ClassNodeCache removed from thread: {0}", Thread.currentThread().getId());
    }
}

