/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.elements.common.IMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedElement;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;

public final class IndexedMethod
extends IndexedElement
implements IMethodElement {
    public static final int BLOCK = 64;
    public static final int BLOCK_OPTIONAL = 128;
    protected final String signature;
    private String[] args;
    private String name;
    private List<String> parameters;
    private boolean smart;
    private boolean inherited;
    private MethodType methodType = MethodType.METHOD;
    private final String returnType;

    private IndexedMethod(String signature, String returnType, GroovyIndex index, IndexResult result, String clz, String attributes, int flags) {
        super(index, result, clz, attributes, flags);
        this.signature = signature;
        this.returnType = returnType;
    }

    public static IndexedMethod create(GroovyIndex index, String signature, String returnType, String clz, IndexResult result, String attributes, int flags) {
        IndexedMethod m = new IndexedMethod(signature, returnType, index, result, clz, attributes, flags);
        return m;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void setMethodType(MethodType methodType) {
        this.methodType = methodType;
    }

    @Override
    public String toString() {
        return this.getSignature();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            int parenIndex = this.signature.indexOf(40);
            this.name = parenIndex == -1 ? this.signature : this.signature.substring(0, parenIndex);
        }
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getSignature() {
        return this.classFqn + "#" + this.signature;
    }

    private String[] getArgs() {
        if (this.args == null) {
            int parenIndex = this.signature.indexOf(40);
            if (parenIndex == -1) {
                return new String[0];
            }
            String argsPortion = this.signature.substring(parenIndex + 1, this.signature.length() - 1);
            this.args = argsPortion.split(",");
        }
        return this.args;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            String[] argArray = this.getArgs();
            if (argArray != null && argArray.length > 0) {
                this.parameters = new ArrayList<String>(argArray.length);
                for (String arg : argArray) {
                    this.parameters.add(arg);
                }
            } else {
                this.parameters = Collections.emptyList();
            }
        }
        return this.parameters;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public ElementKind getKind() {
        if (this.name == null && this.signature.startsWith("initialize(") || this.name != null && this.name.equals("initialize")) {
            return ElementKind.CONSTRUCTOR;
        }
        return ElementKind.METHOD;
    }

    public boolean isSmart() {
        return this.smart;
    }

    public void setSmart(boolean smart) {
        this.smart = smart;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedMethod other = (IndexedMethod)obj;
        if (!(this.signature == other.signature || this.signature != null && this.signature.equals(other.signature))) {
            return false;
        }
        if (!(this.classFqn == other.classFqn || this.classFqn != null && this.classFqn.equals(other.classFqn))) {
            return false;
        }
        return this.flags == other.flags;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.signature != null ? this.signature.hashCode() : 0);
        hash = 53 * hash + (this.classFqn != null ? this.classFqn.hashCode() : 0);
        hash = 53 * hash + this.flags;
        return hash;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean hasBlock() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isBlockOptional() {
        return (this.flags & 0x80) != 0;
    }

    public static String decodeFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        sb.append(IndexedElement.decodeFlags(flags));
        if ((flags & 0x40) != 0) {
            sb.append("|BLOCK");
        }
        if ((flags & 0x80) != 0) {
            sb.append("|BLOCK_OPTIONAL");
        }
        if (sb.length() > 0) {
            sb.append("|");
        }
        return sb.toString();
    }

    public String getEncodedAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isTopLevel() {
        return false;
    }

    public static enum MethodType {
        METHOD,
        ATTRIBUTE,
        DBCOLUMN;

    }
}

