/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements.ast;

import groovy.lang.MetaMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.groovy.editor.api.elements.ast.ASTElement;
import org.netbeans.modules.groovy.editor.api.elements.common.IMethodElement;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;

public class ASTMethod
extends ASTElement
implements IMethodElement {
    private List<String> parameters;
    private Class clz;
    private MetaMethod method;
    private boolean GDK;
    private String methodSignature;

    public ASTMethod(GroovyParserResult info, ASTNode node) {
        super(info, node);
    }

    public ASTMethod(GroovyParserResult info, ASTNode node, Class clz, MetaMethod method, boolean GDK) {
        super(info, node);
        this.clz = clz;
        this.method = method;
        this.GDK = GDK;
    }

    public boolean isGDK() {
        return this.GDK;
    }

    public MetaMethod getMethod() {
        return this.method;
    }

    public Class getClz() {
        return this.clz;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
            for (Parameter parameter : ((MethodNode)this.node).getParameters()) {
                this.parameters.add(parameter.getName());
            }
        }
        return this.parameters;
    }

    @Override
    public String getSignature() {
        if (this.methodSignature == null) {
            StringBuilder builder = new StringBuilder(super.getSignature());
            List<String> params = this.getParameters();
            if (params.size() > 0) {
                builder.append("(");
                for (String parameter : params) {
                    builder.append(parameter);
                    builder.append(",");
                }
                builder.setLength(builder.length() - 1);
                builder.append(")");
            }
            this.methodSignature = builder.toString();
        }
        return this.methodSignature;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.node instanceof ConstructorNode) {
                this.name = ((ConstructorNode)this.node).getDeclaringClass().getNameWithoutPackage();
            } else if (this.node instanceof MethodNode) {
                this.name = ((MethodNode)this.node).getName();
            }
            if (this.name == null) {
                this.name = this.node.toString();
            }
        }
        return this.name;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public ElementKind getKind() {
        if (this.node instanceof ConstructorNode) {
            return ElementKind.CONSTRUCTOR;
        }
        if (this.node instanceof MethodNode) {
            return ElementKind.METHOD;
        }
        return ElementKind.OTHER;
    }

    @Override
    public boolean isTopLevel() {
        return false;
    }

    @Override
    public boolean isInherited() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        if (this.node instanceof MethodNode) {
            for (AnnotationNode annotation : ((MethodNode)this.node).getAnnotations()) {
                if (!Deprecated.class.getName().equals(annotation.getClassNode().getName())) continue;
                return true;
            }
        }
        return false;
    }
}

