/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion.util;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.completion.util.ContextHelper;
import org.netbeans.modules.groovy.editor.api.completion.util.DotCompletionContext;
import org.netbeans.modules.groovy.editor.api.completion.util.GroovyTypeAnalyzer;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;

public class CompletionRequest {
    private static final Logger LOG = Logger.getLogger(CompletionRequest.class.getName());
    public int lexOffset;
    public int astOffset;
    public ParserResult info;
    public BaseDocument doc;
    public String prefix = "";
    public boolean scriptMode;
    public boolean behindImport;
    public CaretLocation location;
    public CompletionContext ctx;
    public AstPath path;
    public AstPath beforeDotPath;
    public ClassNode declaringClass;
    public DotCompletionContext dotContext;

    public CompletionRequest(int lexOffset, int astOffset, ParserResult info, BaseDocument doc, String prefix) {
        this.lexOffset = lexOffset;
        this.astOffset = astOffset;
        this.info = info;
        this.doc = doc;
        this.prefix = prefix;
        this.scriptMode = false;
    }

    public boolean initContextAttributes() {
        this.path = this.getPathFromRequest();
        LOG.log(Level.FINEST, "complete(...), path        : {0}", this.path);
        this.location = this.getCaretLocationFromRequest();
        LOG.log(Level.FINEST, "I am here in sourcecode: {0}", (Object)this.location);
        if (this.location == CaretLocation.ABOVE_PACKAGE || this.location == CaretLocation.INSIDE_COMMENT) {
            return false;
        }
        this.ctx = this.getCompletionContext();
        this.dotContext = this.getDotCompletionContext();
        this.declaringClass = this.getBeforeDotDeclaringClass();
        this.behindImport = this.checkForRequestBehindImportStatement();
        return true;
    }

    public boolean isBehindDot() {
        return this.dotContext != null;
    }

    private AstPath getPathFromRequest() {
        ModuleNode root = ASTUtils.getRoot(this.info);
        if (root == null) {
            LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            LOG.log(Level.FINEST, "request.info   = {0}", this.info);
            LOG.log(Level.FINEST, "request.prefix = {0}", this.prefix);
            return null;
        }
        return new AstPath((ASTNode)root, this.astOffset, this.doc);
    }

    private CaretLocation getCaretLocationFromRequest() {
        ASTNode node;
        Token t;
        int position = this.lexOffset;
        TokenSequence<GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence((Document)this.doc, position);
        ts.move(position);
        if (ts.isValid() && ts.moveNext() && ts.offset() < this.doc.getLength()) {
            Token tparent;
            t = ts.token();
            if (t.id() == GroovyTokenId.LINE_COMMENT || t.id() == GroovyTokenId.BLOCK_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
            if (t.id() == GroovyTokenId.STRING_LITERAL) {
                return CaretLocation.INSIDE_STRING;
            }
            if (t.id() == GroovyTokenId.NLS && ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && (tparent = ts.token()).id() == GroovyTokenId.LINE_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
        }
        ts.move(position);
        while (ts.isValid() && ts.moveNext() && ts.offset() < this.doc.getLength()) {
            t = ts.token();
            if (t.id() != GroovyTokenId.LITERAL_package) continue;
            return CaretLocation.ABOVE_PACKAGE;
        }
        boolean classDefBeforePosition = false;
        ts.move(position);
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0) {
            Token t2 = ts.token();
            if (t2.id() != GroovyTokenId.LITERAL_class && t2.id() != GroovyTokenId.LITERAL_interface) continue;
            classDefBeforePosition = true;
            break;
        }
        boolean classDefAfterPosition = false;
        ts.move(position);
        while (ts.isValid() && ts.moveNext() && ts.offset() < this.doc.getLength()) {
            Token t3 = ts.token();
            if (t3.id() != GroovyTokenId.LITERAL_class && t3.id() != GroovyTokenId.LITERAL_interface) continue;
            classDefAfterPosition = true;
            break;
        }
        if (this.path != null && (node = this.path.root()) instanceof ModuleNode) {
            ModuleNode module = (ModuleNode)node;
            String name = null;
            for (ClassNode clazz : module.getClasses()) {
                if (!clazz.isScript()) continue;
                name = clazz.getName();
                this.scriptMode = true;
                break;
            }
            if (name != null) {
                for (ClassNode clazz : module.getClasses()) {
                    if (clazz.isScript() || !name.equals(clazz.getName())) continue;
                    this.scriptMode = false;
                    break;
                }
            }
        }
        if (!this.scriptMode && !classDefBeforePosition && classDefAfterPosition) {
            return CaretLocation.ABOVE_FIRST_CLASS;
        }
        if (!classDefBeforePosition && this.scriptMode) {
            return CaretLocation.INSIDE_METHOD;
        }
        if (this.path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        for (ASTNode current : this.path) {
            if (current instanceof ClosureExpression) {
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (current instanceof FieldNode) {
                FieldNode fn = (FieldNode)current;
                if (!fn.isClosureSharedVariable()) continue;
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (current instanceof MethodNode) {
                return CaretLocation.INSIDE_METHOD;
            }
            if (current instanceof ClassNode) {
                return CaretLocation.INSIDE_CLASS;
            }
            if (current instanceof ModuleNode) {
                return CaretLocation.OUTSIDE_CLASSES;
            }
            if (!(current instanceof Parameter)) continue;
            return CaretLocation.INSIDE_PARAMETERS;
        }
        return CaretLocation.UNDEFINED;
    }

    private CompletionContext getCompletionContext() {
        Token t;
        int position = this.lexOffset;
        Token beforeLiteral = null;
        Token before2 = null;
        Token before1 = null;
        Token active = null;
        Token after1 = null;
        Token after2 = null;
        Token afterLiteral = null;
        TokenSequence<GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence((Document)this.doc, position);
        int difference = ts.move(position);
        if (ts.isValid() && ts.moveNext() && ts.offset() >= 0) {
            active = ts.token();
        }
        if (active != null) {
            if (active.id() == GroovyTokenId.WHITESPACE && difference == 0) {
                LOG.log(Level.FINEST, "ts.movePrevious() - 1");
                ts.movePrevious();
            } else if (active.id() == GroovyTokenId.NLS) {
                ts.movePrevious();
                if (ts.token().id() == GroovyTokenId.DOT) {
                    ts.moveNext();
                } else {
                    LOG.log(Level.FINEST, "ts.movePrevious() - 2");
                }
            }
        }
        int stopAt = 0;
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && (t = ts.token()).id() != GroovyTokenId.NLS) {
            if (t.id() == GroovyTokenId.WHITESPACE) continue;
            if (stopAt == 0) {
                before1 = t;
            } else if (stopAt == 1) {
                before2 = t;
            } else if (stopAt == 2) break;
            ++stopAt;
        }
        ts.move(position);
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && (t = ts.token()).id() != GroovyTokenId.NLS && t.id() != GroovyTokenId.LBRACE) {
            if (!((GroovyTokenId)t.id()).primaryCategory().equals("keyword")) continue;
            beforeLiteral = t;
            break;
        }
        ts.move(position);
        while (ts.isValid() && ts.moveNext() && ts.offset() < this.doc.getLength() && (t = ts.token()).id() != GroovyTokenId.NLS && t.id() != GroovyTokenId.RBRACE) {
            if (!((GroovyTokenId)t.id()).primaryCategory().equals("keyword")) continue;
            afterLiteral = t;
            break;
        }
        ts.move(position);
        stopAt = 0;
        while (ts.isValid() && ts.moveNext() && ts.offset() < this.doc.getLength() && (t = ts.token()).id() != GroovyTokenId.NLS) {
            if (t.id() == GroovyTokenId.WHITESPACE) continue;
            if (stopAt == 0) {
                after1 = t;
            } else if (stopAt == 1) {
                after2 = t;
            } else if (stopAt == 2) break;
            ++stopAt;
        }
        LOG.log(Level.FINEST, "---------------------------------------------------------------");
        LOG.log(Level.FINEST, "move() diff   : {0}", difference);
        LOG.log(Level.FINEST, "beforeLiteral : {0}", beforeLiteral);
        LOG.log(Level.FINEST, "before2       : {0}", before2);
        LOG.log(Level.FINEST, "before1       : {0}", before1);
        LOG.log(Level.FINEST, "active        : {0}", active);
        LOG.log(Level.FINEST, "after1        : {0}", after1);
        LOG.log(Level.FINEST, "after2        : {0}", after2);
        LOG.log(Level.FINEST, "afterLiteral  : {0}", afterLiteral);
        return new CompletionContext((Token<GroovyTokenId>)beforeLiteral, (Token<GroovyTokenId>)before2, (Token<GroovyTokenId>)before1, (Token<GroovyTokenId>)active, (Token<GroovyTokenId>)after1, (Token<GroovyTokenId>)after2, (Token<GroovyTokenId>)afterLiteral, ts);
    }

    private DotCompletionContext getDotCompletionContext() {
        Token t;
        if (this.dotContext != null) {
            return this.dotContext;
        }
        int position = this.lexOffset;
        TokenSequence<GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence((Document)this.doc, position);
        int difference = ts.move(position);
        Token active = null;
        if (ts.isValid() && ts.moveNext() && ts.offset() >= 0) {
            active = ts.token();
        }
        if (LOG.isLoggable(Level.FINE) && ts.isValid() && active != null) {
            LOG.log(Level.FINE, "Current token text {0}", active.text());
        }
        if (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && ts.token().id() != GroovyTokenId.DOT && ts.token().id() != GroovyTokenId.NLS && ts.token().id() != GroovyTokenId.WHITESPACE && ts.token().id() != GroovyTokenId.OPTIONAL_DOT && ts.token().id() != GroovyTokenId.MEMBER_POINTER) {
            if (ts.token().id() != GroovyTokenId.IDENTIFIER && !((GroovyTokenId)ts.token().id()).primaryCategory().equals("keyword")) {
                return null;
            }
            ts.movePrevious();
        }
        boolean remainingTokens = true;
        if (ts.token().id() != GroovyTokenId.DOT && ts.token().id() != GroovyTokenId.OPTIONAL_DOT && ts.token().id() != GroovyTokenId.MEMBER_POINTER) {
            Token t2;
            while (ts.isValid() && (remainingTokens = ts.movePrevious()) && ts.offset() >= 0 && ((t2 = ts.token()).id() == GroovyTokenId.WHITESPACE || t2.id() == GroovyTokenId.NLS)) {
            }
        }
        if (ts.token().id() != GroovyTokenId.DOT && ts.token().id() != GroovyTokenId.OPTIONAL_DOT && ts.token().id() != GroovyTokenId.MEMBER_POINTER || !remainingTokens) {
            return null;
        }
        boolean methodsOnly = false;
        if (ts.token().id() == GroovyTokenId.MEMBER_POINTER) {
            methodsOnly = true;
        }
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && ((t = ts.token()).id() == GroovyTokenId.WHITESPACE || t.id() == GroovyTokenId.NLS)) {
        }
        int lexOffset = ts.offset();
        int astOffset = ASTUtils.getAstOffset((Parser.Result)this.info, lexOffset);
        AstPath realPath = this.getPath(this.info, this.doc, astOffset);
        return new DotCompletionContext(lexOffset, astOffset, realPath, methodsOnly);
    }

    private AstPath getPath(ParserResult info, BaseDocument doc, int astOffset) {
        ModuleNode root = ASTUtils.getRoot(info);
        if (root == null) {
            LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            LOG.log(Level.FINEST, "request.info   = {0}", info);
            return null;
        }
        return new AstPath((ASTNode)root, astOffset, doc);
    }

    public ClassNode getBeforeDotDeclaringClass() {
        if (this.declaringClass != null && this.declaringClass instanceof ClassNode) {
            LOG.log(Level.FINEST, "returning declaringClass from request.");
            return this.declaringClass;
        }
        DotCompletionContext dotCompletionContext = this.getDotCompletionContext();
        if (!(this.isBehindDot() || this.ctx.before1 != null || this.location != CaretLocation.INSIDE_CLOSURE && this.location != CaretLocation.INSIDE_METHOD)) {
            this.declaringClass = ContextHelper.getSurroundingClassNode(this);
            return this.declaringClass;
        }
        if (dotCompletionContext == null || dotCompletionContext.getAstPath() == null || dotCompletionContext.getAstPath().leaf() == null) {
            return null;
        }
        this.beforeDotPath = dotCompletionContext.getAstPath();
        Object declClass = null;
        GroovyTypeAnalyzer typeAnalyzer = new GroovyTypeAnalyzer(this.doc);
        Set<ClassNode> infered = typeAnalyzer.getTypes(dotCompletionContext.getAstPath(), dotCompletionContext.getAstOffset());
        if (!infered.isEmpty()) {
            return infered.iterator().next();
        }
        if (declClass != null) {
            this.declaringClass = declClass;
            return this.declaringClass;
        }
        if (dotCompletionContext.getAstPath().leaf() instanceof VariableExpression) {
            VariableExpression variable = (VariableExpression)dotCompletionContext.getAstPath().leaf();
            if ("this".equals(variable.getName())) {
                this.declaringClass = ContextHelper.getSurroundingClassNode(this);
                return this.declaringClass;
            }
            if ("super".equals(variable.getName())) {
                ClassNode thisClass = ContextHelper.getSurroundingClassNode(this);
                this.declaringClass = thisClass.getSuperClass();
                if (this.declaringClass == null) {
                    return new ClassNode("java.lang.Object", 1, null);
                }
                return this.declaringClass;
            }
        }
        if (dotCompletionContext.getAstPath().leaf() instanceof Expression) {
            ConstantExpression constantExpression;
            Expression expression = (Expression)dotCompletionContext.getAstPath().leaf();
            if (expression instanceof RangeExpression && "java.lang.Object".equals(expression.getType().getName())) {
                try {
                    expression.setType(new ClassNode(Class.forName("groovy.lang.Range")));
                }
                catch (ClassNotFoundException ex) {
                    expression.setType(new ClassNode("groovy.lang.Range", 513, null));
                }
            } else if (expression instanceof ConstantExpression && !(constantExpression = (ConstantExpression)expression).isNullExpression()) {
                constantExpression.setType(new ClassNode(constantExpression.getValue().getClass()));
            }
            this.declaringClass = expression.getType();
        }
        return this.declaringClass;
    }

    private boolean checkForRequestBehindImportStatement() {
        int rowStart = 0;
        int nonWhite = 0;
        try {
            rowStart = Utilities.getRowStart((BaseDocument)this.doc, (int)this.lexOffset);
            nonWhite = Utilities.getFirstNonWhiteFwd((BaseDocument)this.doc, (int)rowStart);
        }
        catch (BadLocationException ex) {
            LOG.log(Level.FINEST, "Trouble doing getRowStart() or getFirstNonWhiteFwd(): {0}", ex.getMessage());
        }
        Token<GroovyTokenId> importToken = LexUtilities.getToken(this.doc, nonWhite);
        if (importToken != null && importToken.id() == GroovyTokenId.LITERAL_import) {
            LOG.log(Level.FINEST, "Right behind an import statement");
            return true;
        }
        return false;
    }
}

