/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.Elements;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.GroovyUtils;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.impl.BaseCompletion;
import org.netbeans.modules.groovy.editor.api.completion.util.CamelCaseUtil;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionRequest;
import org.netbeans.modules.groovy.editor.api.completion.util.ContextHelper;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedClass;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;

public class TypesCompletion
extends BaseCompletion {
    private List<CompletionProposal> proposals;
    private CompletionRequest request;
    private int anchor;
    private boolean constructorCompletion;

    @Override
    public boolean complete(List<CompletionProposal> proposals, CompletionRequest request, int anchor) {
        LOG.log(Level.FINEST, "-> completeTypes");
        this.proposals = proposals;
        this.request = request;
        this.anchor = anchor;
        BaseCompletion.PackageCompletionRequest packageRequest = this.getPackageRequest(request);
        if (packageRequest.basePackage.length() == 0 && packageRequest.prefix.length() == 0 && packageRequest.fullString.equals(".")) {
            return false;
        }
        this.constructorCompletion = ContextHelper.isConstructorCall(request);
        boolean onlyInterfaces = false;
        Token<GroovyTokenId> literal = request.ctx.beforeLiteral;
        if (literal != null) {
            if (literal.id() == GroovyTokenId.LITERAL_class) {
                return false;
            }
            if (literal.id() == GroovyTokenId.LITERAL_implements) {
                LOG.log(Level.FINEST, "Completing only interfaces after implements keyword.");
                onlyInterfaces = true;
            }
        }
        HashSet<TypeHolder> addedTypes = new HashSet<TypeHolder>();
        ModuleNode moduleNode = ContextHelper.getSurroundingModuleNode(request);
        String currentPackage = this.getCurrentPackageName(moduleNode);
        JavaSource javaSource = this.getJavaSourceFromRequest();
        if (packageRequest.basePackage.length() > 0 || request.behindImport) {
            if (!request.behindImport || packageRequest.basePackage.length() != 0) {
                List<TypeHolder> typeList = this.getTypeHoldersForPackage(javaSource, packageRequest.basePackage, currentPackage);
                LOG.log(Level.FINEST, "Number of types found:  {0}", typeList.size());
                for (TypeHolder singleType : typeList) {
                    this.addToProposalUsingFilter(addedTypes, singleType, onlyInterfaces);
                }
            }
            return true;
        }
        if (request.isBehindDot()) {
            return false;
        }
        if (moduleNode != null) {
            LOG.log(Level.FINEST, "We are living in package : {0} ", currentPackage);
            GroovyIndex index = null;
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            if (fo != null) {
                index = GroovyIndex.get(QuerySupport.findRoots((FileObject)fo, Collections.singleton("classpath/source"), Collections.emptyList(), Collections.emptyList()));
            }
            if (index != null) {
                String camelCaseFirstWord = CamelCaseUtil.getCamelCaseFirstWord(request.prefix);
                Set<IndexedClass> classes = index.getClasses(camelCaseFirstWord, QuerySupport.Kind.PREFIX, true, false, false);
                if (classes.isEmpty()) {
                    LOG.log(Level.FINEST, "Nothing found in GroovyIndex");
                } else {
                    LOG.log(Level.FINEST, "Found this number of classes : {0} ", classes.size());
                    HashSet<TypeHolder> typelist = new HashSet<TypeHolder>();
                    for (IndexedClass indexedClass : classes) {
                        LOG.log(Level.FINEST, "FQN classname from index : {0} ", indexedClass.getFqn());
                        ElementKind ek = indexedClass.getKind() == org.netbeans.modules.csl.api.ElementKind.CLASS ? ElementKind.CLASS : ElementKind.INTERFACE;
                        typelist.add(new TypeHolder(indexedClass.getFqn(), ek));
                    }
                    for (TypeHolder type : typelist) {
                        this.addToProposalUsingFilter(addedTypes, type, onlyInterfaces);
                    }
                }
            }
        }
        ArrayList<String> localDefaultImports = new ArrayList<String>();
        if (moduleNode != null) {
            List<ImportNode> imports = moduleNode.getImports();
            if (imports != null) {
                for (ImportNode importNode : imports) {
                    ElementKind ek = importNode.getType().isInterface() ? ElementKind.INTERFACE : ElementKind.CLASS;
                    this.addToProposalUsingFilter(addedTypes, new TypeHolder(importNode.getClassName(), ek), onlyInterfaces);
                }
            }
            List<ImportNode> importNodes = moduleNode.getStarImports();
            for (ImportNode wildcardImport : importNodes) {
                localDefaultImports.add(wildcardImport.getPackageName());
            }
        }
        localDefaultImports.addAll(GroovyUtils.DEFAULT_IMPORT_PACKAGES);
        for (String singlePackage : localDefaultImports) {
            List<TypeHolder> typeList = this.getTypeHoldersForPackage(javaSource, singlePackage, currentPackage);
            LOG.log(Level.FINEST, "Number of types found:  {0}", typeList.size());
            for (TypeHolder element : typeList) {
                this.addToProposalUsingFilter(addedTypes, element, onlyInterfaces);
            }
        }
        for (String className : GroovyUtils.DEFAULT_IMPORT_CLASSES) {
            this.addToProposalUsingFilter(addedTypes, new TypeHolder(className, ElementKind.CLASS), onlyInterfaces);
        }
        for (ClassNode declaredClass : ContextHelper.getDeclaredClasses(request)) {
            this.addToProposalUsingFilter(addedTypes, new TypeHolder(declaredClass.getName(), ElementKind.CLASS), onlyInterfaces);
        }
        return true;
    }

    private String getCurrentPackageName(ModuleNode moduleNode) {
        if (moduleNode != null) {
            return moduleNode.getPackageName();
        }
        ClassNode node = ContextHelper.getSurroundingClassNode(this.request);
        if (node != null) {
            return node.getPackageName();
        }
        return "";
    }

    private JavaSource getJavaSourceFromRequest() {
        ClasspathInfo pathInfo = this.getClasspathInfoFromRequest(this.request);
        assert (pathInfo != null);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)pathInfo, (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            LOG.log(Level.FINEST, "Problem retrieving JavaSource from ClassPathInfo, exiting.");
            return null;
        }
        return javaSource;
    }

    private void addToProposalUsingFilter(Set<TypeHolder> alreadyPresent, TypeHolder type, boolean onlyInterfaces) {
        CompletionItem.TypeItem camelCaseProposal;
        if (onlyInterfaces && type.getKind() != ElementKind.INTERFACE || alreadyPresent.contains(type)) {
            return;
        }
        String typeName = GroovyUtils.stripPackage(type.getName());
        if (this.constructorCompletion && typeName.toUpperCase().equals(this.request.prefix.toUpperCase())) {
            return;
        }
        if (this.isPrefixed(this.request, typeName)) {
            alreadyPresent.add(type);
            this.proposals.add((CompletionProposal)new CompletionItem.TypeItem(typeName, this.anchor, type.getKind()));
        }
        if (CamelCaseUtil.compareCamelCase(typeName, this.request.prefix) && !this.proposals.contains((Object)(camelCaseProposal = new CompletionItem.TypeItem(typeName, this.anchor, ElementKind.CLASS)))) {
            this.proposals.add((CompletionProposal)camelCaseProposal);
        }
    }

    @NonNull
    private List<TypeHolder> getTypeHoldersForPackage(JavaSource javaSource, final String pkg, final String currentPackage) {
        LOG.log(Level.FINEST, "getElementListForPackageAsString(), Package :  {0}", pkg);
        final ArrayList<TypeHolder> result = new ArrayList<TypeHolder>();
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController info) {
                        Elements elements = info.getElements();
                        if (elements != null && pkg != null) {
                            BaseCompletion.LOG.log(Level.FINEST, "TypeSearcherHelper.run(), elements retrieved");
                            PackageElement packageElement = elements.getPackageElement(pkg);
                            if (packageElement == null) {
                                BaseCompletion.LOG.log(Level.FINEST, "packageElement is null");
                            } else {
                                List<? extends Element> typelist = packageElement.getEnclosedElements();
                                boolean samePackage = pkg.equals(currentPackage);
                                for (Element element : typelist) {
                                    Set<Modifier> modifiers = element.getModifiers();
                                    if (!modifiers.contains((Object)Modifier.PUBLIC) && (!samePackage || !modifiers.contains((Object)Modifier.PROTECTED) && (modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PRIVATE)))) continue;
                                    result.add(new TypeHolder(element.toString(), element.getKind()));
                                }
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                LOG.log(Level.FINEST, "IOException : {0}", ex.getMessage());
            }
        }
        return result;
    }

    private static class TypeHolder {
        private final String name;
        private final ElementKind kind;

        public TypeHolder(String name, ElementKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeHolder other = (TypeHolder)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.kind == other.kind;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 59 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }
    }
}

