/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion.impl;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.groovy.editor.api.completion.impl.BaseCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.ConstructorGenerationCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.FieldCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.KeywordCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.LocalVarCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.MethodCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.NewVarCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.PackageCompletion;
import org.netbeans.modules.groovy.editor.api.completion.impl.TypesCompletion;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionRequest;

public class ProposalsCollector {
    private List<CompletionProposal> proposals;
    private int anchor;
    private BaseCompletion typesCompletion;
    private BaseCompletion fieldCompletion;
    private BaseCompletion methodCompletion;
    private BaseCompletion newVarCompletion;
    private BaseCompletion keywordCompletion;
    private BaseCompletion packageCompletion;
    private BaseCompletion localVarCompletion;
    private BaseCompletion camelCaseCompletion;

    public ProposalsCollector(int anchor) {
        this.anchor = anchor;
        this.proposals = new ArrayList<CompletionProposal>();
        this.typesCompletion = new TypesCompletion();
        this.fieldCompletion = new FieldCompletion();
        this.methodCompletion = new MethodCompletion();
        this.newVarCompletion = new NewVarCompletion();
        this.keywordCompletion = new KeywordCompletion();
        this.packageCompletion = new PackageCompletion();
        this.localVarCompletion = new LocalVarCompletion();
        this.camelCaseCompletion = new ConstructorGenerationCompletion();
    }

    public void completeKeywords(CompletionRequest completionRequest) {
        this.keywordCompletion.complete(this.proposals, completionRequest, this.anchor);
    }

    public void completeMethods(CompletionRequest completionRequest) {
        this.methodCompletion.complete(this.proposals, completionRequest, this.anchor);
    }

    public void completeFields(CompletionRequest completionRequest) {
        this.fieldCompletion.complete(this.proposals, completionRequest, this.anchor);
    }

    public void completeCamelCase(CompletionRequest request) {
        this.camelCaseCompletion.complete(this.proposals, request, this.anchor);
    }

    public void completeTypes(CompletionRequest request) {
        this.typesCompletion.complete(this.proposals, request, this.anchor);
    }

    public void completePackages(CompletionRequest request) {
        this.packageCompletion.complete(this.proposals, request, this.anchor);
    }

    public void completeLocalVars(CompletionRequest request) {
        this.localVarCompletion.complete(this.proposals, request, this.anchor);
    }

    public void completeNewVars(CompletionRequest request) {
        this.newVarCompletion.complete(this.proposals, request, this.anchor);
    }

    public List<CompletionProposal> getCollectedProposals() {
        return this.proposals;
    }

    public void clearProposals() {
        this.proposals.clear();
    }
}

