/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion.impl;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.impl.BaseCompletion;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionRequest;

public class PackageCompletion
extends BaseCompletion {
    @Override
    public boolean complete(List<CompletionProposal> proposals, CompletionRequest request, int anchor) {
        LOG.log(Level.FINEST, "-> completePackages");
        BaseCompletion.PackageCompletionRequest packageRequest = this.getPackageRequest(request);
        if (request.isBehindDot() && packageRequest.basePackage.length() <= 0) {
            return false;
        }
        LOG.log(Level.FINEST, "Token fullString = >{0}<", packageRequest.fullString);
        ClasspathInfo pathInfo = this.getClasspathInfoFromRequest(request);
        assert (pathInfo != null) : "Can not get ClasspathInfo";
        if (request.ctx.before1 != null && CharSequenceUtilities.textEquals((CharSequence)request.ctx.before1.text(), (CharSequence)"*") && request.behindImport) {
            return false;
        }
        Set pkgSet = pathInfo.getClassIndex().getPackageNames(packageRequest.fullString, true, EnumSet.allOf(ClassIndex.SearchScope.class));
        for (String singlePackage : pkgSet) {
            LOG.log(Level.FINEST, "PKG set item: {0}", singlePackage);
            if (packageRequest.prefix.equals("")) {
                singlePackage = singlePackage.substring(packageRequest.fullString.length());
            } else if (!packageRequest.basePackage.equals("")) {
                singlePackage = singlePackage.substring(packageRequest.basePackage.length() + 1);
            }
            if (!singlePackage.startsWith(packageRequest.prefix) || singlePackage.length() <= 0) continue;
            CompletionItem.PackageItem item = new CompletionItem.PackageItem(singlePackage, anchor, request.info);
            if (request.behindImport) {
                item.setSmart(true);
            }
            proposals.add((CompletionProposal)item);
        }
        return false;
    }
}

