/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.groovy.editor.api.GroovyUtils;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.completion.impl.BaseCompletion;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionRequest;
import org.netbeans.modules.groovy.editor.api.completion.util.ContextHelper;
import org.netbeans.modules.groovy.editor.completion.CompleteElementHandler;
import org.openide.filesystems.FileObject;

public class MethodCompletion
extends BaseCompletion {
    private List<CompletionProposal> proposals;
    private CompletionRequest request;
    private int anchor;

    @Override
    public boolean complete(List<CompletionProposal> proposals, CompletionRequest request, int anchor) {
        ClasspathInfo pathInfo;
        LOG.log(Level.FINEST, "-> completeMethods");
        this.proposals = proposals;
        this.request = request;
        this.anchor = anchor;
        if (request.location == CaretLocation.INSIDE_PARAMETERS) {
            LOG.log(Level.FINEST, "no method completion inside of parameters");
            return false;
        }
        if (request == null || request.ctx == null) {
            return false;
        }
        if (ContextHelper.isConstructorCall(request)) {
            return this.completeConstructor();
        }
        if (!request.isBehindDot() && request.ctx.before1 != null) {
            return false;
        }
        if (request.declaringClass == null) {
            LOG.log(Level.FINEST, "No declaring class found");
            return false;
        }
        BaseCompletion.PackageCompletionRequest packageRequest = this.getPackageRequest(request);
        if (packageRequest.basePackage.length() > 0 && this.isValidPackage(pathInfo = this.getClasspathInfoFromRequest(request), packageRequest.basePackage)) {
            LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
            return false;
        }
        Map<MethodSignature, CompletionItem> result = CompleteElementHandler.forCompilationInfo(request.info).getMethods(ContextHelper.getSurroundingClassNode(request), request.declaringClass, request.prefix, anchor, request.dotContext != null && request.dotContext.isMethodsOnly());
        proposals.addAll(result.values());
        return true;
    }

    private boolean completeConstructor() {
        LOG.log(Level.FINEST, "This looks like a constructor ...");
        JavaSource javaSource = this.getJavaSourceFromRequest();
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController info) {
                        ArrayList typelist = new ArrayList();
                        for (String importName : MethodCompletion.this.getAllImports()) {
                            typelist.addAll(MethodCompletion.this.getElementListFor(info.getElements(), importName));
                        }
                        BaseCompletion.LOG.log(Level.FINEST, "Number of types found:  {0}", typelist.size());
                        if (MethodCompletion.this.exactConstructorExists(typelist, ((MethodCompletion)MethodCompletion.this).request.prefix)) {
                            MethodCompletion.this.addExactProposals(typelist);
                        }
                        MethodCompletion.this.addConstructorProposalsForDeclaredClasses();
                    }
                }, true);
            }
            catch (IOException ex) {
                LOG.log(Level.FINEST, "IOException : {0}", ex.getMessage());
            }
        }
        return !this.proposals.isEmpty();
    }

    private List<String> getAllImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.addAll(GroovyUtils.DEFAULT_IMPORT_PACKAGES);
        imports.addAll(this.getImportedTypes());
        imports.addAll(this.getTypesInSamePackage());
        imports.addAll(this.getTypesInSameFile());
        return imports;
    }

    private List<String> getImportedTypes() {
        ArrayList<String> importedTypes = new ArrayList<String>();
        ModuleNode moduleNode = ContextHelper.getSurroundingModuleNode(this.request);
        if (moduleNode != null) {
            for (ImportNode importNode : moduleNode.getImports()) {
                importedTypes.add(importNode.getClassName());
            }
            for (ImportNode wildcardImport : moduleNode.getStarImports()) {
                importedTypes.add(wildcardImport.getPackageName());
            }
        }
        return importedTypes;
    }

    private List<String> getTypesInSamePackage() {
        String packageName;
        ModuleNode moduleNode = ContextHelper.getSurroundingModuleNode(this.request);
        if (moduleNode != null && (packageName = ContextHelper.getSurroundingModuleNode(this.request).getPackageName()) != null) {
            packageName = packageName.substring(0, packageName.length() - 1);
            return Collections.singletonList(packageName);
        }
        return Collections.emptyList();
    }

    private List<String> getTypesInSameFile() {
        ArrayList<String> declaredClassNames = new ArrayList<String>();
        List<ClassNode> declaredClasses = ContextHelper.getDeclaredClasses(this.request);
        for (ClassNode declaredClass : declaredClasses) {
            declaredClassNames.add(declaredClass.getName());
        }
        return declaredClassNames;
    }

    private boolean exactConstructorExists(List<? extends Element> typelist, String prefix) {
        for (Element element : typelist) {
            if (!prefix.toUpperCase().equals(element.getSimpleName().toString().toUpperCase())) continue;
            return true;
        }
        return false;
    }

    private void addExactProposals(List<? extends Element> typelist) {
        for (Element element : typelist) {
            if (element.getKind() != ElementKind.CLASS) continue;
            for (Element element2 : element.getEnclosedElements()) {
                String constructorName;
                if (element2.getKind() != ElementKind.CONSTRUCTOR || !(constructorName = element.getSimpleName().toString()).toUpperCase().equals(this.request.prefix.toUpperCase())) continue;
                this.addConstructorProposal(constructorName, (ExecutableElement)element2);
            }
        }
    }

    private void addConstructorProposal(String constructorName, ExecutableElement encl) {
        List<CompletionItem.ParameterDescriptor> paramList;
        String paramListString = this.getParameterListForMethod(encl);
        CompletionItem.ConstructorItem constructor = new CompletionItem.ConstructorItem(constructorName, paramListString, paramList = this.getParameterList(encl), this.anchor, false);
        if (!this.proposals.contains((Object)constructor)) {
            this.proposals.add((CompletionProposal)constructor);
        }
    }

    private void addConstructorProposalsForDeclaredClasses() {
        for (ClassNode declaredClass : ContextHelper.getDeclaredClasses(this.request)) {
            this.addConstructorProposal(declaredClass);
        }
    }

    private void addConstructorProposal(ClassNode classNode) {
        String constructorName = classNode.getNameWithoutPackage();
        if (this.isPrefixed(this.request, constructorName)) {
            for (ConstructorNode constructor : classNode.getDeclaredConstructors()) {
                Parameter[] parameters = constructor.getParameters();
                String paramListString = this.getParameterListStringForMethod(parameters);
                List<CompletionItem.ParameterDescriptor> paramList = this.getParameterListForMethod(parameters);
                this.proposals.add((CompletionProposal)new CompletionItem.ConstructorItem(constructorName, paramListString, paramList, this.anchor, false));
            }
        }
    }

    private JavaSource getJavaSourceFromRequest() {
        ClasspathInfo pathInfo = this.getClasspathInfoFromRequest(this.request);
        assert (pathInfo != null);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)pathInfo, (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            LOG.log(Level.FINEST, "Problem retrieving JavaSource from ClassPathInfo, exiting.");
            return null;
        }
        return javaSource;
    }

    @NonNull
    private List<? extends Element> getElementListFor(Elements elements, String importName) {
        if (elements != null && importName != null) {
            PackageElement packageElement = elements.getPackageElement(importName);
            if (packageElement != null) {
                return packageElement.getEnclosedElements();
            }
            TypeElement typeElement = elements.getTypeElement(importName);
            if (typeElement != null) {
                return Collections.singletonList(typeElement);
            }
        }
        return Collections.emptyList();
    }

    private List<CompletionItem.ParameterDescriptor> getParameterList(ExecutableElement exe) {
        ArrayList<CompletionItem.ParameterDescriptor> paramList = new ArrayList<CompletionItem.ParameterDescriptor>();
        if (exe != null) {
            try {
                List<? extends VariableElement> params = exe.getParameters();
                int i = 1;
                for (VariableElement variableElement : params) {
                    String fullName;
                    TypeMirror tm = variableElement.asType();
                    String name = fullName = ((Object)tm).toString();
                    if (tm.getKind() == TypeKind.DECLARED) {
                        name = GroovyUtils.stripPackage(fullName);
                    }
                    String varName = "param" + String.valueOf(i);
                    paramList.add(new CompletionItem.ParameterDescriptor(fullName, name, varName));
                    ++i;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return paramList;
    }

    private String getParameterListForMethod(ExecutableElement exe) {
        StringBuilder sb = new StringBuilder();
        if (exe != null) {
            try {
                List<? extends VariableElement> params = exe.getParameters();
                for (VariableElement variableElement : params) {
                    TypeMirror tm = variableElement.asType();
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if (tm.getKind() == TypeKind.DECLARED || tm.getKind() == TypeKind.ARRAY) {
                        sb.append(GroovyUtils.stripPackage(((Object)tm).toString()));
                        continue;
                    }
                    sb.append(((Object)tm).toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private String getParameterListStringForMethod(Parameter[] parameters) {
        if (parameters.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Parameter param : parameters) {
            sb.append(param.getType().getNameWithoutPackage()).append(", ");
        }
        return sb.substring(0, sb.lastIndexOf(","));
    }

    private List<CompletionItem.ParameterDescriptor> getParameterListForMethod(Parameter[] parameters) {
        if (parameters.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CompletionItem.ParameterDescriptor> paramDescriptors = new ArrayList<CompletionItem.ParameterDescriptor>();
        for (Parameter param : parameters) {
            String fullTypeName = param.getType().getName();
            String typeName = param.getType().getNameWithoutPackage();
            String name = param.getName();
            paramDescriptors.add(new CompletionItem.ParameterDescriptor(fullTypeName, typeName, name));
        }
        return paramDescriptors;
    }
}

