/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion.impl;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.codehaus.groovy.ast.ClassNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.impl.BaseCompletion;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionRequest;
import org.netbeans.modules.groovy.editor.api.completion.util.ContextHelper;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.completion.CompleteElementHandler;

public class FieldCompletion
extends BaseCompletion {
    @Override
    public boolean complete(List<CompletionProposal> proposals, CompletionRequest request, int anchor) {
        FieldSignature prefixFieldSignature;
        Map<FieldSignature, CompletionItem> result;
        ClassNode declaringClass;
        LOG.log(Level.FINEST, "-> completeFields");
        if (request.location == CaretLocation.INSIDE_PARAMETERS && !request.isBehindDot()) {
            LOG.log(Level.FINEST, "no fields completion inside of parameters-list");
            return false;
        }
        if (request.dotContext != null && request.dotContext.isMethodsOnly()) {
            return false;
        }
        if (request.ctx.beforeLiteral != null && request.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_implements || request.ctx.beforeLiteral != null && request.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_extends) {
            return false;
        }
        if (request.ctx.beforeLiteral != null && request.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_class) {
            return false;
        }
        if (request.isBehindDot()) {
            ClasspathInfo pathInfo;
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            BaseCompletion.PackageCompletionRequest packageRequest = this.getPackageRequest(request);
            if (packageRequest.basePackage.length() > 0 && this.isValidPackage(pathInfo = this.getClasspathInfoFromRequest(request), packageRequest.basePackage)) {
                LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
                return false;
            }
            declaringClass = request.declaringClass;
        } else {
            declaringClass = ContextHelper.getSurroundingClassNode(request);
        }
        if (declaringClass == null) {
            LOG.log(Level.FINEST, "No declaring class found");
            return false;
        }
        int anchorShift = 0;
        String fieldName = request.prefix;
        if (request.prefix.startsWith("$")) {
            fieldName = request.prefix.substring(1);
            anchorShift = 1;
        }
        if ((result = CompleteElementHandler.forCompilationInfo(request.info).getFields(ContextHelper.getSurroundingClassNode(request), declaringClass, fieldName, anchor + anchorShift)).containsKey(prefixFieldSignature = new FieldSignature(request.prefix))) {
            result.remove(prefixFieldSignature);
        }
        proposals.addAll(result.values());
        return true;
    }
}

