/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion.impl;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.codehaus.groovy.ast.ClassNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.groovy.editor.api.GroovyUtils;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.impl.BaseCompletion;
import org.netbeans.modules.groovy.editor.api.completion.util.CamelCaseUtil;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionRequest;
import org.netbeans.modules.groovy.editor.api.completion.util.ContextHelper;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;

public class ConstructorGenerationCompletion
extends BaseCompletion {
    @Override
    public boolean complete(List<CompletionProposal> proposals, CompletionRequest request, int anchor) {
        LOG.log(Level.FINEST, "-> constructor generation completion");
        if (!this.isValidLocation(request)) {
            return false;
        }
        ClassNode requestedClass = ContextHelper.getSurroundingClassNode(request);
        if (requestedClass == null) {
            LOG.log(Level.FINEST, "No surrounding class found, bail out ...");
            return false;
        }
        String className = GroovyUtils.stripPackage(requestedClass.getName());
        boolean camelCaseMatch = CamelCaseUtil.compareCamelCase(className, request.prefix);
        if (camelCaseMatch) {
            LOG.log(Level.FINEST, "Prefix matches Class's CamelCase signature. Adding.");
            proposals.add((CompletionProposal)new CompletionItem.ConstructorItem(className, "", Collections.EMPTY_LIST, anchor, true));
        }
        return camelCaseMatch;
    }

    private boolean isValidLocation(CompletionRequest request) {
        if (request.location != CaretLocation.INSIDE_CLASS) {
            LOG.log(Level.FINEST, "Not inside a class");
            return false;
        }
        if (request.ctx.before1 != null && ((Object)request.ctx.before1.text()).toString().equals("new") && request.prefix.length() > 0) {
            return false;
        }
        if (request.ctx.beforeLiteral != null && request.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_implements || request.ctx.beforeLiteral != null && request.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_extends) {
            return false;
        }
        if (request.prefix == null || request.prefix.length() < 0) {
            return false;
        }
        if (request.ctx.before1 != null && request.ctx.before1.id() == GroovyTokenId.IDENTIFIER) {
            request.ctx.ts.movePrevious();
            Token caretToken = request.ctx.ts.token();
            if (" ".equals(((Object)caretToken.text()).toString())) {
                return false;
            }
        }
        return request.ctx.beforeLiteral == null || request.ctx.beforeLiteral.id() != GroovyTokenId.LITERAL_class;
    }
}

