/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.netbeans.modules.groovy.editor.api.elements.index.IndexedMethod;

public class Methods {
    public static boolean isSameMethod(ExecutableElement javaMethod, MethodCallExpression methodCall) {
        ConstantExpression methodName = (ConstantExpression)methodCall.getMethod();
        return javaMethod.getSimpleName().contentEquals(methodName.getText()) && Methods.getParameterCount(methodCall) == javaMethod.getParameters().size();
    }

    public static boolean isSameMethod(MethodNode methodNode, MethodCallExpression methodCall) {
        return methodNode.getName().equals(methodCall.getMethodAsString()) && Methods.getParameterCount(methodCall) == methodNode.getParameters().length;
    }

    public static boolean isSameMethod(MethodNode methodNode1, MethodNode methodNode2) {
        Parameter[] params2;
        Parameter[] params1;
        if (methodNode1.getName().equals(methodNode2.getName()) && (params1 = methodNode1.getParameters()).length == (params2 = methodNode2.getParameters()).length) {
            for (int i = 0; i < params1.length; ++i) {
                ClassNode type2;
                ClassNode type1 = params1[i].getType();
                if (type1.equals(type2 = params2[i].getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSameMethod(MethodCallExpression methodCall1, MethodCallExpression methodCall2) {
        String method1 = methodCall1.getMethodAsString();
        if (method1 != null && method1.equals(methodCall2.getMethodAsString())) {
            int size1 = Methods.getParameterCount(methodCall1);
            int size2 = Methods.getParameterCount(methodCall2);
            if (size1 >= 0 && size1 == size2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSameConstructor(ConstructorNode constructor, ConstructorCallExpression call) {
        return constructor.getDeclaringClass().getNameWithoutPackage().equals(call.getType().getNameWithoutPackage()) && Methods.getParameterCount(call) == constructor.getParameters().length;
    }

    public static boolean isSameConstuctor(ConstructorCallExpression call1, ConstructorCallExpression call2) {
        String constructor1 = call1.getType().getNameWithoutPackage();
        if (constructor1 != null && constructor1.equals(call2.getType().getNameWithoutPackage())) {
            int size1 = Methods.getParameterCount(call1);
            int size2 = Methods.getParameterCount(call2);
            if (size1 >= 0 && size1 == size2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSameConstructor(ConstructorNode constructor1, ConstructorNode constructor2) {
        return Methods.isSameMethod((MethodNode)constructor1, constructor2);
    }

    private static int getParameterCount(MethodCallExpression methodCall) {
        Expression expression = methodCall.getArguments();
        if (expression instanceof ArgumentListExpression) {
            return ((ArgumentListExpression)expression).getExpressions().size();
        }
        if (expression instanceof NamedArgumentListExpression) {
            return 1;
        }
        return -1;
    }

    private static int getParameterCount(ConstructorCallExpression constructorCall) {
        Expression expression = constructorCall.getArguments();
        if (expression instanceof ArgumentListExpression) {
            return ((ArgumentListExpression)expression).getExpressions().size();
        }
        if (expression instanceof NamedArgumentListExpression) {
            return 1;
        }
        return -1;
    }

    public static boolean hasSameParameters(IndexedMethod indexedMethod, MethodNode method) {
        return Methods.isSameList(indexedMethod.getParameters(), Methods.getMethodParams(method));
    }

    public static boolean hasSameParameters(IndexedMethod indexedMethod, MethodCallExpression methodCall) {
        return Methods.isSameList(indexedMethod.getParameters(), Methods.getMethodParams(methodCall));
    }

    public static boolean hasSameParameters(MethodNode methodNode, MethodCallExpression methodCall) {
        return Methods.isSameList(Methods.getMethodParams(methodNode), Methods.getMethodParams(methodCall));
    }

    public static boolean isSameList(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<String> getMethodParams(MethodNode methodNode) {
        ArrayList<String> params = new ArrayList<String>();
        for (Parameter param : methodNode.getParameters()) {
            params.add(ElementUtils.getTypeName(param));
        }
        return params;
    }

    private static List<String> getMethodParams(MethodCallExpression methodCall) {
        ArgumentListExpression argumentList;
        ArrayList<String> params = new ArrayList<String>();
        Expression arguments = methodCall.getArguments();
        if (arguments instanceof ArgumentListExpression && (argumentList = (ArgumentListExpression)arguments).getExpressions().size() > 0) {
            for (Expression argument : argumentList.getExpressions()) {
                params.add(ElementUtils.getTypeName(argument.getType()));
            }
        }
        return params;
    }
}

