/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;

public final class GroovyUtils {
    public static final Set<String> DEFAULT_IMPORT_PACKAGES;
    public static final Set<String> DEFAULT_IMPORT_CLASSES;

    private GroovyUtils() {
    }

    public static String getLineCommentPrefix() {
        return "//";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$';
    }

    public static String stripPackage(String fqn) {
        if (fqn.contains(".")) {
            int idx = fqn.lastIndexOf(".");
            fqn = fqn.substring(idx + 1);
        }
        return fqn.replace(";", "");
    }

    public static boolean isRowWhite(String text, int offset) throws BadLocationException {
        try {
            char c;
            int i;
            for (i = offset; i < text.length() && (c = text.charAt(i)) != '\n'; ++i) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            for (i = offset - 1; i >= 0 && (c = text.charAt(i)) != '\n'; --i) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static boolean isRowEmpty(String text, int offset) throws BadLocationException {
        try {
            char c;
            if (offset < text.length() && (c = text.charAt(offset)) != '\n' && (c != '\r' || offset != text.length() - 1 && text.charAt(offset + 1) != '\n')) {
                return false;
            }
            return offset == 0 || text.charAt(offset - 1) == '\n';
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static int getRowLastNonWhite(String text, int offset) throws BadLocationException {
        try {
            char c;
            int i;
            for (i = offset; i < text.length() && (c = text.charAt(i)) != '\n' && (c != '\r' || i != text.length() - 1 && text.charAt(i + 1) != '\n'); ++i) {
            }
            --i;
            while (i >= 0) {
                c = text.charAt(i);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static int getRowFirstNonWhite(String text, int offset) throws BadLocationException {
        try {
            char c;
            int i;
            if (i < text.length()) {
                for (i = offset - 1; i >= 0 && (c = text.charAt(i)) != '\n'; --i) {
                }
                ++i;
            }
            while (i < text.length()) {
                c = text.charAt(i);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    public static int getRowStart(String text, int offset) throws BadLocationException {
        try {
            for (int i = offset - 1; i >= 0; --i) {
                char c = text.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
            return 0;
        }
        catch (IndexOutOfBoundsException ex) {
            throw GroovyUtils.getBadLocationException(ex, text, offset);
        }
    }

    static BadLocationException getBadLocationException(IndexOutOfBoundsException ex, String text, int offset) {
        BadLocationException ble = new BadLocationException(offset + " out of " + text.length(), offset);
        ble.initCause(ex);
        return ble;
    }

    static {
        HashSet defaultImportPackages = new HashSet(7);
        Collections.addAll(defaultImportPackages, "java.io", "java.lang", "java.net", "java.util", "groovy.util", "groovy.lang");
        DEFAULT_IMPORT_PACKAGES = Collections.unmodifiableSet(defaultImportPackages);
        HashSet defaultImportClasses = new HashSet(3);
        Collections.addAll(defaultImportClasses, "java.math.BigDecimal", "java.math.BigInteger");
        DEFAULT_IMPORT_CLASSES = Collections.unmodifiableSet(defaultImportClasses);
    }
}

